/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationProperties.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpNetworkRegistration
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpNetworkRegistrationProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusHfpNetworkRegistrationProperties::EvolutionGeniviDbusHfpNetworkRegistrationProperties() :
   DbusProperties("NetworkRegistration"),
   // properties
   _propertyStatus("Status"),
   _propertyMobileCountryCode("MobileCountryCode"),
   _propertyName("Name"),
   _propertyStrength("Strength"),
   _propertyCurrentOperator("CurrentOperator")
{
   _string2EnumList[_propertyStatus] = (int)HFP_NETWORK_REGISTRATION_STATUS;
   _string2EnumList[_propertyMobileCountryCode] = (int)HFP_NETWORK_REGISTRATION_MOBILECOUNTRYCODE;
   _string2EnumList[_propertyName] = (int)HFP_NETWORK_REGISTRATION_NAME;
   _string2EnumList[_propertyStrength] = (int)HFP_NETWORK_REGISTRATION_STRENGTH;
   _string2EnumList[_propertyCurrentOperator] = (int)HFP_NETWORK_REGISTRATION_CURRENTOPERATOR;

   _enum2StringList[(int)HFP_NETWORK_REGISTRATION_STATUS] = &_propertyStatus;
   _enum2StringList[(int)HFP_NETWORK_REGISTRATION_MOBILECOUNTRYCODE] = &_propertyMobileCountryCode;
   _enum2StringList[(int)HFP_NETWORK_REGISTRATION_NAME] = &_propertyName;
   _enum2StringList[(int)HFP_NETWORK_REGISTRATION_STRENGTH] = &_propertyStrength;
   _enum2StringList[(int)HFP_NETWORK_REGISTRATION_CURRENTOPERATOR] = &_propertyCurrentOperator;
}

EvolutionGeniviDbusHfpNetworkRegistrationProperties::~EvolutionGeniviDbusHfpNetworkRegistrationProperties()
{
}

HfpNetworkRegistrationProperty EvolutionGeniviDbusHfpNetworkRegistrationProperties::getProperty2Enum(
      const ::std::string& value) const
{
   return (HfpNetworkRegistrationProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusHfpNetworkRegistrationProperties::getProperty2String(
      const HfpNetworkRegistrationProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpNetworkRegistrationProperties::getProperty2StringTrace(
      const HfpNetworkRegistrationProperty value) const
{
   if(HFP_NETWORK_REGISTRATION_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
