/**
 * @file EvolutionGeniviDbusHfpModemCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpModem
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpModemCallBackIf.h"
#include "IEvolutionGeniviDbusHfpHandsfreeRequestIf.h"
#include "IBtStackWrapper.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::Modem;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpModemCallBackIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpModemCallBackIf::EvolutionGeniviDbusHfpModemCallBackIf()
{
   _btStackWrapper = nullptr;
}

EvolutionGeniviDbusHfpModemCallBackIf::EvolutionGeniviDbusHfpModemCallBackIf(IBtStackWrapper* btStackWrapper)
{
   _btStackWrapper = btStackWrapper;
}

EvolutionGeniviDbusHfpModemCallBackIf::~EvolutionGeniviDbusHfpModemCallBackIf()
{
   _btStackWrapper = nullptr;
}

void EvolutionGeniviDbusHfpModemCallBackIf::onProxyAvailable(const ServiceState previousState,
      const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpModemCallBackIf::onProxyUnavailable(const ServiceState previousState,
      const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpModemCallBackIf::onGetPropertiesError(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< GetPropertiesError >& error)
{
   ETG_TRACE_USR4(("onGetPropertiesError(): Modem"));

   (void)(proxy);
   (void)(error);

   //TODO: implement
}

void EvolutionGeniviDbusHfpModemCallBackIf::onGetPropertiesResponse(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   ETG_TRACE_USR4(("onGetPropertiesResponse(): Modem"));

   // check received properties for Powered, Name, Interfaces, Type, Manufacturer, Model, Revision and Serial
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   BTSDbusPropertyList outPropertyList;

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("Modem: ObjPath: %s", objPath.c_str()));

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpModemProperty2String(::ccdbusif::evolution::HFP_MODEM_INTERFACES),
         (int)::ccdbusif::evolution::IF_MODEM))
   {
      //onModemInterfacesChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   //TODO: implement other properties if required
}

void EvolutionGeniviDbusHfpModemCallBackIf::onSetPropertyError(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< SetPropertyError >& error)
{
   (void)(proxy);
   (void)(error);

   //TODO: implement
}

void EvolutionGeniviDbusHfpModemCallBackIf::onSetPropertyResponse(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< SetPropertyResponse >& response)
{
   (void)(proxy);
   (void)(response);

   //TODO: implement
}

void EvolutionGeniviDbusHfpModemCallBackIf::onAcceptSCOConnectError(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< AcceptSCOConnectError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onAcceptSCOConnectError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpModemCallBackIf::onAcceptSCOConnectResponse(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< AcceptSCOConnectResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onAcceptSCOConnectResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpModemCallBackIf::onPropertyChangedError(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpModemCallBackIf::onPropertyChangedError"));
}

void EvolutionGeniviDbusHfpModemCallBackIf::onPropertyChangedSignal(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   ETG_TRACE_USR4(("onPropertyChangedSignal(): Modem"));

   // check received properties for Powered, Name, Interfaces, Type, Manufacturer, Model, Revision and Serial
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   ::ccdbusif::evolution::HfpModemProperty propEnum = parser.getHfpModemProperty2Enum(signal->getName());

   BTSDbusPropertyList outPropertyList;
   parser.parseProperty(outPropertyList, signal->getValueMutable(), signal->getName(),
         (int)::ccdbusif::evolution::IF_MODEM);

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("Modem: ObjPath: %s", objPath.c_str()));

   if(::ccdbusif::evolution::HFP_MODEM_INTERFACES == propEnum)
   {
      //onModemInterfacesChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();

   //TODO: implement other properties if required
}

void EvolutionGeniviDbusHfpModemCallBackIf::onSCOConnectRequestError(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< SCOConnectRequestError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpModemCallBackIf::onSCOConnectRequestError"));
}

void EvolutionGeniviDbusHfpModemCallBackIf::onSCOConnectRequestSignal(const ::boost::shared_ptr< ModemProxy >& proxy,
      const ::boost::shared_ptr< SCOConnectRequestSignal >& signal)
{
   ETG_TRACE_USR4(("onSCOConnectRequestSignal(): Modem"));

   const std::string& objPath = proxy->getDBusObjectPath();
   const uint8_t type = signal->getType();

   ETG_TRACE_USR4(("SCOConnectRequest: ObjectPath: %s", objPath.c_str()));
   ETG_TRACE_USR4(("SCOConnectRequest: Type: %d", type));

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSCOConnectRequestSignal(objPath, type);
   }
}

void EvolutionGeniviDbusHfpModemCallBackIf::onModemInterfacesChanged(const ::std::string& modemObjPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("Modem: Property: Interfaces"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      BTSDbusInterfaceList interfaces;

      const ::std::vector<std::string>& strArray = outProperty.propData.getStringArray();
      interfaces.reserve(strArray.size());
      ::ccdbusif::evolution::Interface item;
      ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;

      for(size_t j = 0; j < strArray.size(); j++)
      {
         ETG_TRACE_USR4(("Modem: Value: %s", strArray[j].c_str()));

         item = parser.getInterface2Enum(strArray[j]);
         interfaces.push_back(item);

         if(::ccdbusif::evolution::IF_HANDSFREE == item)
         {
            if(nullptr != _btStackWrapper)
            {
               _btStackWrapper->deviceCreated(modemObjPath);
            }
         }
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpModemCallBackIf::onModemInterfacesChanged:Property list size exceeds max limit"));
   }
}

} //evobtstackwrapper
