/**
 * @file IEvolutionGeniviDbusHfpVoiceCallCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HandsfreeVoiceCall
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpVoiceCallCallBackIf_h
#define IEvolutionGeniviDbusHfpVoiceCallCallBackIf_h

#include "org/ofono/VoiceCallProxy.h"
#include <string>

using namespace ::asf::core;

namespace evobtstackwrapper {

/**
 * Callback interface class for HandsfreeVoiceCall.
 */
class IEvolutionGeniviDbusHfpVoiceCallCallBackIf :
   public ::org::ofono::VoiceCall::GetPropertiesCallbackIF,
   public ::org::ofono::VoiceCall::HangupCallbackIF,
   public ::org::ofono::VoiceCall::AnswerCallbackIF,
   public ::org::ofono::VoiceCall::HoldCallbackIF,
   public ::org::ofono::VoiceCall::PropertyChangedCallbackIF
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpVoiceCallCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpVoiceCallCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for GetProperties request
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] error - reference to GetPropertiesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::GetPropertiesError >& error) override = 0;

   /**
    * Callback method for GetProperties request
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] response - reference to GetPropertiesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::GetPropertiesResponse >& response) override = 0;

   /**
    * Error callback method for Hangup request
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] error - reference to HangupError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::HangupError >& error) override = 0;

   /**
    * Callback method for Hangup request
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] response - reference to HangupResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHangupResponse(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::HangupResponse >& response) override = 0;

   /**
    * Error callback method for Answer request
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] error - reference to AnswerError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAnswerError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::AnswerError >& error) override = 0;

   /**
    * Callback method for Answer request
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] response - reference to AnswerResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAnswerResponse(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::AnswerResponse >& response) override = 0;

   /**
    * Error callback method for Hold request
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] error - reference to HoldError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHoldError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::HoldError >& error) override = 0;

   /**
    * Callback method for Hold request
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] response - reference to HoldResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHoldResponse(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::HoldResponse >& response) override = 0;

   /**
    * Error callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] error - reference to PropertyChangedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::PropertyChangedError >& error) override = 0;

   /**
    * Callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of VoiceCall proxy
    * @param[in] signal - reference to PropertyChangedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::VoiceCall::VoiceCallProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::VoiceCall::PropertyChangedSignal >& signal) override = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpVoiceCallCallBackIf_h
