/**
 * @file IEvolutionGeniviDbusHfpSiriCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpSiri
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpSiriCallBackIf_h
#define IEvolutionGeniviDbusHfpSiriCallBackIf_h

#include "org/ofono/evo/SiriProxy.h"
#include <string>

using namespace ::asf::core;

namespace evobtstackwrapper {

/**
 * Callback interface class for HfpSiri.
 */
class IEvolutionGeniviDbusHfpSiriCallBackIf :
   public ::org::ofono::evo::Siri::GetPropertiesCallbackIF,
   public ::org::ofono::evo::Siri::EnableCallbackIF,
   public ::org::ofono::evo::Siri::SetNRCallbackIF,
   public ::org::ofono::evo::Siri::SetPropertyCallbackIF,
   public ::org::ofono::evo::Siri::PropertyChangedCallbackIF
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpSiriCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for GetProperties request
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] error - reference to GetPropertiesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::GetPropertiesError >& error) override = 0;

   /**
    * Callback method for GetProperties request
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] response - reference to GetPropertiesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::GetPropertiesResponse >& response) override = 0;

   /**
    * Error callback method for Enable request
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] error - reference to EnableError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEnableError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::EnableError >& error) override = 0;

   /**
    * Callback method for Enable request
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] response - reference to EnableResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEnableResponse(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::EnableResponse >& response) override = 0;

   /**
    * Error callback method for SetNR request
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] error - reference to SetNRError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetNRError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::SetNRError >& error) override = 0;

   /**
    * Callback method for SetNR request
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] response - reference to SetNRResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetNRResponse(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::SetNRResponse >& response) override = 0;

   /**
    * Error callback method for SetProperty request
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] error - reference to SetPropertyError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::SetPropertyError >& error) override = 0;

   /**
    * Callback method for SetProperty request
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] response - reference to SetPropertyResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::SetPropertyResponse >& response) override = 0;

   /**
    * Error callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] error - reference to PropertyChangedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::PropertyChangedError >& error) override = 0;

   /**
    * Callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of Siri proxy
    * @param[in] signal - reference to PropertyChangedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::PropertyChangedSignal >& signal) override = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpSiriCallBackIf_h
