/**
 * @file IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpNetworkOperator
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf_h
#define IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf_h

#include "org/ofono/NetworkOperatorProxy.h"
#include <string>

using namespace ::asf::core;

namespace evobtstackwrapper {

/**
 * Callback interface class for HfpNetworkOperator.
 */
class IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf :
   public ::org::ofono::NetworkOperator::GetPropertiesCallbackIF,
   public ::org::ofono::NetworkOperator::PropertyChangedCallbackIF
{
public:
   /**
    * Destructor of IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) = 0;

protected:
   /**
    * Error callback method for GetProperties request
    *
    * @param[in] proxy - reference of NetworkOperator proxy
    * @param[in] error - reference to GetPropertiesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::NetworkOperatorProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::GetPropertiesError >& error) override = 0;

   /**
    * Callback method for GetProperties request
    *
    * @param[in] proxy - reference of NetworkOperator proxy
    * @param[in] response - reference to GetPropertiesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::NetworkOperatorProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::GetPropertiesResponse >& response) override = 0;

   /**
    * Error callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of NetworkOperator proxy
    * @param[in] error - reference to PropertyChangedError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::NetworkOperatorProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::PropertyChangedError >& error) override = 0;

   /**
    * Callback method for PropertyChanged signal
    *
    * @param[in] proxy - reference of NetworkOperator proxy
    * @param[in] signal - reference to PropertyChangedSignal
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::NetworkOperatorProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::PropertyChangedSignal >& signal) override = 0;
};

} //evobtstackwrapper

#endif //IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf_h
