/**
 * @file EvolutionGeniviDbusHfpVoiceCallRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpVoiceCall
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpVoiceCallRequestIf_h
#define EvolutionGeniviDbusHfpVoiceCallRequestIf_h

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpVoiceCallRequestIf.h"
#include "ProxyManager.h"
#include "org/ofono/VoiceCallProxy.h"
#include "asf/core/Proxy.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpVoiceCallCallBackIf;

/**
 * HfpVoiceCall proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpVoiceCallRequestIf final :
   public ServiceAvailableIF,
   public ::ccdbusif::ICcDbusIfCreateProxy,
   public ::ccdbusif::ICcDbusIfDestroyProxy,
   public ::ccdbusif::ICcDbusIfCreateRuntimeProxy,
   public ::ccdbusif::ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpVoiceCallRequestIf
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpVoiceCallRequestIf();

   /**
    * Destructor of EvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpVoiceCallRequestIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpVoiceCallCallBackIf* callbackIf) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return bool - true- Created voice call proxy, false- proxy is already present.
    */
   virtual bool voiceCallCreated(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void voiceCallRemoved(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendHangupRequest(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendAnswerRequest(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpVoiceCallRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendHoldRequest(const ::std::string& objPath) override;

private:
   ::ccdbusif::ProxyManager< ::org::ofono::VoiceCall::VoiceCallProxy > _hfpVoiceCallProxy; /**< ProxyManager for VoiceCall */
   IEvolutionGeniviDbusHfpVoiceCallCallBackIf* _callbackIf; /**< pointer to VoiceCall callback interface */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpVoiceCallRequestIf_h
