/**
 * @file EvolutionGeniviDbusHfpSiriProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpSiri
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpSiriProperties_h
#define EvolutionGeniviDbusHfpSiriProperties_h

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpSiri properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpSiriProperties : public DbusProperties
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpSiriProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpSiriProperties();

   /**
    * Destructor of EvolutionGeniviDbusHfpSiriProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpSiriProperties();

   /**
    * This method is used to convert the property string to enum value
    *
    * @param[in] value - property name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpSiriProperty - property enum value
    */
   HfpSiriProperty getProperty2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the property enum value to string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2String(const HfpSiriProperty value) const;

   /**
    * This method is used to convert the property enum value to trace string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2StringTrace(const HfpSiriProperty value) const;

private:
   const ::std::string _propertyStatus;        /**< property Status */
   const ::std::string _propertyNR;            /**< property NR */
   const ::std::string _propertyEyesFreeMode;  /**< property EyesFreeMode */
   const ::std::string _propertySupportedType; /**< property SupportedType */
};

} //evolution
} //ccdbusif

#endif //EvolutionGeniviDbusHfpSiriProperties_h
