/**
 * @file EvolutionGeniviDbusHfpSiriCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpSiri
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpSiriCallBackIf_h
#define EvolutionGeniviDbusHfpSiriCallBackIf_h

#include "IEvolutionGeniviDbusHfpSiriCallBackIf.h"
#include "BtStackWrapperTypesInternal.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

// class forward declarations
class IBtStackWrapper;

/**
 * HfpSiri callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpSiriCallBackIf : public IEvolutionGeniviDbusHfpSiriCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpSiriCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpSiriCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpSiriCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::GetPropertiesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::GetPropertiesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEnableError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::EnableError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onEnableResponse(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::EnableResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetNRError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::SetNRError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetNRResponse(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::SetNRResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::SetPropertyError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::SetPropertyResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::PropertyChangedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpSiriCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::evo::Siri::SiriProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::evo::Siri::PropertyChangedSignal >& signal) override;

private:
   /**
    * This method is used to notify the SiriStatus changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onSiriStatusChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the SiriNR changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onSiriNRChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the SiriEyesFreeMode changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onSiriEyesFreeModeChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the SiriSupportedType changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onSiriSupportedTypeChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   IBtStackWrapper* _btStackWrapper; /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpSiriCallBackIf_h
