/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpNetworkRegistration
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpNetworkRegistrationRequestIf_h
#define EvolutionGeniviDbusHfpNetworkRegistrationRequestIf_h

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "ICcDbusIfCreateRuntimeProxy.h"
#include "ICcDbusIfDestroyRuntimeProxy.h"
#include "IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf.h"
#include "ProxyManager.h"
#include "org/ofono/NetworkRegistrationProxy.h"
#include "asf/core/Proxy.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

// class forward declarations
class IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf;

/**
 * HfpNetworkRegistration proxy class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpNetworkRegistrationRequestIf final :
   public ServiceAvailableIF,
   public ::ccdbusif::ICcDbusIfCreateProxy,
   public ::ccdbusif::ICcDbusIfDestroyProxy,
   public ::ccdbusif::ICcDbusIfCreateRuntimeProxy,
   public ::ccdbusif::ICcDbusIfDestroyRuntimeProxy,
   public IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpNetworkRegistrationRequestIf();

   /**
    * Destructor of EvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpNetworkRegistrationRequestIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyProxy(void) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyRuntimeProxy(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf* callbackIf) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void deviceCreated(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void deviceRemoved(const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetPropertiesRequest(const ::std::string& objPath) override;

private:
   ::ccdbusif::ProxyManager< ::org::ofono::NetworkRegistration::NetworkRegistrationProxy > _hfpNetworkRegistrationProxy;
                                                                      /**< ProxyManager for NetworkRegistration */
   IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf* _callbackIf; /**< pointer to NetworkRegistration callback interface */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpNetworkRegistrationRequestIf_h
