/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpNetworkRegistration
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpNetworkRegistrationProperties_h
#define EvolutionGeniviDbusHfpNetworkRegistrationProperties_h

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpNetworkRegistration properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpNetworkRegistrationProperties : public DbusProperties
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpNetworkRegistrationProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpNetworkRegistrationProperties();

   /**
    * Destructor of EvolutionGeniviDbusHfpNetworkRegistrationProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpNetworkRegistrationProperties();

   /**
    * This method is used to convert the property string to enum value
    *
    * @param[in] value - property name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpNetworkRegistrationProperty - property enum value
    */
   HfpNetworkRegistrationProperty getProperty2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the property enum value to string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2String(const HfpNetworkRegistrationProperty value) const;

   /**
    * This method is used to convert the property enum value to trace string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2StringTrace(const HfpNetworkRegistrationProperty value) const;

private:
   const ::std::string _propertyStatus;            /**< property Status */
   const ::std::string _propertyMobileCountryCode; /**< property MobileCountryCode */
   const ::std::string _propertyName;              /**< property Name */
   const ::std::string _propertyStrength;          /**< property Strength */
   const ::std::string _propertyCurrentOperator;   /**< property CurrentOperator */
};

} //evolution
} //ccdbusif

#endif //EvolutionGeniviDbusHfpNetworkRegistrationProperties_h
