/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpNetworkRegistration
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf_h
#define EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf_h

#include "IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf.h"
#include "BtStackWrapperTypesInternal.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

//class forward declarations
class IBtStackWrapper;

/**
 * HfpNetworkRegistration callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf : public IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(
         const ::boost::shared_ptr< ::org::ofono::NetworkRegistration::NetworkRegistrationProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkRegistration::GetPropertiesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(
         const ::boost::shared_ptr< ::org::ofono::NetworkRegistration::NetworkRegistrationProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkRegistration::GetPropertiesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr<
         ::org::ofono::NetworkRegistration::NetworkRegistrationProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkRegistration::PropertyChangedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(
         const ::boost::shared_ptr< ::org::ofono::NetworkRegistration::NetworkRegistrationProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkRegistration::PropertyChangedSignal >& signal) override;

private:
   /**
    * This method is used to notify the NetworkStatus changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onNetworkStatusChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the NetworkMobileCountryCode changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onNetworkMobileCountryCodeChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the NetworkOperatorName changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onNetworkOperatorNameChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the NetworkSignalStrength changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onNetworkSignalStrengthChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the NetworkCurrentOperator changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onNetworkCurrentOperatorChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   IBtStackWrapper* _btStackWrapper; /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpNetworkRegistrationCallBackIf_h
