/**
 * @file EvolutionGeniviDbusHfpNetworkOperatorCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpNetworkOperator
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpNetworkOperatorCallBackIf_h
#define EvolutionGeniviDbusHfpNetworkOperatorCallBackIf_h

#include "IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf.h"
#include "BtStackWrapperTypesInternal.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

// class forward declarations
class IBtStackWrapper;

/**
 * HfpNetworkOperator callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpNetworkOperatorCallBackIf : public IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpNetworkOperatorCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpNetworkOperatorCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpNetworkOperatorCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::NetworkOperatorProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::GetPropertiesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::NetworkOperatorProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::GetPropertiesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::NetworkOperatorProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::PropertyChangedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpNetworkOperatorCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::NetworkOperatorProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::NetworkOperator::PropertyChangedSignal >& signal) override;

private:
   /**
    * This method is used to notify the NetworkOperatorName changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onNetworkOperatorNameChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the NetworkStatus changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onNetworkStatusChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   IBtStackWrapper* _btStackWrapper; /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpNetworkOperatorCallBackIf_h
