/**
 * @file EvolutionGeniviDbusHfpModemProperties.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpModem
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpModemProperties_h
#define EvolutionGeniviDbusHfpModemProperties_h

#include "DbusProperties.h"
#include "EvolutionGeniviDbusTypes.h"

namespace ccdbusif {
namespace evolution {

/**
 * HfpModem properties class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpModemProperties : public DbusProperties
{
public:
   /**
    * Constructor of EvolutionGeniviDbusHfpModemProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpModemProperties();

   /**
    * Destructor of EvolutionGeniviDbusHfpModemProperties class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpModemProperties();

   /**
    * This method is used to convert the property string to enum value
    *
    * @param[in] value - property name
    * @param[out]
    * @param[in,out]
    *
    * @return HfpModemProperty - property enum value
    */
   HfpModemProperty getProperty2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the modem interface string to enum value
    *
    * @param[in] value - modem interface string
    * @param[out]
    * @param[in,out]
    *
    * @return HfpModemInterfaces - modem interface enum value
    */
   HfpModemInterfaces getInterface2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the modem type string to enum value
    *
    * @param[in] value - modem type string
    * @param[out]
    * @param[in,out]
    *
    * @return HfpModemTypeSuppValues - modem type enum value
    */
   HfpModemTypeSuppValues getType2Enum(const ::std::string& value) const;

   /**
    * This method is used to convert the property enum value to string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2String(const HfpModemProperty value) const;

   /**
    * This method is used to convert the property enum value to trace string
    *
    * @param[in] value - property enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - property name
    */
   const ::std::string& getProperty2StringTrace(const HfpModemProperty value) const;

   /**
    * This method is used to convert the modem interface enum value to trace string
    *
    * @param[in] value - modem interface enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - modem interface string
    */
   const ::std::string& getInterface2StringTrace(const HfpModemInterfaces value) const;

   /**
    * This method is used to convert the modem type enum value to trace string
    *
    * @param[in] value - modem type enum value
    * @param[out]
    * @param[in,out]
    *
    * @return ::std::string - modem type string
    */
   const ::std::string& getType2StringTrace(const HfpModemTypeSuppValues value) const;

private:
   const ::std::string _propertyPowered;                      /**< property Powered */
   const ::std::string _propertyName;                         /**< property Name */
   const ::std::string _propertyInterfaces;                   /**< property Interfaces */
   const ::std::string _propertyType;                         /**< property Type */
   const ::std::string _propertyManufacturer;                 /**< property Manufacturer */
   const ::std::string _propertyModel;                        /**< property Model */
   const ::std::string _propertyRevision;                     /**< property Revision */
   const ::std::string _propertySerial;                       /**< property Serial */

   const ::std::string _interfaceOrgOfonoEvoSiri;             /**< interface org.ofono.Evo.Siri */
   const ::std::string _interfaceOrgOfonoVoiceCallManager;    /**< interface org.ofono.VoiceCallManager */
   const ::std::string _interfaceOrgOfonoNetworkRegistration; /**< interface org.ofono.NetworkRegistration */
   const ::std::string _interfaceOrgOfonoHandsFree;           /**< interface org.ofono.Handsfree */
   const ::std::string _interfaceOrgOfonoCallVolume;          /**< interface org.ofono.CallVolume */

   const ::std::string _typeHfp;                              /**< modem type Hfp */
   const ::std::string _typeSap;                              /**< modem type Sap */
   const ::std::string _typeHardware;                         /**< modem type Hardware */

   ::std::map< std::string, int > _interface2EnumList;        /**< map with supported value for Interfaces + enum pairs */
   ::std::map< int, const std::string* > _enum2InterfaceList; /**< map with enum + supported value for Interfaces pairs */

   ::std::map< std::string, int > _type2EnumList;             /**< map with supported value for Type + enum pairs */
   ::std::map< int, const std::string* > _enum2TypeList;      /**< map with enum + supported value for Type pairs */
};

} //evolution
} //ccdbusif

#endif //EvolutionGeniviDbusHfpModemProperties_h
