/**
 * @file EvolutionGeniviDbusHfpModemCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpModem
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpModemCallBackIf_h
#define EvolutionGeniviDbusHfpModemCallBackIf_h

#include "IEvolutionGeniviDbusHfpModemCallBackIf.h"
#include "BtStackWrapperTypesInternal.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

// class forward declarations
class IBtStackWrapper;

/**
 * HfpModem callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpModemCallBackIf : public IEvolutionGeniviDbusHfpModemCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpModemCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpModemCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpModemCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::GetPropertiesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::GetPropertiesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::SetPropertyError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::SetPropertyResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAcceptSCOConnectError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::AcceptSCOConnectError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAcceptSCOConnectResponse(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::AcceptSCOConnectResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::PropertyChangedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::PropertyChangedSignal >& signal) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSCOConnectRequestError(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::SCOConnectRequestError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpModemCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSCOConnectRequestSignal(const ::boost::shared_ptr< ::org::ofono::Modem::ModemProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Modem::SCOConnectRequestSignal >& signal) override;

private:
   /**
    * This method is used to notify the Modem Interfaces changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onModemInterfacesChanged(const ::std::string& modemObjPath, const BTSDbusPropertyList outPropertyList);

   IBtStackWrapper* _btStackWrapper; /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpModemCallBackIf_h
