/**
 * @file EvolutionGeniviDbusHfpHandsfreeCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpHandsfree
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#ifndef EvolutionGeniviDbusHfpHandsfreeCallBackIf_h
#define EvolutionGeniviDbusHfpHandsfreeCallBackIf_h

#include "IEvolutionGeniviDbusHfpHandsfreeCallBackIf.h"
#include "BtStackWrapperTypesInternal.h"

using namespace ::asf::core;

namespace evobtstackwrapper {

//class forward declarations
class IBtStackWrapper;

/**
 * HfpHandsfree callback class for EvolutionGenivi interface.
 */
class EvolutionGeniviDbusHfpHandsfreeCallBackIf : public IEvolutionGeniviDbusHfpHandsfreeCallBackIf
{
public:
   /**
    * Parameterized Constructor of EvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in] btStackWrapper - pointer to EvoBtStackWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpHandsfreeCallBackIf(IBtStackWrapper* btStackWrapper);

   /**
    * Destructor of EvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~EvolutionGeniviDbusHfpHandsfreeCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyAvailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
         const ::std::string& objPath) override;

protected:
   /**
    * Constructor of EvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   EvolutionGeniviDbusHfpHandsfreeCallBackIf();

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::GetPropertiesError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::GetPropertiesResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::SetPropertyError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSetPropertyResponse(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::SetPropertyResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRequestPhoneNumberError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::RequestPhoneNumberError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRequestPhoneNumberResponse(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::RequestPhoneNumberResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetSubscriberError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::GetSubscriberError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onGetSubscriberResponse(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::GetSubscriberResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSendCustomATCommandError(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::SendCustomATCommandError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSendCustomATCommandResponse(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::SendCustomATCommandResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHFUpdateIndicatorsValueError(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HFUpdateIndicatorsValueError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onHFUpdateIndicatorsValueResponse(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HFUpdateIndicatorsValueResponse >& response) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::PropertyChangedError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::PropertyChangedSignal >& signal) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRecvATCommandError(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::RecvATCommandError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onRecvATCommandSignal(const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::RecvATCommandSignal >& signal) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAgHFindicatorsStateIndError(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::AgHFindicatorsStateIndError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAgHFindicatorsStateIndSignal(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::AgHFindicatorsStateIndSignal >& signal) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAgSupportedHFindicatorsIndError(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::AgSupportedHFindicatorsIndError >& error) override;

   /**
    * Member function Overridden from IEvolutionGeniviDbusHfpHandsfreeCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAgSupportedHFindicatorsIndSignal(
         const ::boost::shared_ptr< ::org::ofono::Handsfree::HandsfreeProxy >& proxy,
         const ::boost::shared_ptr< ::org::ofono::Handsfree::AgSupportedHFindicatorsIndSignal >& signal) override;

private:
   /**
    * This method is used to notify the SupportedFeatures changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onSupportedFeaturesChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the InbandRinging changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onInbandRingingChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the VoiceRecognition changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onVoiceRecognitionChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the EchoCancelingNoiseReduction changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onEchoCancelingNoiseReductionChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the BatteryChargeLevel changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onBatteryChargeLevelChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the Audio changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onAudioChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the ScoType changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onSCOTypeChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the AudioPath changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onAudioPathChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the AllCallStatus changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onAllCallStatusChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the ChldFeature changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onChldFeatureChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   /**
    * This method is used to notify the AudioIndicator changes to EvoBtStackWrapper
    *
    * @param[in] objpath - object path
    * @param[in] outPropertyList - list with parsed property
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   void onAudioIndicatorChanged(const std::string& objPath, const BTSDbusPropertyList outPropertyList);

   IBtStackWrapper* _btStackWrapper;  /**< pointer to EvoBtStackWrapper */
};

} //evobtstackwrapper

#endif //EvolutionGeniviDbusHfpHandsfreeCallBackIf
