/**
 * @file ProxyMetaData.h
 *
 * @par SW-Component
 * CcDbusIf
 *
 * @brief DBUS Proxy Meta Data.
 *
 * @copyright (C) 2015-2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Type definition for meta data of a DBUS proxy interface.
 */

#ifndef _PROXY_META_DATA_H_
#define _PROXY_META_DATA_H_

#include "CcDbusIfTypes.h"

namespace ccdbusif {

/**
 * Type definition for meta data of a DBUS proxy interface.
 */
class ProxyMetaData
{
public:
   ProxyMetaData();

   ProxyMetaData(const ::std::string& inputObjPath, const DbusBusName& inputBusName, const DbusBusType inputBusType);

   ProxyMetaData(const ProxyMetaData& ref);

   virtual ~ProxyMetaData();

   ProxyMetaData& operator=(const ProxyMetaData& ref);

   bool operator==(const ProxyMetaData& ref) const;

   bool operator!=(const ProxyMetaData& ref) const;

   bool operator<(const ProxyMetaData& ref) const;

   bool operator>(const ProxyMetaData& ref) const;

   // member with public access
   ::std::string _objPath;
   DbusBusName _busName;
   DbusBusType _busType;

private:
   int compare(const ProxyMetaData& ref) const;
};

} //ccdbusif

#endif //_PROXY_META_DATA_H_
