/**
 * @file IDbusProperty2EnumMapping.h
 * @author CM/ESC3-Tino Lippold
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup CcDbusIf DBUS Property To Enum Mapping
 *
 * @brief DBUS Property To Enum Mapping.
 *
 * @{
 */

#ifndef _I_DBUS_PROPERTY_2_ENUM_MAPPING_H_
#define _I_DBUS_PROPERTY_2_ENUM_MAPPING_H_

#include <vector>
#include <map>
#include <string>

namespace ccdbusif {

/**
 * DBUS property parser class.
 */
class IDbusProperty2EnumMapping
{
public:
   /**
    * Destructor.
    */
   virtual ~IDbusProperty2EnumMapping() {}

   /**
    * Get property to enum mapping list. To be implemented by child class.
    *
    * @param[out] interfaceList: property to enum mapping list matching the given interfaces
    * @param[in] matchingInterfaces: interfaces to be checked
    */
   virtual void getInterfaces(::std::vector<const ::std::map< std::string, int >*>& interfaceList, const ::std::vector< int >& matchingInterfaces) const = 0;
};

} //ccdbusif

#endif //_I_DBUS_PROPERTY_2_ENUM_MAPPING_H_

/** @} */
