/**
 * @file AsfTimerCallbackData.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AsfTimerCallbackData class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PM Application- PM Common
 */

#ifndef AsfTimerCallbackData_h
#define AsfTimerCallbackData_h

#define REPEAT_COUNT_DEFAULT 0x00

typedef unsigned int RepeatCount;
typedef std::string RepeatReason;

namespace com
{
namespace bosch
{
namespace pmcommon
{

class AsfTimerCallbackData
{
public:
   /**
    * Constructor of AsfTimerCallbackData class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   AsfTimerCallbackData() : _repeatCount(REPEAT_COUNT_DEFAULT), _repeatReason("")
   {

   }

   /**
    * Parameterized Constructor of AsfTimerCallbackData class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   AsfTimerCallbackData(const RepeatCount repeatCount, const RepeatReason repeatReason) :
      _repeatCount(repeatCount), _repeatReason(repeatReason)
   {

   }

   /**
    * Copy Constructor of AsfTimerCallbackData class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   AsfTimerCallbackData(const AsfTimerCallbackData& other) :
      _repeatCount(other._repeatCount), _repeatReason(other._repeatReason)
   {

   }

   /**
    * Destructor of AsfTimerCallbackData class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~AsfTimerCallbackData()
   {

   }

   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(AsfTimerCallbackData& first, AsfTimerCallbackData& second)
   {
      using std::swap;

      swap(first._repeatCount, second._repeatCount);
      swap(first._repeatReason, second._repeatReason);
   }

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   AsfTimerCallbackData& operator=(AsfTimerCallbackData other)
   {
      swap(*this, other);

      return *this;
   }

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const AsfTimerCallbackData& rhs) const
   {
      return ((this->_repeatCount == rhs._repeatCount)
            && (this->_repeatReason == rhs._repeatReason));
   }

   /**
    * Overloading '!=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator!=(const AsfTimerCallbackData& rhs) const
   {
      return (!(operator==(rhs)));
   }

   // Number of times the timer have expired
   RepeatCount _repeatCount;

   /* Reason for repeat
    * If Reason is
    * "Completed" -> Repeat is completed
    * "Repeat" -> Repeat is ongoing
    */

   RepeatReason _repeatReason;
};

} // namespace pmcommon
} // namespace bosch
} // namespace com

#endif // AsfTimerCallbackData_h
