/**
 * @file ILoopbackReceiver.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the declaration of the ILoopbackReceiver class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the interfaces for ILoopbackReceiver class.
 *
 * @ingroup PM Application- PM Common
 */

#ifndef ILoopbackReceiver_h
#define ILoopbackReceiver_h

#include "LoopbackData.h"

typedef unsigned long long int ResponseToken;   /**< TODO: check if this typedef could be reused from PmCore */

namespace com
{
namespace bosch
{
namespace pmcommon
{

/**
 * ILoopbackReceiver class definition
 */
class ILoopbackReceiver
{
public:
   /**
    * Destructor of ILoopbackReceiver class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~ILoopbackReceiver(){}

   /**
    * This API is used to post the loopback message to the component
    *
    * @param[in] loopbackData - pointer to the loopback message
    * @param[out]
    * @param[in,out]
    *
    * @return unsigned long long int - Acknowledgment token
    */
    virtual ResponseToken postLoopbackMessage(LoopbackData* loopbackData) = 0;
};

} // namespace pmcommon
} // namespace bosch
} // namespace com

#endif //ILoopbackReceiver_h
