/**
 * @file PmConfiguration.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the PmConfiguration class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCommon
 */

#ifndef PmConfiguration_h
#define PmConfiguration_h

#include "PmSingleton.h"
#include <string>

namespace com
{
namespace bosch
{
namespace pmcommon
{
   class PmConfiguration : public PmSingleton<PmConfiguration>
   {
   public:

      inline void setHoldTimeAfterSCODisconnection(const uint16_t holdTimeAfterSCODisconnection)
      {
         _holdTimeAfterSCODisconnection = holdTimeAfterSCODisconnection;
      }

      inline uint16_t getHoldTimeAfterSCODisconnection(void) const
      {
         return _holdTimeAfterSCODisconnection;
      }

      inline void setHoldTimeAfterEndingVRSession(const uint16_t holdTimeAfterEndingVRSession)
      {
         _holdTimeAfterEndingVRSession = holdTimeAfterEndingVRSession;
      }

      inline uint16_t getHoldTimeAfterEndingVRSession(void) const
      {
         return _holdTimeAfterEndingVRSession;
      }

      inline void setWaitTimeForArlResponse(const uint16_t waitTimeForArlResponse)
      {
         _waitTimeForArlResponse = waitTimeForArlResponse;
      }

      inline uint16_t getWaitTimeForArlResponse(void) const
      {
         return _waitTimeForArlResponse;
      }

      inline void setEcnrDataSetForNBSPhoneCall(const uint16_t ecnrDataSetForNBSPhoneCall)
      {
         _ecnrDataSetForNBSPhoneCall = ecnrDataSetForNBSPhoneCall;
      }

      inline uint16_t getEcnrDataSetForNBSPhoneCall(void) const
      {
         return _ecnrDataSetForNBSPhoneCall;
      }

      inline void setEcnrDataSetForWBSPhoneCall(const uint16_t ecnrDataSetForWBSPhoneCall)
      {
         _ecnrDataSetForWBSPhoneCall = ecnrDataSetForWBSPhoneCall;
      }

      inline uint16_t getEcnrDataSetForWBSPhoneCall(void) const
      {
         return _ecnrDataSetForWBSPhoneCall;
      }

      inline void setEcnrDataSetForNBSVR(const uint16_t ecnrDataSetForNBSVR)
      {
         _ecnrDataSetForNBSVR = ecnrDataSetForNBSVR;
      }

      inline uint16_t getEcnrDataSetForNBSVR(void) const
      {
         return _ecnrDataSetForNBSVR;
      }

      inline void setEcnrDataSetForWBSVR(const uint16_t ecnrDataSetForWBSVR)
      {
         _ecnrDataSetForWBSVR = ecnrDataSetForWBSVR;
      }

      inline uint16_t getEcnrDataSetForWBSVR(void) const
      {
         return _ecnrDataSetForWBSVR;
      }

      inline void setEcnrDataSetForNBSSIRI(const uint16_t ecnrDataSetForNBSSIRI)
      {
         _ecnrDataSetForNBSSIRI = ecnrDataSetForNBSSIRI;
      }

      inline uint16_t getEcnrDataSetForNBSSIRI(void) const
      {
         return _ecnrDataSetForNBSSIRI;
      }

      inline void setEcnrDataSetForWBSSIRI(const uint16_t ecnrDataSetForWBSSIRI)
      {
         _ecnrDataSetForWBSSIRI = ecnrDataSetForWBSSIRI;
      }

      inline uint16_t getEcnrDataSetForWBSSIRI(void) const
      {
         return _ecnrDataSetForWBSSIRI;
      }

      inline void setAutoRejectThirdIncomingCall(const bool autoRejectThirdIncomingCall)
      {
         _autoRejectThirdIncomingCall = autoRejectThirdIncomingCall;
      }

      inline bool getAutoRejectThirdIncomingCall(void) const
      {
         return _autoRejectThirdIncomingCall;
      }

      inline void setPhoneSubstateSetForHandsetMode(const uint8_t phoneSubstateSetForHandsetMode)
      {
         _phoneSubstateSetForHandsetMode = phoneSubstateSetForHandsetMode;
      }

      inline uint8_t getPhoneSubstateSetForHandsetMode(void) const
      {
         return _phoneSubstateSetForHandsetMode;
      }

      inline void setMaxNumActiveDevices(const uint8_t maxNumActiveDevices)
      {
         _maxNumActiveDevices = maxNumActiveDevices;
      }

      inline uint8_t getMaxNumActiveDevices(void) const
      {
         return _maxNumActiveDevices;
      }

      inline void setSupportedTypeForSIRI(const uint16_t supportedTypeForSIRI)
      {
         _supportedTypeForSIRI = supportedTypeForSIRI;
      }

      inline uint16_t getSupportedTypeForSIRI(void) const
      {
         return _supportedTypeForSIRI;
      }

      inline void setWaitTimeForAudioPlayerResponse(const int waitTimeForAudioPlayerResponse)
      {
         _waitTimeForAudioPlayerResponse = waitTimeForAudioPlayerResponse;
      }

      inline int getWaitTimeForAudioPlayerResponse(void) const
      {
         return _waitTimeForAudioPlayerResponse;
      }

      inline void setRemoteVolumeControl(const bool remoteVolumeControl)
      {
         _remoteVolumeControl = remoteVolumeControl;
      }

      inline bool getRemoteVolumeControl(void) const
      {
         return _remoteVolumeControl;
      }

      inline void setRvcResponseTimeout(const int rvcResponseTimeout)
      {
         _rvcResponseTimeout = rvcResponseTimeout;
      }

      inline int getRvcResponseTimeout(void) const
      {
         return _rvcResponseTimeout;
      }

      inline void setMinAMVolumeLevel(const uint16_t minAMVolumeLevel)
      {
         _minAMVolumeLevel = minAMVolumeLevel;
      }

      inline uint16_t getMinAMVolumeLevel(void) const
      {
         return _minAMVolumeLevel;
      }

      inline void setMaxAMVolumeLevel(const uint16_t maxAMVolumeLevel)
      {
         _maxAMVolumeLevel = maxAMVolumeLevel;
      }

      inline uint16_t getMaxAMVolumeLevel(void) const
      {
         return _maxAMVolumeLevel;
      }

      inline void setGAMVoiceRecSourceID(const uint16_t gamVoiceRecSourceID)
      {
         _gamVoiceRecSourceID = gamVoiceRecSourceID;
      }

      inline uint16_t getGAMVoiceRecSourceID(void) const
      {
         return _gamVoiceRecSourceID;
      }

      inline void setGAMDefaultPhoneSourceXID(const uint16_t gamDefaultPhoneSourceXID)
      {
         _gamDefaultPhoneSourceXID = gamDefaultPhoneSourceXID;
      }

      inline uint16_t getGAMDefaultPhoneSourceXID(void) const
      {
         return _gamDefaultPhoneSourceXID;
      }

      inline void setGAMDefaultPhoneSourceOffsetID(const uint16_t gamDefaultPhoneSourceOffsetID)
      {
         _gamDefaultPhoneSourceOffsetID = gamDefaultPhoneSourceOffsetID;
      }

      inline uint16_t getGAMDefaultPhoneSourceOffsetID(void) const
      {
         return _gamDefaultPhoneSourceOffsetID;
      }

      inline void setGAMDefaultPhoneSourceID(const uint16_t gamDefaultPhoneSourceID)
      {
         _gamDefaultPhoneSourceID = gamDefaultPhoneSourceID;
      }

      inline uint16_t getGAMDefaultPhoneSourceID(void) const
      {
         return _gamDefaultPhoneSourceID;
      }

   private:
      friend class PmSingleton<PmConfiguration>;

      /**
       * Constructor of PmConfiguration class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      PmConfiguration();

      /**
       * Copy Constructor of PmConfiguration class => must not be used.
       *
       * @param[in] other: reference to copy
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      PmConfiguration(const PmConfiguration& other);

      /**
       * Destructor of PmConfiguration class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      ~PmConfiguration();

      /**
       * Overloading '=' operator => must not be used.
       *
       * @param[in] other: reference to copy
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      PmConfiguration& operator=(PmConfiguration other);

      uint16_t    _holdTimeAfterSCODisconnection;  /**< Hold time after SCO disconnection */
      uint16_t    _holdTimeAfterEndingVRSession;   /**< Hold time after Ending VR session */
      uint16_t    _waitTimeForArlResponse;         /**< Wait time for Arl Response */
      uint16_t    _ecnrDataSetForNBSPhoneCall;     /**< Ecnr data set for NB Phone Call */
      uint16_t    _ecnrDataSetForWBSPhoneCall;     /**< Ecnr data set for WB Phone Call */
      uint16_t    _ecnrDataSetForNBSVR;            /**< Ecnr data set for NB VR */
      uint16_t    _ecnrDataSetForWBSVR;            /**< Ecnr data set for WB VR */
      uint16_t    _ecnrDataSetForNBSSIRI;          /**< Ecnr data set for NB Siri */
      uint16_t    _ecnrDataSetForWBSSIRI;          /**< Ecnr data set for WB Siri */
      uint16_t    _supportedTypeForSIRI;           /**< Support type for Siri */
      bool        _autoRejectThirdIncomingCall;    /**< Auto reject third incoming call */
      int         _waitTimeForAudioPlayerResponse; /**< Wait timer for GStreamer thread to respond */
      uint8_t     _phoneSubstateSetForHandsetMode; /**< Phone substate for HandsetMode */
      uint8_t     _maxNumActiveDevices;            /**< Maximum no. of active devices */
      bool        _remoteVolumeControl;            /**< Enable Remote Volume Feature */
      int         _rvcResponseTimeout;             /**< Timeout for RVC Response */
      uint16_t    _minAMVolumeLevel;               /**< Minimum Audio Manager Volume */
      uint16_t    _maxAMVolumeLevel;               /**< Maximum AudioManager Volume */
      uint16_t    _gamVoiceRecSourceID;            /**< GAM Property Type */
      uint16_t    _gamDefaultPhoneSourceXID;       /**< GAM Default Phone Source X*/
      uint16_t    _gamDefaultPhoneSourceOffsetID;  /**< GAM Default Phone Source Offset */
      uint16_t    _gamDefaultPhoneSourceID;        /**< GAM Default Phone Source ID */
   };

} // namespace pmcommon
} // namespace bosch
} // namespace com

#endif // PmConfiguration_h
