/**
 * @file PmUtils.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the declaration of utility functions used by PhoneCallManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef PmUtils_h
#define PmUtils_h

#include <string>

namespace com
{
namespace bosch
{
namespace pmcommon
{

/**
 * This method is used to validate the telephoneNumber
 *
 * @param[in] telephoneNumber - Telephone to validate
 * @param[out] TelephoneNumber &validTelephoneNumber - Gives the valid telephone number.
 * @param[in,out]
 *
 * @return
 */
void validateDialNumber(const std::string& telephoneNumber, std::string &validTelephoneNumber);

/**
 * This method is used to validate the waiting mode file path.
 *
 * If it is valid and not complete,
 * then it sets the complete waiting mode file path and returns it.
 * If it is valid complete,
 * then it simply returns it.
 * If it is invalid, then returns false.
 *
 * @param[in] FilePath filePath - Waiting mode file path to validate
 * @param[out] FilePath& completeFilePath - Gives the complete waiting mode file path.
 * @param[in,out]
 *
 * @return
 */
void validateWaitingModeFilePath(const std::string& filePath, std::string& completeFilePath);

} // namespace pmcommon
} // namespace bosch
} // namespace com

#endif // PmUtils_h
