/**
 * @file PmComponent.h
 *
 * @swcomponent PhoneCallManager 
 *
 * @brief This file contains the definition of the PmComponent class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This is the main file of phone call manager.
 *          It makes the component as an ASF based component.
 *
 * @ingroup PhoneCallManager
 */

#ifndef PmComponent_h
#define PmComponent_h

#include "asf/core/BaseComponent.h"
#include "org/bosch/cm/lcm/lcmbaseappcomponent/LcmBaseAppComponent.h"
#include "LoopbackData.h"

namespace com
{
namespace bosch
{
using namespace ::org::bosch::cm::lcm::lcmbaseappcomponent;
using namespace ::org::genivi::NodeStateManager::LcmErrorTypes;
using namespace org::genivi::NodeStateManager::LcmBasicTypes;

/**
 * PmComponent class definition
 */
class PmComponent: public asf::core::BaseComponent, public LocalMessageCallbackIF1 <pmcommon::LoopbackData*>,
                   public LcmApplicationControlIF
{
public:
   /**
    * Constructor of PmComponent class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   PmComponent();

   /**
    * Destructor of PmComponent class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~PmComponent();

   /**
    * Called when a local message, sent by BaseComponent::sendLocalMessage(), is processed.
    *
    * @param[in] LoopbackData* - payload of the message sent by the posting thread.
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onLocalMessage(::boost::shared_ptr< PayloadTuple1 < pmcommon::LoopbackData*> >& payload) override;
   
   // handling persistency

   /**
    * Function overridden from LcmApplicationControlIF
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onLoadPersistency() override;

   /**
    * Function overridden from LcmApplicationControlIF
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onSavePersistency() override;

   /**
    * Call back function from LCM for Application mode changes.
    */
   virtual _NsmErrorStatus_e OnAppModeChange(_Nsm_Shutdown_Type_e newAppMode, _Nsm_Shutdown_Type_e oldAppMode) override;
   /**
    * Call back function from LCM for Watchdog Handling.
    */
   virtual bool OnAppWatchdog() override;
   /**
    * Call back function from LCM for LcmServiceRegistration.
    */
   virtual void OnLcmRegistered() override;

private:
   LcmBaseAppComponent _lcmAppComponent;
};

} // namespace bosch
} // namespace com

#endif // PmComponent_h
