/**
 * @file PhoneCallManager.h
 *
 * @swcomponent PhoneCallManager 
 *
 * @brief This file contains the definition of the PhoneCallManager class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup Phone Call Manager
 */

#ifndef PhoneCallManager_h
#define PhoneCallManager_h

#include "PmSingleton.h"
#include "PmAppCcaServer.h"
#include "IpcMessageDispatcher.h"
#include "PmAppClientHandler.h"
#include "PmAppAsfDbusServer.h"
#include "scd_fw.h"

using namespace asf::core;
using namespace ::com::bosch::pmapp;

/**
 * The interface layer related classes for PM Application are instantiated here
 *
 */
class PhoneCallManager : public PmSingleton <PhoneCallManager>
{

public:

    /**
    * Copy constructor
    *
    * @param[in] PhoneCallManager& ref - Reference to PhoneCallManager
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   PhoneCallManager(const PhoneCallManager& ref);

   /**
    * operator= overloaded function
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return Returns the object of the PhoneCallManager
    *
    */
   PhoneCallManager& operator=(const PhoneCallManager& ref);

   /**
    * Method to return the instance of PM APP CCA server class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return Returns the instance of the PmCcaServer class
    *
    */
   PmAppCcaServer* getPmAppCcaServer()
   {
      return _pPmAppCcaServer;
   }

   /**
    * Method to return the instance of IPC message dispatcher class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return Returns the instance of the IpcMessageDispatcher class
    *
    */
   IpcMessageDispatcher* getIpcMessageDispatcher();

   /**
    * Method to return the instance of PM App Client handler
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return Returns the instance of the PmAppClientHandler class
    *
    */
   PmAppClientHandler* getPmAppClientHandler()
   {
      return _pPmAppClientHandler;
   }

   /**
    * Method to return the instance of PM App DBus Server
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return Returns the instance of the PmAppAsfDbusServer class
    *
    */
   inline PmAppAsfDbusServer* getPmAppAsfDbusServer()
   {
      return _pPmAppAsfDbusServer;
   }

   /**
    * Constructor of Phone call manager class, made in private scope since its a singleton instance
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   PhoneCallManager();

   /**
    * Destructor of Phone call manager class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~PhoneCallManager();

private:

   friend class PmSingleton<PhoneCallManager>;

   /**
    * Load the phone application registry file after started as an ASF based application
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   void buildRegistry() const;

   PmAppCcaServer* _pPmAppCcaServer; /**< Pointer to the PmAppCcaServer class */

   IpcMessageDispatcher* _pIpcMessageDispatcher; /**< Pointer to the IpcMessageDispatcher class */

   PmAppClientHandler* _pPmAppClientHandler; /**< Pointer to the PmAppClientHandler class */

   PmAppAsfDbusServer* _pPmAppAsfDbusServer; /**< Pointer to the PmAppAsfDbusServer class */
};

#endif // PhoneCallManager_h
