/* *
 * @file WaitingModeToneAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from WaitingModeToneAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#include "WaitingModeToneAudioSm.h"

/*! \file Implementation of the state machine 'WaitingModeToneAudioSm'
*/




WaitingModeToneAudioSm::WaitingModeToneAudioSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceAmClientRequest(this),
ifaceAudioWrapperReqIf(this),
ifaceAudioWrapperReqIf_OCB(sc_null),
ifaceAudioWrapperResponse(this),
ifaceAudioPlayerReqIf(this),
ifaceAudioPlayerReqIf_OCB(sc_null),
ifaceAudioPlayerResponse(this),
ifaceWaitingModeToneSmHandler(this),
ifaceWaitingModeToneSmHandler_OCB(sc_null),
ifaceInternalSCI(this),
isRunningCycle(false)
{
}

WaitingModeToneAudioSm::~WaitingModeToneAudioSm()
{
}


using namespace waitingmodetoneaudiosm_events;

SctEvent* WaitingModeToneAudioSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!internalEventQueue.empty()) {
		nextEvent = internalEventQueue.front();
		internalEventQueue.pop_front();
	}
	else if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void WaitingModeToneAudioSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_AmClientRequest_PREPARE_WAITING_MODE_TONE_CHANNEL:
		case SCI_AmClientRequest_PLAY_WAITING_MODE_TONE:
		case SCI_AmClientRequest_PAUSE_WAITING_MODE_TONE:
		case SCI_AmClientRequest_STOP_WAITING_MODE_TONE:
		{
			ifaceAmClientRequest.dispatch_event(event);
			break;
		}
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED:
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DENIED:
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DEALLOCATED:
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_ON:
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_OFF:
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_PAUSE:
		{
			ifaceAudioWrapperResponse.dispatch_event(event);
			break;
		}
		case SCI_AudioPlayerResponse_PLAYING_SUCCESS:
		case SCI_AudioPlayerResponse_PLAYING_ERROR:
		case SCI_AudioPlayerResponse_STOP_SUCCESS:
		case SCI_AudioPlayerResponse_STOP_FAILURE:
		{
			ifaceAudioPlayerResponse.dispatch_event(event);
			break;
		}
		case InternalSCI_READY_TO_PLAY:
		case InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT:
		{
			ifaceInternalSCI.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void WaitingModeToneAudioSm::SCI_AmClientRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AmClientRequest_PREPARE_WAITING_MODE_TONE_CHANNEL:
		{
			internal_raise_pREPARE_WAITING_MODE_TONE_CHANNEL();
			break;
		}
		case SCI_AmClientRequest_PLAY_WAITING_MODE_TONE:
		{
			SctEvent_SCI_AmClientRequest_PLAY_WAITING_MODE_TONE * e = static_cast<SctEvent_SCI_AmClientRequest_PLAY_WAITING_MODE_TONE*>(event);
			if(e != 0) {
				internal_raise_pLAY_WAITING_MODE_TONE(e->value);
			}
			break;
		}
		case SCI_AmClientRequest_PAUSE_WAITING_MODE_TONE:
		{
			internal_raise_pAUSE_WAITING_MODE_TONE();
			break;
		}
		case SCI_AmClientRequest_STOP_WAITING_MODE_TONE:
		{
			internal_raise_sTOP_WAITING_MODE_TONE();
			break;
		}
		default:
			break;
	}
}
void WaitingModeToneAudioSm::SCI_AudioWrapperReqIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED:
		{
			SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED * e = static_cast<SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED*>(event);
			if(e != 0) {
				internal_raise_wAITING_MODE_TONE_CHANNEL_GRANTED(e->value);
			}
			break;
		}
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DENIED:
		{
			internal_raise_wAITING_MODE_TONE_CHANNEL_DENIED();
			break;
		}
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DEALLOCATED:
		{
			internal_raise_wAITING_MODE_TONE_CHANNEL_DEALLOCATED();
			break;
		}
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_ON:
		{
			internal_raise_wAITING_MODE_TONE_SA_ON();
			break;
		}
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_OFF:
		{
			internal_raise_wAITING_MODE_TONE_SA_OFF();
			break;
		}
		case SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_PAUSE:
		{
			internal_raise_wAITING_MODE_TONE_SA_PAUSE();
			break;
		}
		default:
			break;
	}
}
void WaitingModeToneAudioSm::SCI_AudioPlayerReqIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioPlayerResponse_PLAYING_SUCCESS:
		{
			internal_raise_pLAYING_SUCCESS();
			break;
		}
		case SCI_AudioPlayerResponse_PLAYING_ERROR:
		{
			SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR * e = static_cast<SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR*>(event);
			if(e != 0) {
				internal_raise_pLAYING_ERROR(e->value);
			}
			break;
		}
		case SCI_AudioPlayerResponse_STOP_SUCCESS:
		{
			internal_raise_sTOP_SUCCESS();
			break;
		}
		case SCI_AudioPlayerResponse_STOP_FAILURE:
		{
			SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE * e = static_cast<SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE*>(event);
			if(e != 0) {
				internal_raise_sTOP_FAILURE(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void WaitingModeToneAudioSm::SCI_WaitingModeToneSmHandler::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void WaitingModeToneAudioSm::InternalSCI::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case InternalSCI_READY_TO_PLAY:
		{
			internal_raise_rEADY_TO_PLAY();
			break;
		}
		case InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT:
		{
			internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT();
			break;
		}
		default:
			break;
	}
}


void WaitingModeToneAudioSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = WaitingModeToneAudioSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
	/* Default init sequence for statechart WaitingModeToneAudioSm */
	ifaceWaitingModeToneSmHandler.waitingModeToneFilePath = (sc_string) "";
	ifaceWaitingModeToneSmHandler.sinkName = (sc_string) "";
}

void WaitingModeToneAudioSm::enter()
{
	/* Default enter sequence for statechart WaitingModeToneAudioSm */
	enseq_WaitingModeToneAudioRegion_default();
}

void WaitingModeToneAudioSm::exit()
{
	/* Default exit sequence for statechart WaitingModeToneAudioSm */
	exseq_WaitingModeToneAudioRegion();
}

sc_boolean WaitingModeToneAudioSm::isActive() const
{
	return stateConfVector[0] != WaitingModeToneAudioSm_last_state||stateConfVector[1] != WaitingModeToneAudioSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean WaitingModeToneAudioSm::isFinal() const
{
   return false;}

void WaitingModeToneAudioSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case WaitingModeToneAudioRegion_Idle :
				{
					WaitingModeToneAudioRegion_Idle_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_react(true);
					break;
				}
				case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse :
				{
					WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void WaitingModeToneAudioSm::clearInEvents()
{
	ifaceAmClientRequest.PREPARE_WAITING_MODE_TONE_CHANNEL_raised = false;
	ifaceAmClientRequest.PLAY_WAITING_MODE_TONE_raised = false;
	ifaceAmClientRequest.PAUSE_WAITING_MODE_TONE_raised = false;
	ifaceAmClientRequest.STOP_WAITING_MODE_TONE_raised = false;
	ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_GRANTED_raised = false;
	ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_DENIED_raised = false;
	ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_DEALLOCATED_raised = false;
	ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_ON_raised = false;
	ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised = false;
	ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_PAUSE_raised = false;
	ifaceAudioPlayerResponse.PLAYING_SUCCESS_raised = false;
	ifaceAudioPlayerResponse.PLAYING_ERROR_raised = false;
	ifaceAudioPlayerResponse.STOP_SUCCESS_raised = false;
	ifaceAudioPlayerResponse.STOP_FAILURE_raised = false;
	ifaceInternalSCI.READY_TO_PLAY_raised = false; 
	ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised = false; 
}

void WaitingModeToneAudioSm::clearOutEvents()
{
}


sc_boolean WaitingModeToneAudioSm::isStateActive(WaitingModeToneAudioSmStates state) const
{
	switch (state)
	{
		case WaitingModeToneAudioRegion_Idle : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_IDLE] == WaitingModeToneAudioRegion_Idle
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY] >= WaitingModeToneAudioRegion_WaitingModeTonePlay
				&& stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY] <= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE] >= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone
				&& stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE] <= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_AMCLIENTREQUESTWAITREGION_WAITFORAMCLIENTREQUEST] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_AMCLIENTREQUESTWAITREGION_PLAYWAITINGMODETONEREQUEST] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_ARLRESPONSEWAITREGION_WAITFORWAITINGMODETONEROUTEALLOCATION] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_ARLRESPONSEWAITREGION_WAITINGMODETONESAONRECEIVED] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITTOPLAYWAITINGMODETONE_ARLRESPONSEWAITREGION_WAITFORSAON] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_WAITINGMODETONEPLAYING] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY] >= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay
				&& stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY] <= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY] >= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay
				&& stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY] <= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY_AUDIOPLAYEROPERATIONREGION_WAITFORPLAYERTOSTOP] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY_AUDIOPLAYEROPERATIONREGION_PLAYBACKSTOPPED] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY_AUDIOWRAPPEROPERATIONREGION_WAITFORROUTEDEALLOCATION] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STOPPLAY_AUDIOWRAPPEROPERATIONREGION_WAITINGMODETONECHANNELDEALLOCATED] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_WAITFORROUTEDEALLOCATION] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_STREAMINGSTOPPED] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_WAITFORPLAYERSTOP] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_STOPWAITINGMODETONEPLAY_STOPWAITINGMODETONEPLAY_REGION_AUTOSAOFF] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE] >= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone
				&& stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE] <= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_WAITPLAYERTOSTOP] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_PLAYBACKPAUSED] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_PLAYAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_PAUSEAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_STOPAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_AUTOSAPAUSEAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_AUTOSAOFFAFTERECNRRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_PAUSEWAITINGMODETONE_PAUSEWAITINGMODETONEREGION_AUTOSAONAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE] >= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause
				&& stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE] <= WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_WAITFORPLAYERTOSTOP] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_CHANNELPAUSED] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_AUTOSAOFFAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_STOPAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_SAONAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse
			);
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse : 
			return (sc_boolean) (stateConfVector[SCVI_WAITINGMODETONEAUDIOREGION_WAITINGMODETONEPLAY_WAITINGMODETONEPLAYREGION_AUTOSAPAUSE_AUTOSAPAUSEREGION_PAUSEAFTERPLAYERRESPONSE] == WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse
			);
		default: return false;
	}
}

WaitingModeToneAudioSm::SCI_AmClientRequest* WaitingModeToneAudioSm::getSCI_AmClientRequest()
{
	return &ifaceAmClientRequest;
}
/* Functions for event PREPARE_WAITING_MODE_TONE_CHANNEL in interface SCI_AmClientRequest */
void WaitingModeToneAudioSm::SCI_AmClientRequest::raise_pREPARE_WAITING_MODE_TONE_CHANNEL()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PREPARE_WAITING_MODE_TONE_CHANNEL(SCI_AmClientRequest_PREPARE_WAITING_MODE_TONE_CHANNEL));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AmClientRequest::internal_raise_pREPARE_WAITING_MODE_TONE_CHANNEL()
{
	PREPARE_WAITING_MODE_TONE_CHANNEL_raised = true;
}
/* Functions for event PLAY_WAITING_MODE_TONE in interface SCI_AmClientRequest */
void WaitingModeToneAudioSm::SCI_AmClientRequest::raise_pLAY_WAITING_MODE_TONE(FilePath value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PLAY_WAITING_MODE_TONE(SCI_AmClientRequest_PLAY_WAITING_MODE_TONE, value));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AmClientRequest::internal_raise_pLAY_WAITING_MODE_TONE(FilePath value)
{
	PLAY_WAITING_MODE_TONE_value = value;
	PLAY_WAITING_MODE_TONE_raised = true;
}
/* Functions for event PAUSE_WAITING_MODE_TONE in interface SCI_AmClientRequest */
void WaitingModeToneAudioSm::SCI_AmClientRequest::raise_pAUSE_WAITING_MODE_TONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PAUSE_WAITING_MODE_TONE(SCI_AmClientRequest_PAUSE_WAITING_MODE_TONE));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AmClientRequest::internal_raise_pAUSE_WAITING_MODE_TONE()
{
	PAUSE_WAITING_MODE_TONE_raised = true;
}
/* Functions for event STOP_WAITING_MODE_TONE in interface SCI_AmClientRequest */
void WaitingModeToneAudioSm::SCI_AmClientRequest::raise_sTOP_WAITING_MODE_TONE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_STOP_WAITING_MODE_TONE(SCI_AmClientRequest_STOP_WAITING_MODE_TONE));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AmClientRequest::internal_raise_sTOP_WAITING_MODE_TONE()
{
	STOP_WAITING_MODE_TONE_raised = true;
}
WaitingModeToneAudioSm::SCI_AudioWrapperReqIf* WaitingModeToneAudioSm::getSCI_AudioWrapperReqIf()
{
	return &ifaceAudioWrapperReqIf;
}
void WaitingModeToneAudioSm::setSCI_AudioWrapperReqIf_OCB(SCI_AudioWrapperReqIf_OCB* operationCallback)
{
	ifaceAudioWrapperReqIf_OCB = operationCallback;
}
WaitingModeToneAudioSm::SCI_AudioWrapperResponse* WaitingModeToneAudioSm::getSCI_AudioWrapperResponse()
{
	return &ifaceAudioWrapperResponse;
}
/* Functions for event WAITING_MODE_TONE_CHANNEL_GRANTED in interface SCI_AudioWrapperResponse */
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::raise_wAITING_MODE_TONE_CHANNEL_GRANTED(AudioSink value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED(SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_GRANTED, value));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::internal_raise_wAITING_MODE_TONE_CHANNEL_GRANTED(AudioSink value)
{
	WAITING_MODE_TONE_CHANNEL_GRANTED_value = value;
	WAITING_MODE_TONE_CHANNEL_GRANTED_raised = true;
}
/* Functions for event WAITING_MODE_TONE_CHANNEL_DENIED in interface SCI_AudioWrapperResponse */
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::raise_wAITING_MODE_TONE_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DENIED(SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DENIED));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::internal_raise_wAITING_MODE_TONE_CHANNEL_DENIED()
{
	WAITING_MODE_TONE_CHANNEL_DENIED_raised = true;
}
/* Functions for event WAITING_MODE_TONE_CHANNEL_DEALLOCATED in interface SCI_AudioWrapperResponse */
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::raise_wAITING_MODE_TONE_CHANNEL_DEALLOCATED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DEALLOCATED(SCI_AudioWrapperResponse_WAITING_MODE_TONE_CHANNEL_DEALLOCATED));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::internal_raise_wAITING_MODE_TONE_CHANNEL_DEALLOCATED()
{
	WAITING_MODE_TONE_CHANNEL_DEALLOCATED_raised = true;
}
/* Functions for event WAITING_MODE_TONE_SA_ON in interface SCI_AudioWrapperResponse */
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::raise_wAITING_MODE_TONE_SA_ON()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_ON(SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_ON));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::internal_raise_wAITING_MODE_TONE_SA_ON()
{
	WAITING_MODE_TONE_SA_ON_raised = true;
}
/* Functions for event WAITING_MODE_TONE_SA_OFF in interface SCI_AudioWrapperResponse */
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::raise_wAITING_MODE_TONE_SA_OFF()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_OFF(SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_OFF));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::internal_raise_wAITING_MODE_TONE_SA_OFF()
{
	WAITING_MODE_TONE_SA_OFF_raised = true;
}
/* Functions for event WAITING_MODE_TONE_SA_PAUSE in interface SCI_AudioWrapperResponse */
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::raise_wAITING_MODE_TONE_SA_PAUSE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_PAUSE(SCI_AudioWrapperResponse_WAITING_MODE_TONE_SA_PAUSE));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioWrapperResponse::internal_raise_wAITING_MODE_TONE_SA_PAUSE()
{
	WAITING_MODE_TONE_SA_PAUSE_raised = true;
}
WaitingModeToneAudioSm::SCI_AudioPlayerReqIf* WaitingModeToneAudioSm::getSCI_AudioPlayerReqIf()
{
	return &ifaceAudioPlayerReqIf;
}
void WaitingModeToneAudioSm::setSCI_AudioPlayerReqIf_OCB(SCI_AudioPlayerReqIf_OCB* operationCallback)
{
	ifaceAudioPlayerReqIf_OCB = operationCallback;
}
WaitingModeToneAudioSm::SCI_AudioPlayerResponse* WaitingModeToneAudioSm::getSCI_AudioPlayerResponse()
{
	return &ifaceAudioPlayerResponse;
}
/* Functions for event PLAYING_SUCCESS in interface SCI_AudioPlayerResponse */
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::raise_pLAYING_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioPlayerResponse_PLAYING_SUCCESS(SCI_AudioPlayerResponse_PLAYING_SUCCESS));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::internal_raise_pLAYING_SUCCESS()
{
	PLAYING_SUCCESS_raised = true;
}
/* Functions for event PLAYING_ERROR in interface SCI_AudioPlayerResponse */
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::raise_pLAYING_ERROR(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioPlayerResponse_PLAYING_ERROR(SCI_AudioPlayerResponse_PLAYING_ERROR, value));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::internal_raise_pLAYING_ERROR(AmResultMessage value)
{
	PLAYING_ERROR_value = value;
	PLAYING_ERROR_raised = true;
}
/* Functions for event STOP_SUCCESS in interface SCI_AudioPlayerResponse */
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::raise_sTOP_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioPlayerResponse_STOP_SUCCESS(SCI_AudioPlayerResponse_STOP_SUCCESS));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::internal_raise_sTOP_SUCCESS()
{
	STOP_SUCCESS_raised = true;
}
/* Functions for event STOP_FAILURE in interface SCI_AudioPlayerResponse */
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::raise_sTOP_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioPlayerResponse_STOP_FAILURE(SCI_AudioPlayerResponse_STOP_FAILURE, value));
	parent->runCycle();
}
void WaitingModeToneAudioSm::SCI_AudioPlayerResponse::internal_raise_sTOP_FAILURE(AmResultMessage value)
{
	STOP_FAILURE_value = value;
	STOP_FAILURE_raised = true;
}
WaitingModeToneAudioSm::SCI_WaitingModeToneSmHandler* WaitingModeToneAudioSm::getSCI_WaitingModeToneSmHandler()
{
	return &ifaceWaitingModeToneSmHandler;
}
FilePath WaitingModeToneAudioSm::SCI_WaitingModeToneSmHandler::get_waitingModeToneFilePath() const
{
	return waitingModeToneFilePath;
}

void WaitingModeToneAudioSm::SCI_WaitingModeToneSmHandler::set_waitingModeToneFilePath(FilePath value)
{
	waitingModeToneFilePath = value;
}

AudioSink WaitingModeToneAudioSm::SCI_WaitingModeToneSmHandler::get_sinkName() const
{
	return sinkName;
}

void WaitingModeToneAudioSm::SCI_WaitingModeToneSmHandler::set_sinkName(AudioSink value)
{
	sinkName = value;
}

void WaitingModeToneAudioSm::setSCI_WaitingModeToneSmHandler_OCB(SCI_WaitingModeToneSmHandler_OCB* operationCallback)
{
	ifaceWaitingModeToneSmHandler_OCB = operationCallback;
}
/* Functions for event READY_TO_PLAY in interface InternalSCI */
void WaitingModeToneAudioSm::InternalSCI::raise_rEADY_TO_PLAY()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
	parent->runCycle();
}
void WaitingModeToneAudioSm::InternalSCI::internal_raise_rEADY_TO_PLAY()
{
	READY_TO_PLAY_raised = true;
}
sc_boolean WaitingModeToneAudioSm::InternalSCI::isRaised_rEADY_TO_PLAY() const
{
	return READY_TO_PLAY_raised;
}
/* Functions for event SEND_SRC_ACTIVITY_OFF_RESULT in interface InternalSCI */
void WaitingModeToneAudioSm::InternalSCI::raise_sEND_SRC_ACTIVITY_OFF_RESULT()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
	parent->runCycle();
}
void WaitingModeToneAudioSm::InternalSCI::internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT()
{
	SEND_SRC_ACTIVITY_OFF_RESULT_raised = true;
}
sc_boolean WaitingModeToneAudioSm::InternalSCI::isRaised_sEND_SRC_ACTIVITY_OFF_RESULT() const
{
	return SEND_SRC_ACTIVITY_OFF_RESULT_raised;
}

void WaitingModeToneAudioSm::setTraceObserver(ysc::TraceObserver<WaitingModeToneAudioSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<WaitingModeToneAudioSm::WaitingModeToneAudioSmStates>* WaitingModeToneAudioSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_tr0()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay();
	enseq_WaitingModeToneAudioRegion_Idle_default();
	react();
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_tr1()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay();
	enseq_WaitingModeToneAudioRegion_Idle_default();
	react();
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_tr1()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay();
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDeallocated();
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr2()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
	ifaceAudioPlayerReqIf_OCB->setAlsaDeviceName(ifaceWaitingModeToneSmHandler.sinkName, (sc_string) "");
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying_default();
	WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr3()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_DeallocateRoute();
	WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr5()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPaused();
	WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr7()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_AutoSAOff();
	WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr0()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause();
	ifaceAudioPlayerReqIf_OCB->setAlsaDeviceName(ifaceWaitingModeToneSmHandler.sinkName, (sc_string) "");
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying_default();
	WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr1()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause();
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_AutoSAOff();
	WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
}

void WaitingModeToneAudioSm::effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr2()
{
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause();
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_DeallocateRoute();
	WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
}

/* Entry action for state 'WaitToPlayWaitingModeTone'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone()
{
	/* Entry action for state 'WaitToPlayWaitingModeTone'. */
	ifaceWaitingModeToneSmHandler_OCB->updateStatus(PREPARING, (sc_string) "Preapring WaitingModeTone channel");
}

/* Entry action for state 'PlayWaitingModeToneRequest'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest()
{
	/* Entry action for state 'PlayWaitingModeToneRequest'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
}

/* Entry action for state 'WaitForWaitingModeToneRouteAllocation'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation()
{
	/* Entry action for state 'WaitForWaitingModeToneRouteAllocation'. */
	ifaceAudioWrapperReqIf_OCB->sendAllocateRequest();
}

/* Entry action for state 'WaitingModeToneSAOnReceived'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived()
{
	/* Entry action for state 'WaitingModeToneSAOnReceived'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
}

/* Entry action for state 'WaitForSAOn'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn()
{
	/* Entry action for state 'WaitForSAOn'. */
	ifaceAudioPlayerReqIf_OCB->setAlsaDeviceName(ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_GRANTED_value, (sc_string) "");
	ifaceWaitingModeToneSmHandler_OCB->updateSinkName(ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_GRANTED_value);
	ifaceWaitingModeToneSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "WaitingModeTone channel granted");
}

/* Entry action for state 'WaitingModeTonePlaying'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying()
{
	/* Entry action for state 'WaitingModeTonePlaying'. */
	ifaceAudioPlayerReqIf_OCB->sendPlayFileRequest(ifaceWaitingModeToneSmHandler.waitingModeToneFilePath);
}

/* Entry action for state 'WaitForPlayerToStop'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop()
{
	/* Entry action for state 'WaitForPlayerToStop'. */
	ifaceAudioPlayerReqIf_OCB->stopPlayback();
}

/* Entry action for state 'PlaybackStopped'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped()
{
	/* Entry action for state 'PlaybackStopped'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForRouteDeallocation'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation()
{
	/* Entry action for state 'WaitForRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'WaitingModeToneChannelDeallocated'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated()
{
	/* Entry action for state 'WaitingModeToneChannelDeallocated'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForRouteDeallocation'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation()
{
	/* Entry action for state 'WaitForRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'StreamingStopped'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped()
{
	/* Entry action for state 'StreamingStopped'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
}

/* Entry action for state 'WaitForPlayerStop'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop()
{
	/* Entry action for state 'WaitForPlayerStop'. */
	ifaceAudioPlayerReqIf_OCB->stopPlayback();
}

/* Entry action for state 'AutoSaoff'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff()
{
	/* Entry action for state 'AutoSaoff'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
	ifaceWaitingModeToneSmHandler_OCB->updateStatus(DEALLOCATING, (sc_string) "Source Switch");
}

/* Entry action for state 'WaitPlayerTostop'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop()
{
	/* Entry action for state 'WaitPlayerTostop'. */
	ifaceAudioPlayerReqIf_OCB->stopPlayback();
}

/* Entry action for state 'PlaybackPaused'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused()
{
	/* Entry action for state 'PlaybackPaused'. */
	ifaceWaitingModeToneSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
}

/* Entry action for state 'WaitForPlayerToStop'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop()
{
	/* Entry action for state 'WaitForPlayerToStop'. */
	ifaceAudioPlayerReqIf_OCB->stopPlayback();
}

/* Entry action for state 'ChannelPaused'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused()
{
	/* Entry action for state 'ChannelPaused'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_PAUSE);
	ifaceWaitingModeToneSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Auto paused");
}

/* Entry action for state 'SAOnAfterPlayerResponse'. */
void WaitingModeToneAudioSm::enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse()
{
	/* Entry action for state 'SAOnAfterPlayerResponse'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
}

/* 'default' enter sequence for state Idle */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_Idle_default()
{
	/* 'default' enter sequence for state Idle */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_Idle);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_Idle;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingModeTonePlay */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_default()
{
	/* 'default' enter sequence for state WaitingModeTonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_default();
}

/* 'default' enter sequence for state WaitForAmClientRequest */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest_default()
{
	/* 'default' enter sequence for state WaitForAmClientRequest */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayWaitingModeToneRequest */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest_default()
{
	/* 'default' enter sequence for state PlayWaitingModeToneRequest */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForWaitingModeToneRouteAllocation */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation_default()
{
	/* 'default' enter sequence for state WaitForWaitingModeToneRouteAllocation */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation);
	}
	stateConfVector[1] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitingModeToneSAOnReceived */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived_default()
{
	/* 'default' enter sequence for state WaitingModeToneSAOnReceived */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived);
	}
	stateConfVector[1] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForSAOn */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn_default()
{
	/* 'default' enter sequence for state WaitForSAOn */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn);
	}
	stateConfVector[1] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitingModeTonePlaying */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying_default()
{
	/* 'default' enter sequence for state WaitingModeTonePlaying */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying;
	stateConfVectorPosition = 0;
}

/* 'AutoSAOff' enter sequence for state StopWaitingModeTonePlay */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_AutoSAOff()
{
	/* 'AutoSAOff' enter sequence for state StopWaitingModeTonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSAOff();
}

/* 'DeallocateRoute' enter sequence for state StopWaitingModeTonePlay */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_DeallocateRoute()
{
	/* 'DeallocateRoute' enter sequence for state StopWaitingModeTonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_DeallocateRoute();
}

/* 'StopAndDeallocate' enter sequence for state StopWaitingModeTonePlay */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopAndDeallocate()
{
	/* 'StopAndDeallocate' enter sequence for state StopWaitingModeTonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopAndDeallocate();
}

/* 'default' enter sequence for state StopWaitingModeTonePlay */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_default()
{
	/* 'default' enter sequence for state StopWaitingModeTonePlay */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_default();
}

/* 'default' enter sequence for state WaitForPlayerToStop */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_default()
{
	/* 'default' enter sequence for state WaitForPlayerToStop */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlaybackStopped */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_default()
{
	/* 'default' enter sequence for state PlaybackStopped */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForRouteDeallocation */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForRouteDeallocation */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation);
	}
	stateConfVector[1] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitingModeToneChannelDeallocated */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated_default()
{
	/* 'default' enter sequence for state WaitingModeToneChannelDeallocated */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated);
	}
	stateConfVector[1] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForRouteDeallocation */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForRouteDeallocation */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StreamingStopped */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped_default()
{
	/* 'default' enter sequence for state StreamingStopped */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForPlayerStop */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop_default()
{
	/* 'default' enter sequence for state WaitForPlayerStop */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSaoff */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff_default()
{
	/* 'default' enter sequence for state AutoSaoff */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseWaitingModeTone */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_default()
{
	/* 'default' enter sequence for state PauseWaitingModeTone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_default();
}

/* 'entry_AutoSAOffAfterEcnrResponse6' enter sequence for state PauseWaitingModeTone */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAOffAfterEcnrResponse6()
{
	/* 'entry_AutoSAOffAfterEcnrResponse6' enter sequence for state PauseWaitingModeTone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOffAfterEcnrResponse6();
}

/* 'entry_AutoSAOnAfterPlayerResponse8' enter sequence for state PauseWaitingModeTone */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAOnAfterPlayerResponse8()
{
	/* 'entry_AutoSAOnAfterPlayerResponse8' enter sequence for state PauseWaitingModeTone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOnAfterPlayerResponse8();
}

/* 'entry_AutoSAPauseAfterPlayerResponse4' enter sequence for state PauseWaitingModeTone */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAPauseAfterPlayerResponse4()
{
	/* 'entry_AutoSAPauseAfterPlayerResponse4' enter sequence for state PauseWaitingModeTone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAPauseAfterPlayerResponse4();
}

/* 'entry_PlayWaitingModeTone1' enter sequence for state PauseWaitingModeTone */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_PlayWaitingModeTone1()
{
	/* 'entry_PlayWaitingModeTone1' enter sequence for state PauseWaitingModeTone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_PlayWaitingModeTone1();
}

/* 'entry_StopAfterPlayerResponse0' enter sequence for state PauseWaitingModeTone */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_StopAfterPlayerResponse0()
{
	/* 'entry_StopAfterPlayerResponse0' enter sequence for state PauseWaitingModeTone */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_StopAfterPlayerResponse0();
}

/* 'default' enter sequence for state WaitPlayerTostop */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop_default()
{
	/* 'default' enter sequence for state WaitPlayerTostop */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlaybackPaused */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused_default()
{
	/* 'default' enter sequence for state PlaybackPaused */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state PlayAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state PauseAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state StopAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAPauseAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state AutoSAPauseAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOnAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state AutoSAOnAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'AutoSAPaused' enter sequence for state AutoSAPause */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPaused()
{
	/* 'AutoSAPaused' enter sequence for state AutoSAPause */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused();
}

/* 'default' enter sequence for state AutoSAPause */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_default()
{
	/* 'default' enter sequence for state AutoSAPause */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_default();
}

/* 'entry_AutoSAOffAfterPlayerResponse3' enter sequence for state AutoSAPause */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_entry_AutoSAOffAfterPlayerResponse3()
{
	/* 'entry_AutoSAOffAfterPlayerResponse3' enter sequence for state AutoSAPause */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3();
}

/* 'entry_StopAfterPlayerResponse4' enter sequence for state AutoSAPause */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_entry_StopAfterPlayerResponse4()
{
	/* 'entry_StopAfterPlayerResponse4' enter sequence for state AutoSAPause */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4();
}

/* 'default' enter sequence for state WaitForPlayerToStop */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_default()
{
	/* 'default' enter sequence for state WaitForPlayerToStop */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ChannelPaused */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default()
{
	/* 'default' enter sequence for state ChannelPaused */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state StopAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state SAOnAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state SAOnAfterPlayerResponse */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterPlayerResponse */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_default()
{
	/* 'default' enter sequence for state PauseAfterPlayerResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse);
	}
	stateConfVector[0] = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region WaitingModeToneAudioRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_default()
{
	/* 'default' enter sequence for region WaitingModeToneAudioRegion */
	react_WaitingModeToneAudioRegion__entry_Default();
}

/* 'default' enter sequence for region WaitingModeTonePlayRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_default()
{
	/* 'default' enter sequence for region WaitingModeTonePlayRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__entry_Default();
}

/* 'default' enter sequence for region StopWaitingModeTonePlay Region */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_default()
{
	/* 'default' enter sequence for region StopWaitingModeTonePlay Region */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__entry_Default();
}

/* 'DeallocateRoute' enter sequence for region StopWaitingModeTonePlay Region */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_DeallocateRoute()
{
	/* 'DeallocateRoute' enter sequence for region StopWaitingModeTonePlay Region */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_DeallocateRoute();
}

/* 'StopAndDeallocate' enter sequence for region StopWaitingModeTonePlay Region */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopAndDeallocate()
{
	/* 'StopAndDeallocate' enter sequence for region StopWaitingModeTonePlay Region */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopAndDeallocate();
}

/* 'AutoSAOff' enter sequence for region StopWaitingModeTonePlay Region */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSAOff()
{
	/* 'AutoSAOff' enter sequence for region StopWaitingModeTonePlay Region */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSAOff();
}

/* 'default' enter sequence for region PauseWaitingModeToneRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_default()
{
	/* 'default' enter sequence for region PauseWaitingModeToneRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion__entry_Default();
}

/* 'entry_StopAfterPlayerResponse0' enter sequence for region PauseWaitingModeToneRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_StopAfterPlayerResponse0()
{
	/* 'entry_StopAfterPlayerResponse0' enter sequence for region PauseWaitingModeToneRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_StopAfterPlayerResponse0();
}

/* 'entry_PlayWaitingModeTone1' enter sequence for region PauseWaitingModeToneRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_PlayWaitingModeTone1()
{
	/* 'entry_PlayWaitingModeTone1' enter sequence for region PauseWaitingModeToneRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_PlayWaitingModeTone1();
}

/* 'entry_AutoSAPauseAfterPlayerResponse4' enter sequence for region PauseWaitingModeToneRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAPauseAfterPlayerResponse4()
{
	/* 'entry_AutoSAPauseAfterPlayerResponse4' enter sequence for region PauseWaitingModeToneRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAPauseAfterPlayerResponse4();
}

/* 'entry_AutoSAOffAfterEcnrResponse6' enter sequence for region PauseWaitingModeToneRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOffAfterEcnrResponse6()
{
	/* 'entry_AutoSAOffAfterEcnrResponse6' enter sequence for region PauseWaitingModeToneRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOffAfterEcnrResponse6();
}

/* 'entry_AutoSAOnAfterPlayerResponse8' enter sequence for region PauseWaitingModeToneRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOnAfterPlayerResponse8()
{
	/* 'entry_AutoSAOnAfterPlayerResponse8' enter sequence for region PauseWaitingModeToneRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOnAfterPlayerResponse8();
}

/* 'default' enter sequence for region AutoSAPauseRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_default()
{
	/* 'default' enter sequence for region AutoSAPauseRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion__entry_Default();
}

/* 'AutoSAPaused' enter sequence for region AutoSAPauseRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused()
{
	/* 'AutoSAPaused' enter sequence for region AutoSAPauseRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused();
}

/* 'entry_AutoSAOffAfterPlayerResponse3' enter sequence for region AutoSAPauseRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3()
{
	/* 'entry_AutoSAOffAfterPlayerResponse3' enter sequence for region AutoSAPauseRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3();
}

/* 'entry_StopAfterPlayerResponse4' enter sequence for region AutoSAPauseRegion */
void WaitingModeToneAudioSm::enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4()
{
	/* 'entry_StopAfterPlayerResponse4' enter sequence for region AutoSAPauseRegion */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4();
}

/* Default exit sequence for state Idle */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_Idle()
{
	/* Default exit sequence for state Idle */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingModeTonePlay */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay()
{
	/* Default exit sequence for state WaitingModeTonePlay */
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion();
}

/* Default exit sequence for state WaitToPlayWaitingModeTone */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone()
{
	/* Default exit sequence for state WaitToPlayWaitingModeTone */
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion();
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion();
}

/* Default exit sequence for state WaitForAmClientRequest */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest()
{
	/* Default exit sequence for state WaitForAmClientRequest */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayWaitingModeToneRequest */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest()
{
	/* Default exit sequence for state PlayWaitingModeToneRequest */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForWaitingModeToneRouteAllocation */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation()
{
	/* Default exit sequence for state WaitForWaitingModeToneRouteAllocation */
	stateConfVector[1] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitingModeToneSAOnReceived */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived()
{
	/* Default exit sequence for state WaitingModeToneSAOnReceived */
	stateConfVector[1] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForSAOn */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn()
{
	/* Default exit sequence for state WaitForSAOn */
	stateConfVector[1] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitingModeTonePlaying */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying()
{
	/* Default exit sequence for state WaitingModeTonePlaying */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopWaitingModeTonePlay */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay()
{
	/* Default exit sequence for state StopWaitingModeTonePlay */
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region();
}

/* Default exit sequence for state StopPlay */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay()
{
	/* Default exit sequence for state StopPlay */
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion();
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion();
}

/* Default exit sequence for state WaitForPlayerToStop */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop()
{
	/* Default exit sequence for state WaitForPlayerToStop */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlaybackStopped */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped()
{
	/* Default exit sequence for state PlaybackStopped */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForRouteDeallocation */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation()
{
	/* Default exit sequence for state WaitForRouteDeallocation */
	stateConfVector[1] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitingModeToneChannelDeallocated */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated()
{
	/* Default exit sequence for state WaitingModeToneChannelDeallocated */
	stateConfVector[1] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForRouteDeallocation */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation()
{
	/* Default exit sequence for state WaitForRouteDeallocation */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StreamingStopped */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped()
{
	/* Default exit sequence for state StreamingStopped */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForPlayerStop */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop()
{
	/* Default exit sequence for state WaitForPlayerStop */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSaoff */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff()
{
	/* Default exit sequence for state AutoSaoff */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseWaitingModeTone */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone()
{
	/* Default exit sequence for state PauseWaitingModeTone */
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion();
}

/* Default exit sequence for state WaitPlayerTostop */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop()
{
	/* Default exit sequence for state WaitPlayerTostop */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlaybackPaused */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused()
{
	/* Default exit sequence for state PlaybackPaused */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse()
{
	/* Default exit sequence for state PlayAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse()
{
	/* Default exit sequence for state PauseAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse()
{
	/* Default exit sequence for state StopAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAPauseAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse()
{
	/* Default exit sequence for state AutoSAPauseAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOnAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse()
{
	/* Default exit sequence for state AutoSAOnAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAPause */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause()
{
	/* Default exit sequence for state AutoSAPause */
	exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion();
}

/* Default exit sequence for state WaitForPlayerToStop */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop()
{
	/* Default exit sequence for state WaitForPlayerToStop */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ChannelPaused */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused()
{
	/* Default exit sequence for state ChannelPaused */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse()
{
	/* Default exit sequence for state AutoSAOffAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse()
{
	/* Default exit sequence for state StopAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state SAOnAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse()
{
	/* Default exit sequence for state SAOnAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterPlayerResponse */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse()
{
	/* Default exit sequence for state PauseAfterPlayerResponse */
	stateConfVector[0] = WaitingModeToneAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for region WaitingModeToneAudioRegion */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion()
{
	/* Default exit sequence for region WaitingModeToneAudioRegion */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case WaitingModeToneAudioRegion_Idle :
		{
			exseq_WaitingModeToneAudioRegion_Idle();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region WaitingModeTonePlayRegion */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion()
{
	/* Default exit sequence for region WaitingModeTonePlayRegion */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AmClientRequestWaitRegion */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion()
{
	/* Default exit sequence for region AmClientRequestWaitRegion */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion.WaitToPlayWaitingModeTone.AmClientRequestWaitRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ArlResponseWaitRegion */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion()
{
	/* Default exit sequence for region ArlResponseWaitRegion */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion.WaitToPlayWaitingModeTone.ArlResponseWaitRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region StopWaitingModeTonePlay Region */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region()
{
	/* Default exit sequence for region StopWaitingModeTonePlay Region */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion.StopWaitingModeTonePlay.StopWaitingModeTonePlay_Region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion.StopWaitingModeTonePlay.StopWaitingModeTonePlay_Region) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AudioPlayerOperationRegion */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion()
{
	/* Default exit sequence for region AudioPlayerOperationRegion */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion.StopWaitingModeTonePlay.StopWaitingModeTonePlay_Region.StopPlay.AudioPlayerOperationRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AudioWrapperOperationRegion */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion()
{
	/* Default exit sequence for region AudioWrapperOperationRegion */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion.StopWaitingModeTonePlay.StopWaitingModeTonePlay_Region.StopPlay.AudioWrapperOperationRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region PauseWaitingModeToneRegion */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion()
{
	/* Default exit sequence for region PauseWaitingModeToneRegion */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion.PauseWaitingModeTone.PauseWaitingModeToneRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AutoSAPauseRegion */
void WaitingModeToneAudioSm::exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion()
{
	/* Default exit sequence for region AutoSAPauseRegion */
	/* Handle exit of all possible states (of WaitingModeToneAudioSm.WaitingModeToneAudioRegion.WaitingModeTonePlay.WaitingModeTonePlayRegion.AutoSAPause.AutoSAPauseRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
			break;
		}
		case WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse :
		{
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
			break;
		}
		default: break;
	}
}

/* Default react sequence for initial entry  */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__sync1();
}

/* Default react sequence for initial entry  */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__sync0();
}

/* Default react sequence for initial entry DeallocateRoute */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_DeallocateRoute()
{
	/* Default react sequence for initial entry DeallocateRoute */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation_default();
}

/* Default react sequence for initial entry StopAndDeallocate */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopAndDeallocate()
{
	/* Default react sequence for initial entry StopAndDeallocate */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop_default();
}

/* Default react sequence for initial entry AutoSAOff */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSAOff()
{
	/* Default react sequence for initial entry AutoSAOff */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff_default();
}

/* Default react sequence for initial entry  */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop_default();
}

/* Default react sequence for initial entry entry_StopAfterPlayerResponse0 */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_StopAfterPlayerResponse0()
{
	/* Default react sequence for initial entry entry_StopAfterPlayerResponse0 */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse_default();
}

/* Default react sequence for initial entry entry_PlayWaitingModeTone1 */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_PlayWaitingModeTone1()
{
	/* Default react sequence for initial entry entry_PlayWaitingModeTone1 */
	react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayWaitingModeTone();
}

/* Default react sequence for initial entry entry_AutoSAPauseAfterPlayerResponse4 */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAPauseAfterPlayerResponse4()
{
	/* Default react sequence for initial entry entry_AutoSAPauseAfterPlayerResponse4 */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse6 */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOffAfterEcnrResponse6()
{
	/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse6 */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAOnAfterPlayerResponse8 */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_entry_AutoSAOnAfterPlayerResponse8()
{
	/* Default react sequence for initial entry entry_AutoSAOnAfterPlayerResponse8 */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse_default();
}

/* Default react sequence for initial entry  */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_default();
}

/* Default react sequence for initial entry AutoSAPaused */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAPaused()
{
	/* Default react sequence for initial entry AutoSAPaused */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default();
}

/* Default react sequence for initial entry entry_AutoSAOffAfterPlayerResponse3 */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_AutoSAOffAfterPlayerResponse3()
{
	/* Default react sequence for initial entry entry_AutoSAOffAfterPlayerResponse3 */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_default();
}

/* Default react sequence for initial entry entry_StopAfterPlayerResponse4 */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_entry_StopAfterPlayerResponse4()
{
	/* Default react sequence for initial entry entry_StopAfterPlayerResponse4 */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_default();
}

/* Default react sequence for initial entry  */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_WaitingModeToneAudioRegion_Idle_default();
}

/* The reactions of exit ChannelDenied. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDenied()
{
	/* The reactions of exit ChannelDenied. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_tr0();
}

/* The reactions of exit ExitOnChannelDeallocated. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_ExitOnChannelDeallocated()
{
	/* The reactions of exit ExitOnChannelDeallocated. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_tr1();
}

/* The reactions of exit PlayWaitingModeTone. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayWaitingModeTone()
{
	/* The reactions of exit PlayWaitingModeTone. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr2();
}

/* The reactions of exit StopWaitingModeTone. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopWaitingModeTone()
{
	/* The reactions of exit StopWaitingModeTone. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr3();
}

/* The reactions of exit AutoSAPause. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPause()
{
	/* The reactions of exit AutoSAPause. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr5();
}

/* The reactions of exit AutoSAOff. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOff()
{
	/* The reactions of exit AutoSAOff. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_tr7();
}

/* The reactions of exit PlayWaitingModeTone. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PlayWaitingModeTone()
{
	/* The reactions of exit PlayWaitingModeTone. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr0();
}

/* The reactions of exit AutoSAOff. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOff()
{
	/* The reactions of exit AutoSAOff. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr1();
}

/* The reactions of exit DeallocateRoute. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_DeallocateRoute()
{
	/* The reactions of exit DeallocateRoute. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_tr2();
}

/* The reactions of exit ChannelDeallocated. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDeallocated()
{
	/* The reactions of exit ChannelDeallocated. */
	effect_WaitingModeToneAudioRegion_WaitingModeTonePlay_tr1();
}

/* The reactions of state null. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__sync0()
{
	/* The reactions of state null. */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying_default();
}

/* The reactions of state null. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__sync1()
{
	/* The reactions of state null. */
	enact_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest_default();
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation_default();
}

/* The reactions of state null. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__sync0()
{
	/* The reactions of state null. */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay);
	}
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_default();
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_default();
}

/* The reactions of state null. */
void WaitingModeToneAudioSm::react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__sync1()
{
	/* The reactions of state null. */
	enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped_default();
}

sc_boolean WaitingModeToneAudioSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_Idle_react(const sc_boolean try_transition) {
	/* The reactions of state Idle. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PREPARE_WAITING_MODE_TONE_CHANNEL_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_Idle();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_default();
			react();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_ON_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
		} 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingModeTonePlay. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_react(const sc_boolean try_transition) {
	/* The reactions of state WaitToPlayWaitingModeTone. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_DENIED_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
			ifaceWaitingModeToneSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Channel Denied");
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDenied();
		}  else
		{
			if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_AutoSAOff();
				WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STOP_WAITING_MODE_TONE_raised)
				{ 
					exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
					enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_DeallocateRoute();
					WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAmClientRequest. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PLAY_WAITING_MODE_TONE_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_WaitForAmClientRequest();
			ifaceWaitingModeToneSmHandler_OCB->updateWaitingModeToneFilePath(ifaceAmClientRequest.PLAY_WAITING_MODE_TONE_value);
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest_react(const sc_boolean try_transition) {
	/* The reactions of state PlayWaitingModeToneRequest. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.READY_TO_PLAY_raised) && (isStateActive(WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived))) && (ifaceInternalSCI.READY_TO_PLAY_raised))
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__sync0();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForWaitingModeToneRouteAllocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_GRANTED_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForWaitingModeToneRouteAllocation();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STOP_WAITING_MODE_TONE_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
				ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
				ifaceWaitingModeToneSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
				react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDeallocated();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingModeToneSAOnReceived. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.READY_TO_PLAY_raised) && (isStateActive(WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_AmClientRequestWaitRegion_PlayWaitingModeToneRequest))) && (ifaceInternalSCI.READY_TO_PLAY_raised))
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion__sync0();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSAOn. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_ON_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitForSAOn();
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_ArlResponseWaitRegion_WaitingModeToneSAOnReceived_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_DEALLOCATED_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone();
				ifaceWaitingModeToneSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
				react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDeallocated();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitToPlayWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingModeTonePlaying. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_WAITING_MODE_TONE_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
		}  else
		{
			if (ifaceAudioPlayerResponse.PLAYING_ERROR_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_DeallocateRoute();
				WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
			}  else
			{
				if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
				{ 
					exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
					enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopAndDeallocate();
					WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
				}  else
				{
					if (ifaceAmClientRequest.PAUSE_WAITING_MODE_TONE_raised)
					{ 
						exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
						enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_default();
						WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
					}  else
					{
						if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_PAUSE_raised)
						{ 
							exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_WaitingModeTonePlaying();
							enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_default();
							WaitingModeToneAudioRegion_WaitingModeTonePlay_react(false);
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioPlayerResponse.PLAYING_SUCCESS_raised)
		{ 
			ifaceWaitingModeToneSmHandler_OCB->updateStatus(STREAMING, (sc_string) "Streaming");
		} 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_react(const sc_boolean try_transition) {
	/* The reactions of state StopWaitingModeTonePlay. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_DEALLOCATED_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay();
			ifaceWaitingModeToneSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_ChannelDeallocated();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_react(const sc_boolean try_transition) {
	/* The reactions of state StopPlay. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayerToStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAudioPlayerResponse.STOP_SUCCESS_raised) || (ifaceAudioPlayerResponse.STOP_FAILURE_raised))
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_WaitForPlayerToStop();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped_react(const sc_boolean try_transition) {
	/* The reactions of state PlaybackStopped. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitForRouteDeallocation();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioWrapperOperationRegion_WaitingModeToneChannelDeallocated_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingModeToneChannelDeallocated. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_AudioPlayerOperationRegion_PlaybackStopped))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StopPlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
		} 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_ON_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
		} 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_StreamingStopped_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingStopped. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayerStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_WaitForPlayerStop();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSaoff. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_CHANNEL_DEALLOCATED_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_AutoSaoff();
			ifaceWaitingModeToneSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Source Switch");
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_StopWaitingModeTonePlay_Region_ExitOnChannelDeallocated();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_StopWaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(const sc_boolean try_transition) {
	/* The reactions of state PauseWaitingModeTone. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_WAITING_MODE_TONE_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_StopAfterPlayerResponse0();
		}  else
		{
			if (ifaceAmClientRequest.PLAY_WAITING_MODE_TONE_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_PlayWaitingModeTone1();
			}  else
			{
				if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_PAUSE_raised)
				{ 
					exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
					enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAPauseAfterPlayerResponse4();
				}  else
				{
					if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
					{ 
						exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
						enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAOffAfterEcnrResponse6();
					}  else
					{
						if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_ON_raised)
						{ 
							exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone();
							ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
							enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_entry_AutoSAOnAfterPlayerResponse8();
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitPlayerTostop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(false);
		}  else
		{
			if (ifaceAmClientRequest.PLAY_WAITING_MODE_TONE_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_WaitPlayerTostop();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse_default();
				WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused_react(const sc_boolean try_transition) {
	/* The reactions of state PlaybackPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_PAUSE_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPause();
		}  else
		{
			if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
				react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOff();
			}  else
			{
				if (ifaceAmClientRequest.STOP_WAITING_MODE_TONE_raised)
				{ 
					exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused();
					react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopWaitingModeTone();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_WAITING_MODE_TONE_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(false);
		}  else
		{
			if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse();
				react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayWaitingModeTone();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlaybackPaused_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(false);
		}  else
		{
			if (ifaceAmClientRequest.PLAY_WAITING_MODE_TONE_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PauseAfterPlayerResponse();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayAfterPlayerResponse_default();
				WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopAfterPlayerResponse();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_StopWaitingModeTone();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAPauseAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAudioPlayerResponse.STOP_SUCCESS_raised) || (ifaceAudioPlayerResponse.STOP_FAILURE_raised))
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPauseAfterPlayerResponse();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAPause();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAudioPlayerResponse.STOP_SUCCESS_raised) || (ifaceAudioPlayerResponse.STOP_FAILURE_raised))
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOffAfterEcnrResponse();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOff();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOnAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_AutoSAOnAfterPlayerResponse();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_PauseWaitingModeToneRegion_PlayWaitingModeTone();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_PauseWaitingModeTone_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAPause. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_entry_AutoSAOffAfterPlayerResponse3();
		}  else
		{
			if (ifaceAmClientRequest.STOP_WAITING_MODE_TONE_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_entry_StopAfterPlayerResponse4();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PAUSE_WAITING_MODE_TONE_raised)
		{ 
			ifaceWaitingModeToneSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
		} 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayerToStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_ON_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_WaitForPlayerToStop();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_default();
				WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_ON_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PlayWaitingModeTone();
		}  else
		{
			if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_OFF_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
				react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOff();
			}  else
			{
				if (ifaceAmClientRequest.STOP_WAITING_MODE_TONE_raised)
				{ 
					exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused();
					react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_DeallocateRoute();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOffAfterPlayerResponse();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_AutoSAOff();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_StopAfterPlayerResponse();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_DeallocateRoute();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state SAOnAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
			react_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PlayWaitingModeTone();
		}  else
		{
			if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_PAUSE_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_default();
				WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}

sc_boolean WaitingModeToneAudioSm::WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterPlayerResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.WAITING_MODE_TONE_SA_ON_raised)
		{ 
			exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
			enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_SAOnAfterPlayerResponse_default();
			WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(false);
		}  else
		{
			if (ifaceAudioPlayerResponse.STOP_SUCCESS_raised)
			{ 
				exseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_PauseAfterPlayerResponse();
				enseq_WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_AutoSAPauseRegion_ChannelPaused_default();
				WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = WaitingModeToneAudioRegion_WaitingModeTonePlay_WaitingModeTonePlayRegion_AutoSAPause_react(try_transition);
	} 
	return did_transition;
}



