/* *
 * @file VoiceRecAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from VoiceRecAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#include "VoiceRecAudioSm.h"

/*! \file Implementation of the state machine 'VoiceRecAudioSm'
*/




VoiceRecAudioSm::VoiceRecAudioSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceAmClientRequest(this),
ifaceAudioWrapperReqIf(this),
ifaceAudioWrapperReqIf_OCB(sc_null),
ifaceAudioWrapperResponse(this),
ifaceEcnrRequest(this),
ifaceEcnrRequest_OCB(sc_null),
ifaceEcnrResponse(this),
ifaceVoiceRecAudioSmHandler(this),
ifaceVoiceRecAudioSmHandler_OCB(sc_null),
ifaceInternalSCI(this),
isRunningCycle(false)
{
}

VoiceRecAudioSm::~VoiceRecAudioSm()
{
}


using namespace voicerecaudiosm_events;

SctEvent* VoiceRecAudioSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!internalEventQueue.empty()) {
		nextEvent = internalEventQueue.front();
		internalEventQueue.pop_front();
	}
	else if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void VoiceRecAudioSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_AmClientRequest_PREPARE_VOICEREC_CHANNEL:
		case SCI_AmClientRequest_STREAM_VOICEREC_AUDIO:
		case SCI_AmClientRequest_PAUSE_VOICEREC_AUDIO:
		case SCI_AmClientRequest_STOP_VOICEREC_AUDIO:
		{
			ifaceAmClientRequest.dispatch_event(event);
			break;
		}
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_GRANTED:
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DENIED:
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DEALLOCATED:
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_ON:
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_OFF:
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_PAUSE:
		{
			ifaceAudioWrapperResponse.dispatch_event(event);
			break;
		}
		case SCI_EcnrResponse_ECNR_INIT_SUCCESS:
		case SCI_EcnrResponse_ECNR_INIT_FAILURE:
		case SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS:
		case SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE:
		case SCI_EcnrResponse_ECNR_START_SUCCESS:
		case SCI_EcnrResponse_ECNR_START_FAILURE:
		case SCI_EcnrResponse_ECNR_STOP_SUCCESS:
		case SCI_EcnrResponse_ECNR_STOP_FAILURE:
		case SCI_EcnrResponse_ECNR_DESTROY_SUCCESS:
		case SCI_EcnrResponse_ECNR_DESTROY_FAILURE:
		{
			ifaceEcnrResponse.dispatch_event(event);
			break;
		}
		case InternalSCI_READY_TO_PLAY:
		case InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT:
		{
			ifaceInternalSCI.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void VoiceRecAudioSm::SCI_AmClientRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AmClientRequest_PREPARE_VOICEREC_CHANNEL:
		{
			internal_raise_pREPARE_VOICEREC_CHANNEL();
			break;
		}
		case SCI_AmClientRequest_STREAM_VOICEREC_AUDIO:
		{
			SctEvent_SCI_AmClientRequest_STREAM_VOICEREC_AUDIO * e = static_cast<SctEvent_SCI_AmClientRequest_STREAM_VOICEREC_AUDIO*>(event);
			if(e != 0) {
				internal_raise_sTREAM_VOICEREC_AUDIO(e->value);
			}
			break;
		}
		case SCI_AmClientRequest_PAUSE_VOICEREC_AUDIO:
		{
			internal_raise_pAUSE_VOICEREC_AUDIO();
			break;
		}
		case SCI_AmClientRequest_STOP_VOICEREC_AUDIO:
		{
			internal_raise_sTOP_VOICEREC_AUDIO();
			break;
		}
		default:
			break;
	}
}
void VoiceRecAudioSm::SCI_AudioWrapperReqIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VoiceRecAudioSm::SCI_AudioWrapperResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_GRANTED:
		{
			internal_raise_vOICEREC_AUDIO_CHANNEL_GRANTED();
			break;
		}
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DENIED:
		{
			internal_raise_vOICEREC_AUDIO_CHANNEL_DENIED();
			break;
		}
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DEALLOCATED:
		{
			internal_raise_vOICEREC_AUDIO_CHANNEL_DEALLOCATED();
			break;
		}
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_ON:
		{
			internal_raise_vOICEREC_AUDIO_SA_ON();
			break;
		}
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_OFF:
		{
			internal_raise_vOICEREC_AUDIO_SA_OFF();
			break;
		}
		case SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_PAUSE:
		{
			internal_raise_vOICEREC_AUDIO_SA_PAUSE();
			break;
		}
		default:
			break;
	}
}
void VoiceRecAudioSm::SCI_EcnrRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VoiceRecAudioSm::SCI_EcnrResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_EcnrResponse_ECNR_INIT_SUCCESS:
		{
			internal_raise_eCNR_INIT_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_INIT_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_INIT_FAILURE(e->value);
			}
			break;
		}
		case SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS:
		{
			internal_raise_eCNR_SET_CONFIGURATION_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_SET_CONFIGURATION_FAILURE(e->value);
			}
			break;
		}
		case SCI_EcnrResponse_ECNR_START_SUCCESS:
		{
			internal_raise_eCNR_START_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_START_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_START_FAILURE(e->value);
			}
			break;
		}
		case SCI_EcnrResponse_ECNR_STOP_SUCCESS:
		{
			internal_raise_eCNR_STOP_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_STOP_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_STOP_FAILURE(e->value);
			}
			break;
		}
		case SCI_EcnrResponse_ECNR_DESTROY_SUCCESS:
		{
			internal_raise_eCNR_DESTROY_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_ECNR_DESTROY_FAILURE:
		{
			SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE * e = static_cast<SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE*>(event);
			if(e != 0) {
				internal_raise_eCNR_DESTROY_FAILURE(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void VoiceRecAudioSm::SCI_VoiceRecAudioSmHandler::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void VoiceRecAudioSm::InternalSCI::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case InternalSCI_READY_TO_PLAY:
		{
			internal_raise_rEADY_TO_PLAY();
			break;
		}
		case InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT:
		{
			internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT();
			break;
		}
		default:
			break;
	}
}


void VoiceRecAudioSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = VoiceRecAudioSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
}

void VoiceRecAudioSm::enter()
{
	/* Default enter sequence for statechart VoiceRecAudioSm */
	enseq_VoiceRecAudioRegion_default();
}

void VoiceRecAudioSm::exit()
{
	/* Default exit sequence for statechart VoiceRecAudioSm */
	exseq_VoiceRecAudioRegion();
}

sc_boolean VoiceRecAudioSm::isActive() const
{
	return stateConfVector[0] != VoiceRecAudioSm_last_state||stateConfVector[1] != VoiceRecAudioSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean VoiceRecAudioSm::isFinal() const
{
   return false;}

void VoiceRecAudioSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case VoiceRecAudioRegion_IDLE :
				{
					VoiceRecAudioRegion_IDLE_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_react(true);
					break;
				}
				case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop :
				{
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void VoiceRecAudioSm::clearInEvents()
{
	ifaceAmClientRequest.PREPARE_VOICEREC_CHANNEL_raised = false;
	ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised = false;
	ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised = false;
	ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised = false;
	ifaceAudioWrapperResponse.VOICEREC_AUDIO_CHANNEL_GRANTED_raised = false;
	ifaceAudioWrapperResponse.VOICEREC_AUDIO_CHANNEL_DENIED_raised = false;
	ifaceAudioWrapperResponse.VOICEREC_AUDIO_CHANNEL_DEALLOCATED_raised = false;
	ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised = false;
	ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised = false;
	ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised = false;
	ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_INIT_FAILURE_raised = false;
	ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised = false;
	ifaceEcnrResponse.ECNR_START_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_START_FAILURE_raised = false;
	ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_STOP_FAILURE_raised = false;
	ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised = false;
	ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised = false;
	ifaceInternalSCI.READY_TO_PLAY_raised = false; 
	ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised = false; 
}

void VoiceRecAudioSm::clearOutEvents()
{
}


sc_boolean VoiceRecAudioSm::isStateActive(VoiceRecAudioSmStates state) const
{
	switch (state)
	{
		case VoiceRecAudioRegion_IDLE : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_IDLE] == VoiceRecAudioRegion_IDLE
			);
		case VoiceRecAudioRegion_VoiceRecAudio : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO] >= VoiceRecAudioRegion_VoiceRecAudio
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_AMCLIENTREQUESTWAITREGION_WAITFORPLAYREQUEST] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_AMCLIENTREQUESTWAITREGION_READYTOSTREAM] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_ARLRESPONSEWAITREGION_WAITFORVOICERECROUTEALLOCATION] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_ARLRESPONSEWAITREGION_VOICERECSAONRECEIVED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PREPARINGVOICERECAUDIO_ARLRESPONSEWAITREGION_WAITFORSAON] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_WAITFORECNRINIT] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_WAITFORECNRSTART] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_STOPAFTERECNRINIT] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_STOPAFTERECNRSTART] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_AUTOSAOFFATECNRSTART] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_AUTOSAOFFATECNRINIT] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_STREAMING] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CHANNELPAUSED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_WAITFORECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_READYTOSTREAM] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CONFIGUREANDSTREAM] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_CHANNELACTIVATED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRCONFIGURED_PAUSEAUDIOREGION_PLAYAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_CHANNELPAUSED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_WAITFORECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_CHANNELACTIVATED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STREAMINGVOICERECAUDIO_VOICERECAUDIOSTREAMINGREGION_PAUSEAUDIOREQUESTBEFOREECNRSTARTED_PAUSEAUDIOREGION_PLAYAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRSTOP] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRDESTROY] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ECNROPERATION_ECNRDESTROYED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ARLOPERATION_WAITFORVOICERECROUTEDEALLOCATION] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STOPSTREAMINGANDDEALLOCATECHANNEL_ARLOPERATION_VOICERECSAOFF] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_STREAMINGSTOPPED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_WAITFORROUTEDEALLOCATION] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ECNROPERATION_WAITFORECNRDESTROY] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ECNROPERATION_ECNRDESTROYED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ARLOPERATION_WAITFORVOICERECROUTEDEALLOCATION] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_DESTROYECNRANDDEALLOCATECHANNEL_ARLOPERATION_VOICERECSAOFF] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_WAITFORECNRDESTROY] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_WAITFORECNRSTOP] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_STOPVOICERECAUDIOSTREAMING_STOPVOICERECAUDIOSTREAMINGREGION_AUTOSOURCESWITCH] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_WAITFORECNRSTOP] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_VOICERECAUDIOPAUSED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_PLAYAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_WAITFORECNRCONFIGURE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_PAUSEAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_STOPAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_AUTOSAOFFAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_AUTOSAPAUSEAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_PAUSEVOICERECAUDIO_PAUSEVOICERECAUDIOREGION_AUTOSAONAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED] >= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused
				&& stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED] <= VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_WAITFORECNRDESTROY] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_CHANNELAUTOPAUSED] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_WAITFORECNRSTOP] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STARTTOSTREAM] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_CONFIGUREANDSTREAM] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_AUTOSAOFFAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STOPAFTERECNRRESPONSE] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_STOPAFTERECNRSTOP] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_AUTOSAOFFAFTERECNRSTOP] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_PAUSEAFTERECNRDESTROY] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy
			);
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop : 
			return (sc_boolean) (stateConfVector[SCVI_VOICERECAUDIOREGION_VOICERECAUDIO_VOICERECAUDIOSTARTREGION_AUTOPAUSED_AUTOPAUSEREGION_PAUSEAFTERECNRSTOP] == VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop
			);
		default: return false;
	}
}

VoiceRecAudioSm::SCI_AmClientRequest* VoiceRecAudioSm::getSCI_AmClientRequest()
{
	return &ifaceAmClientRequest;
}
/* Functions for event PREPARE_VOICEREC_CHANNEL in interface SCI_AmClientRequest */
void VoiceRecAudioSm::SCI_AmClientRequest::raise_pREPARE_VOICEREC_CHANNEL()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PREPARE_VOICEREC_CHANNEL(SCI_AmClientRequest_PREPARE_VOICEREC_CHANNEL));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AmClientRequest::internal_raise_pREPARE_VOICEREC_CHANNEL()
{
	PREPARE_VOICEREC_CHANNEL_raised = true;
}
/* Functions for event STREAM_VOICEREC_AUDIO in interface SCI_AmClientRequest */
void VoiceRecAudioSm::SCI_AmClientRequest::raise_sTREAM_VOICEREC_AUDIO(SamplingType value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_STREAM_VOICEREC_AUDIO(SCI_AmClientRequest_STREAM_VOICEREC_AUDIO, value));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AmClientRequest::internal_raise_sTREAM_VOICEREC_AUDIO(SamplingType value)
{
	STREAM_VOICEREC_AUDIO_value = value;
	STREAM_VOICEREC_AUDIO_raised = true;
}
/* Functions for event PAUSE_VOICEREC_AUDIO in interface SCI_AmClientRequest */
void VoiceRecAudioSm::SCI_AmClientRequest::raise_pAUSE_VOICEREC_AUDIO()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_PAUSE_VOICEREC_AUDIO(SCI_AmClientRequest_PAUSE_VOICEREC_AUDIO));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AmClientRequest::internal_raise_pAUSE_VOICEREC_AUDIO()
{
	PAUSE_VOICEREC_AUDIO_raised = true;
}
/* Functions for event STOP_VOICEREC_AUDIO in interface SCI_AmClientRequest */
void VoiceRecAudioSm::SCI_AmClientRequest::raise_sTOP_VOICEREC_AUDIO()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_STOP_VOICEREC_AUDIO(SCI_AmClientRequest_STOP_VOICEREC_AUDIO));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AmClientRequest::internal_raise_sTOP_VOICEREC_AUDIO()
{
	STOP_VOICEREC_AUDIO_raised = true;
}
VoiceRecAudioSm::SCI_AudioWrapperReqIf* VoiceRecAudioSm::getSCI_AudioWrapperReqIf()
{
	return &ifaceAudioWrapperReqIf;
}
void VoiceRecAudioSm::setSCI_AudioWrapperReqIf_OCB(SCI_AudioWrapperReqIf_OCB* operationCallback)
{
	ifaceAudioWrapperReqIf_OCB = operationCallback;
}
VoiceRecAudioSm::SCI_AudioWrapperResponse* VoiceRecAudioSm::getSCI_AudioWrapperResponse()
{
	return &ifaceAudioWrapperResponse;
}
/* Functions for event VOICEREC_AUDIO_CHANNEL_GRANTED in interface SCI_AudioWrapperResponse */
void VoiceRecAudioSm::SCI_AudioWrapperResponse::raise_vOICEREC_AUDIO_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_GRANTED(SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_GRANTED));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICEREC_AUDIO_CHANNEL_GRANTED()
{
	VOICEREC_AUDIO_CHANNEL_GRANTED_raised = true;
}
/* Functions for event VOICEREC_AUDIO_CHANNEL_DENIED in interface SCI_AudioWrapperResponse */
void VoiceRecAudioSm::SCI_AudioWrapperResponse::raise_vOICEREC_AUDIO_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DENIED(SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DENIED));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICEREC_AUDIO_CHANNEL_DENIED()
{
	VOICEREC_AUDIO_CHANNEL_DENIED_raised = true;
}
/* Functions for event VOICEREC_AUDIO_CHANNEL_DEALLOCATED in interface SCI_AudioWrapperResponse */
void VoiceRecAudioSm::SCI_AudioWrapperResponse::raise_vOICEREC_AUDIO_CHANNEL_DEALLOCATED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DEALLOCATED(SCI_AudioWrapperResponse_VOICEREC_AUDIO_CHANNEL_DEALLOCATED));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICEREC_AUDIO_CHANNEL_DEALLOCATED()
{
	VOICEREC_AUDIO_CHANNEL_DEALLOCATED_raised = true;
}
/* Functions for event VOICEREC_AUDIO_SA_ON in interface SCI_AudioWrapperResponse */
void VoiceRecAudioSm::SCI_AudioWrapperResponse::raise_vOICEREC_AUDIO_SA_ON()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_ON(SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_ON));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICEREC_AUDIO_SA_ON()
{
	VOICEREC_AUDIO_SA_ON_raised = true;
}
/* Functions for event VOICEREC_AUDIO_SA_OFF in interface SCI_AudioWrapperResponse */
void VoiceRecAudioSm::SCI_AudioWrapperResponse::raise_vOICEREC_AUDIO_SA_OFF()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_OFF(SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_OFF));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICEREC_AUDIO_SA_OFF()
{
	VOICEREC_AUDIO_SA_OFF_raised = true;
}
/* Functions for event VOICEREC_AUDIO_SA_PAUSE in interface SCI_AudioWrapperResponse */
void VoiceRecAudioSm::SCI_AudioWrapperResponse::raise_vOICEREC_AUDIO_SA_PAUSE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_PAUSE(SCI_AudioWrapperResponse_VOICEREC_AUDIO_SA_PAUSE));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_AudioWrapperResponse::internal_raise_vOICEREC_AUDIO_SA_PAUSE()
{
	VOICEREC_AUDIO_SA_PAUSE_raised = true;
}
VoiceRecAudioSm::SCI_EcnrRequest* VoiceRecAudioSm::getSCI_EcnrRequest()
{
	return &ifaceEcnrRequest;
}
void VoiceRecAudioSm::setSCI_EcnrRequest_OCB(SCI_EcnrRequest_OCB* operationCallback)
{
	ifaceEcnrRequest_OCB = operationCallback;
}
VoiceRecAudioSm::SCI_EcnrResponse* VoiceRecAudioSm::getSCI_EcnrResponse()
{
	return &ifaceEcnrResponse;
}
/* Functions for event ECNR_INIT_SUCCESS in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_INIT_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_INIT_SUCCESS(SCI_EcnrResponse_ECNR_INIT_SUCCESS));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_INIT_SUCCESS()
{
	ECNR_INIT_SUCCESS_raised = true;
}
/* Functions for event ECNR_INIT_FAILURE in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_INIT_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_INIT_FAILURE(SCI_EcnrResponse_ECNR_INIT_FAILURE, value));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_INIT_FAILURE(AmResultMessage value)
{
	ECNR_INIT_FAILURE_value = value;
	ECNR_INIT_FAILURE_raised = true;
}
/* Functions for event ECNR_SET_CONFIGURATION_SUCCESS in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_SET_CONFIGURATION_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS(SCI_EcnrResponse_ECNR_SET_CONFIGURATION_SUCCESS));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_SET_CONFIGURATION_SUCCESS()
{
	ECNR_SET_CONFIGURATION_SUCCESS_raised = true;
}
/* Functions for event ECNR_SET_CONFIGURATION_FAILURE in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_SET_CONFIGURATION_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE(SCI_EcnrResponse_ECNR_SET_CONFIGURATION_FAILURE, value));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_SET_CONFIGURATION_FAILURE(AmResultMessage value)
{
	ECNR_SET_CONFIGURATION_FAILURE_value = value;
	ECNR_SET_CONFIGURATION_FAILURE_raised = true;
}
/* Functions for event ECNR_START_SUCCESS in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_START_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_START_SUCCESS(SCI_EcnrResponse_ECNR_START_SUCCESS));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_START_SUCCESS()
{
	ECNR_START_SUCCESS_raised = true;
}
/* Functions for event ECNR_START_FAILURE in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_START_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_START_FAILURE(SCI_EcnrResponse_ECNR_START_FAILURE, value));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_START_FAILURE(AmResultMessage value)
{
	ECNR_START_FAILURE_value = value;
	ECNR_START_FAILURE_raised = true;
}
/* Functions for event ECNR_STOP_SUCCESS in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_STOP_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_STOP_SUCCESS(SCI_EcnrResponse_ECNR_STOP_SUCCESS));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_STOP_SUCCESS()
{
	ECNR_STOP_SUCCESS_raised = true;
}
/* Functions for event ECNR_STOP_FAILURE in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_STOP_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_STOP_FAILURE(SCI_EcnrResponse_ECNR_STOP_FAILURE, value));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_STOP_FAILURE(AmResultMessage value)
{
	ECNR_STOP_FAILURE_value = value;
	ECNR_STOP_FAILURE_raised = true;
}
/* Functions for event ECNR_DESTROY_SUCCESS in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_DESTROY_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_DESTROY_SUCCESS(SCI_EcnrResponse_ECNR_DESTROY_SUCCESS));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_DESTROY_SUCCESS()
{
	ECNR_DESTROY_SUCCESS_raised = true;
}
/* Functions for event ECNR_DESTROY_FAILURE in interface SCI_EcnrResponse */
void VoiceRecAudioSm::SCI_EcnrResponse::raise_eCNR_DESTROY_FAILURE(AmResultMessage value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_ECNR_DESTROY_FAILURE(SCI_EcnrResponse_ECNR_DESTROY_FAILURE, value));
	parent->runCycle();
}
void VoiceRecAudioSm::SCI_EcnrResponse::internal_raise_eCNR_DESTROY_FAILURE(AmResultMessage value)
{
	ECNR_DESTROY_FAILURE_value = value;
	ECNR_DESTROY_FAILURE_raised = true;
}
VoiceRecAudioSm::SCI_VoiceRecAudioSmHandler* VoiceRecAudioSm::getSCI_VoiceRecAudioSmHandler()
{
	return &ifaceVoiceRecAudioSmHandler;
}
SamplingType VoiceRecAudioSm::SCI_VoiceRecAudioSmHandler::get_samplingType() const
{
	return samplingType;
}

void VoiceRecAudioSm::SCI_VoiceRecAudioSmHandler::set_samplingType(SamplingType value)
{
	samplingType = value;
}

void VoiceRecAudioSm::setSCI_VoiceRecAudioSmHandler_OCB(SCI_VoiceRecAudioSmHandler_OCB* operationCallback)
{
	ifaceVoiceRecAudioSmHandler_OCB = operationCallback;
}
/* Functions for event READY_TO_PLAY in interface InternalSCI */
void VoiceRecAudioSm::InternalSCI::raise_rEADY_TO_PLAY()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
	parent->runCycle();
}
void VoiceRecAudioSm::InternalSCI::internal_raise_rEADY_TO_PLAY()
{
	READY_TO_PLAY_raised = true;
}
sc_boolean VoiceRecAudioSm::InternalSCI::isRaised_rEADY_TO_PLAY() const
{
	return READY_TO_PLAY_raised;
}
/* Functions for event SEND_SRC_ACTIVITY_OFF_RESULT in interface InternalSCI */
void VoiceRecAudioSm::InternalSCI::raise_sEND_SRC_ACTIVITY_OFF_RESULT()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
	parent->runCycle();
}
void VoiceRecAudioSm::InternalSCI::internal_raise_sEND_SRC_ACTIVITY_OFF_RESULT()
{
	SEND_SRC_ACTIVITY_OFF_RESULT_raised = true;
}
sc_boolean VoiceRecAudioSm::InternalSCI::isRaised_sEND_SRC_ACTIVITY_OFF_RESULT() const
{
	return SEND_SRC_ACTIVITY_OFF_RESULT_raised;
}

void VoiceRecAudioSm::setTraceObserver(ysc::TraceObserver<VoiceRecAudioSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<VoiceRecAudioSm::VoiceRecAudioSmStates>* VoiceRecAudioSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

sc_boolean VoiceRecAudioSm::check_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr0_tr0()
{
	return (ifaceVoiceRecAudioSmHandler.samplingType) == (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_value);
}

sc_boolean VoiceRecAudioSm::check_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr0_tr0()
{
	return (ifaceVoiceRecAudioSmHandler.samplingType) == (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_value);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_tr0()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio();
	enseq_VoiceRecAudioRegion_IDLE_default();
	react();
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_tr1()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio();
	enseq_VoiceRecAudioRegion_IDLE_default();
	react();
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr0()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DeallocateRoute();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr2()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopEcnrAndDestroy();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr5()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrAndDeallocateRoute();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr6()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_default();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr7()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrOnly();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr9()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_AutoSAOff();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr10()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_default();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr11()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_StopEcnrAndPause();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr12()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_default();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_tr4()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_default();
	VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr2()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
	ifaceVoiceRecAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_Ready2Stream();
	VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr3()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming_default();
	VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_tr1()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming();
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDeallocated();
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr1()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecStartStreaming();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr2()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrAndDeallocateRoute();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr4()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrOnly();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr6()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_default();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr0()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_default();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr1()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecStartStreaming();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr4()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DeallocateRoute();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr5()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrAndDeallocateRoute();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr6()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_AutoSAOff();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr7()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrOnly();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr8()
{
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_StreamingOngoing();
	VoiceRecAudioRegion_VoiceRecAudio_react(false);
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr0()
{
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse_default();
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr1()
{
	ifaceVoiceRecAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_value);
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure_default();
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr0()
{
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecStartStreaming();
}

void VoiceRecAudioSm::effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr1()
{
	ifaceVoiceRecAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_value);
	ifaceEcnrRequest_OCB->sendEcnrSetConfiguration(ifaceVoiceRecAudioSmHandler.samplingType);
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure_default();
}

/* Entry action for state 'PreparingVoiceRecAudio'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio()
{
	/* Entry action for state 'PreparingVoiceRecAudio'. */
	ifaceVoiceRecAudioSmHandler_OCB->updateStatus(PREPARING, (sc_string) "Preparing");
}

/* Entry action for state 'ReadyToStream'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream()
{
	/* Entry action for state 'ReadyToStream'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
}

/* Entry action for state 'WaitForVoiceRecRouteAllocation'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation()
{
	/* Entry action for state 'WaitForVoiceRecRouteAllocation'. */
	ifaceAudioWrapperReqIf_OCB->sendAllocateRequest();
}

/* Entry action for state 'VoiceRecSAOnReceived'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived()
{
	/* Entry action for state 'VoiceRecSAOnReceived'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_READY_TO_PLAY(InternalSCI_READY_TO_PLAY));
}

/* Entry action for state 'WaitForSAOn'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn()
{
	/* Entry action for state 'WaitForSAOn'. */
	ifaceVoiceRecAudioSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "Voice Rec audio channel Granted");
}

/* Entry action for state 'WaitForEcnrInit'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit()
{
	/* Entry action for state 'WaitForEcnrInit'. */
	ifaceEcnrRequest_OCB->sendEcnrInit(ifaceVoiceRecAudioSmHandler.samplingType);
}

/* Entry action for state 'WaitForEcnrStart'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart()
{
	/* Entry action for state 'WaitForEcnrStart'. */
	ifaceEcnrRequest_OCB->sendEcnrStart();
}

/* Entry action for state 'Streaming'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming()
{
	/* Entry action for state 'Streaming'. */
	ifaceVoiceRecAudioSmHandler_OCB->updateStatus(STREAMING, (sc_string) "Audio streaming");
}

/* Entry action for state 'ConfigureAndStream'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream()
{
	/* Entry action for state 'ConfigureAndStream'. */
	ifaceVoiceRecAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
}

/* Entry action for state 'WaitForEcnrStop'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop()
{
	/* Entry action for state 'WaitForEcnrStop'. */
	ifaceEcnrRequest_OCB->sendEcnrStop();
}

/* Entry action for state 'WaitForEcnrDestroy'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy()
{
	/* Entry action for state 'WaitForEcnrDestroy'. */
	ifaceEcnrRequest_OCB->sendEcnrDestroy();
}

/* Entry action for state 'EcnrDestroyed'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed()
{
	/* Entry action for state 'EcnrDestroyed'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForVoiceRecRouteDeallocation'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation()
{
	/* Entry action for state 'WaitForVoiceRecRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'VoiceRecSAOff'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff()
{
	/* Entry action for state 'VoiceRecSAOff'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'StreamingStopped'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped()
{
	/* Entry action for state 'StreamingStopped'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
}

/* Entry action for state 'WaitForRouteDeallocation'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation()
{
	/* Entry action for state 'WaitForRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'WaitForEcnrDestroy'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy()
{
	/* Entry action for state 'WaitForEcnrDestroy'. */
	ifaceEcnrRequest_OCB->sendEcnrDestroy();
}

/* Entry action for state 'EcnrDestroyed'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed()
{
	/* Entry action for state 'EcnrDestroyed'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForVoiceRecRouteDeallocation'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation()
{
	/* Entry action for state 'WaitForVoiceRecRouteDeallocation'. */
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
}

/* Entry action for state 'VoiceRecSAOff'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff()
{
	/* Entry action for state 'VoiceRecSAOff'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT(InternalSCI_SEND_SRC_ACTIVITY_OFF_RESULT));
}

/* Entry action for state 'WaitForEcnrDestroy'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy()
{
	/* Entry action for state 'WaitForEcnrDestroy'. */
	ifaceEcnrRequest_OCB->sendEcnrDestroy();
}

/* Entry action for state 'WaitForEcnrStop'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop()
{
	/* Entry action for state 'WaitForEcnrStop'. */
	ifaceEcnrRequest_OCB->sendEcnrStop();
}

/* Entry action for state 'AutoSourceSwitch'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch()
{
	/* Entry action for state 'AutoSourceSwitch'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
	ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
	ifaceVoiceRecAudioSmHandler_OCB->updateStatus(DEALLOCATING, (sc_string) "Source Switch");
}

/* Entry action for state 'WaitForEcnrStop'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop()
{
	/* Entry action for state 'WaitForEcnrStop'. */
	ifaceEcnrRequest_OCB->sendEcnrStop();
}

/* Entry action for state 'VoiceRecAudioPaused'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused()
{
	/* Entry action for state 'VoiceRecAudioPaused'. */
	ifaceVoiceRecAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
}

/* Entry action for state 'WaitForEcnrDestroy'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy()
{
	/* Entry action for state 'WaitForEcnrDestroy'. */
	ifaceEcnrRequest_OCB->sendEcnrDestroy();
}

/* Entry action for state 'ChannelAutoPaused'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused()
{
	/* Entry action for state 'ChannelAutoPaused'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_PAUSE);
}

/* Entry action for state 'WaitForEcnrStop'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop()
{
	/* Entry action for state 'WaitForEcnrStop'. */
	ifaceEcnrRequest_OCB->sendEcnrStop();
}

/* Entry action for state 'StartToStream'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream()
{
	/* Entry action for state 'StartToStream'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
}

/* Entry action for state 'ConfigureAndStream'. */
void VoiceRecAudioSm::enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream()
{
	/* Entry action for state 'ConfigureAndStream'. */
	ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
}

/* 'default' enter sequence for state IDLE */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_IDLE_default()
{
	/* 'default' enter sequence for state IDLE */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_IDLE);
	}
	stateConfVector[0] = VoiceRecAudioRegion_IDLE;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state VoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_default()
{
	/* 'default' enter sequence for state VoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_default();
}

/* 'default' enter sequence for state WaitForPlayRequest */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest_default()
{
	/* 'default' enter sequence for state WaitForPlayRequest */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ReadyToStream */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream_default()
{
	/* 'default' enter sequence for state ReadyToStream */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForVoiceRecRouteAllocation */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation_default()
{
	/* 'default' enter sequence for state WaitForVoiceRecRouteAllocation */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation);
	}
	stateConfVector[1] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state VoiceRecSAOnReceived */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived_default()
{
	/* 'default' enter sequence for state VoiceRecSAOnReceived */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived);
	}
	stateConfVector[1] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForSAOn */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn_default()
{
	/* 'default' enter sequence for state WaitForSAOn */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn);
	}
	stateConfVector[1] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn;
	stateConfVectorPosition = 1;
}

/* 'StreamingOngoing' enter sequence for state StreamingVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_StreamingOngoing()
{
	/* 'StreamingOngoing' enter sequence for state StreamingVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StreamingOngoing();
}

/* 'VoiceRecStartStreaming' enter sequence for state StreamingVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecStartStreaming()
{
	/* 'VoiceRecStartStreaming' enter sequence for state StreamingVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_VoiceRecStartStreaming();
}

/* 'default' enter sequence for state StreamingVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_default()
{
	/* 'default' enter sequence for state StreamingVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_default();
}

/* 'entry_DeallocateRoute8' enter sequence for state StreamingVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DeallocateRoute8()
{
	/* 'entry_DeallocateRoute8' enter sequence for state StreamingVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DeallocateRoute8();
}

/* 'entry_DefaultStop1' enter sequence for state StreamingVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DefaultStop1()
{
	/* 'entry_DefaultStop1' enter sequence for state StreamingVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DefaultStop1();
}

/* 'entry_DestroyEcnrAndDeallocateRoute4' enter sequence for state StreamingVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DestroyEcnrAndDeallocateRoute4()
{
	/* 'entry_DestroyEcnrAndDeallocateRoute4' enter sequence for state StreamingVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4();
}

/* 'entry_StopEcnrAndDestroy3' enter sequence for state StreamingVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_StopEcnrAndDestroy3()
{
	/* 'entry_StopEcnrAndDestroy3' enter sequence for state StreamingVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_StopEcnrAndDestroy3();
}

/* 'default' enter sequence for state WaitForEcnrInit */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit_default()
{
	/* 'default' enter sequence for state WaitForEcnrInit */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrStart */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_default()
{
	/* 'default' enter sequence for state WaitForEcnrStart */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrInit */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit_default()
{
	/* 'default' enter sequence for state StopAfterEcnrInit */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrStart */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart_default()
{
	/* 'default' enter sequence for state StopAfterEcnrStart */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAtEcnrStart */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart_default()
{
	/* 'default' enter sequence for state AutoSAOffAtEcnrStart */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAtEcnrInit */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit_default()
{
	/* 'default' enter sequence for state AutoSAOffAtEcnrInit */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Streaming */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming_default()
{
	/* 'default' enter sequence for state Streaming */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming;
	stateConfVectorPosition = 0;
}

/* 'AutoSAPause' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_AutoSAPause()
{
	/* 'AutoSAPause' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause();
}

/* 'Ready2Stream' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_Ready2Stream()
{
	/* 'Ready2Stream' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream();
}

/* 'default' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_default()
{
	/* 'default' enter sequence for state PauseAudioRequestBeforeEcnrConfigured */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_default();
}

/* 'default' enter sequence for state ChannelPaused */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default()
{
	/* 'default' enter sequence for state ChannelPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_default()
{
	/* 'default' enter sequence for state WaitForEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ReadyToStream */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_default()
{
	/* 'default' enter sequence for state ReadyToStream */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ConfigureAndStream */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_default()
{
	/* 'default' enter sequence for state ConfigureAndStream */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ChannelActivated */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_default()
{
	/* 'default' enter sequence for state ChannelActivated */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state PlayAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'AutoSAPause' enter sequence for state PauseAudioRequestBeforeEcnrStarted */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_AutoSAPause()
{
	/* 'AutoSAPause' enter sequence for state PauseAudioRequestBeforeEcnrStarted */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause();
}

/* 'default' enter sequence for state PauseAudioRequestBeforeEcnrStarted */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_default()
{
	/* 'default' enter sequence for state PauseAudioRequestBeforeEcnrStarted */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_default();
}

/* 'default' enter sequence for state ChannelPaused */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_default()
{
	/* 'default' enter sequence for state ChannelPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_default()
{
	/* 'default' enter sequence for state WaitForEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ChannelActivated */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_default()
{
	/* 'default' enter sequence for state ChannelActivated */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state PlayAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'AutoSAOff' enter sequence for state StopVoiceRecAudioStreaming */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_AutoSAOff()
{
	/* 'AutoSAOff' enter sequence for state StopVoiceRecAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSAOff();
}

/* 'DeallocateRoute' enter sequence for state StopVoiceRecAudioStreaming */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DeallocateRoute()
{
	/* 'DeallocateRoute' enter sequence for state StopVoiceRecAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DeallocateRoute();
}

/* 'DestroyEcnrAndDeallocateRoute' enter sequence for state StopVoiceRecAudioStreaming */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrAndDeallocateRoute()
{
	/* 'DestroyEcnrAndDeallocateRoute' enter sequence for state StopVoiceRecAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
}

/* 'DestroyEcnrOnly' enter sequence for state StopVoiceRecAudioStreaming */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DestroyEcnrOnly()
{
	/* 'DestroyEcnrOnly' enter sequence for state StopVoiceRecAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrOnly();
}

/* 'StopEcnrAndDestroy' enter sequence for state StopVoiceRecAudioStreaming */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopEcnrAndDestroy()
{
	/* 'StopEcnrAndDestroy' enter sequence for state StopVoiceRecAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopEcnrAndDestroy();
}

/* 'default' enter sequence for state StopVoiceRecAudioStreaming */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_default()
{
	/* 'default' enter sequence for state StopVoiceRecAudioStreaming */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_default();
}

/* 'default' enter sequence for state WaitForEcnrStop */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_default()
{
	/* 'default' enter sequence for state WaitForEcnrStop */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrDestroy */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default()
{
	/* 'default' enter sequence for state WaitForEcnrDestroy */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state EcnrDestroyed */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default()
{
	/* 'default' enter sequence for state EcnrDestroyed */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForVoiceRecRouteDeallocation */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForVoiceRecRouteDeallocation */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation);
	}
	stateConfVector[1] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state VoiceRecSAOff */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff_default()
{
	/* 'default' enter sequence for state VoiceRecSAOff */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff);
	}
	stateConfVector[1] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state StreamingStopped */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped_default()
{
	/* 'default' enter sequence for state StreamingStopped */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForRouteDeallocation */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForRouteDeallocation */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrDestroy */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default()
{
	/* 'default' enter sequence for state WaitForEcnrDestroy */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state EcnrDestroyed */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default()
{
	/* 'default' enter sequence for state EcnrDestroyed */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForVoiceRecRouteDeallocation */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_default()
{
	/* 'default' enter sequence for state WaitForVoiceRecRouteDeallocation */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation);
	}
	stateConfVector[1] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state VoiceRecSAOff */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff_default()
{
	/* 'default' enter sequence for state VoiceRecSAOff */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff);
	}
	stateConfVector[1] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff;
	stateConfVectorPosition = 1;
}

/* 'default' enter sequence for state WaitForEcnrDestroy */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy_default()
{
	/* 'default' enter sequence for state WaitForEcnrDestroy */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrStop */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop_default()
{
	/* 'default' enter sequence for state WaitForEcnrStop */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSourceSwitch */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch_default()
{
	/* 'default' enter sequence for state AutoSourceSwitch */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_default()
{
	/* 'default' enter sequence for state PauseVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_default();
}

/* 'entry_AutoSAOffAfterEcnrResponse3' enter sequence for state PauseVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAOffAfterEcnrResponse3()
{
	/* 'entry_AutoSAOffAfterEcnrResponse3' enter sequence for state PauseVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOffAfterEcnrResponse3();
}

/* 'entry_AutoSAOnAfterEcnrResponse9' enter sequence for state PauseVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAOnAfterEcnrResponse9()
{
	/* 'entry_AutoSAOnAfterEcnrResponse9' enter sequence for state PauseVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOnAfterEcnrResponse9();
}

/* 'entry_AutoSAPauseAfterEcnrResponse5' enter sequence for state PauseVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAPauseAfterEcnrResponse5()
{
	/* 'entry_AutoSAPauseAfterEcnrResponse5' enter sequence for state PauseVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAPauseAfterEcnrResponse5();
}

/* 'entry_StopAfterEcnrResponse0' enter sequence for state PauseVoiceRecAudio */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_StopAfterEcnrResponse0()
{
	/* 'entry_StopAfterEcnrResponse0' enter sequence for state PauseVoiceRecAudio */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_StopAfterEcnrResponse0();
}

/* 'default' enter sequence for state WaitForEcnrStop */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop_default()
{
	/* 'default' enter sequence for state WaitForEcnrStop */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state VoiceRecAudioPaused */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused_default()
{
	/* 'default' enter sequence for state VoiceRecAudioPaused */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state PlayAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrConfigure */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure_default()
{
	/* 'default' enter sequence for state WaitForEcnrConfigure */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state PauseAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state StopAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAPauseAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAPauseAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOnAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAOnAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'StopEcnrAndPause' enter sequence for state AutoPaused */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_StopEcnrAndPause()
{
	/* 'StopEcnrAndPause' enter sequence for state AutoPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause();
}

/* 'default' enter sequence for state AutoPaused */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_default()
{
	/* 'default' enter sequence for state AutoPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_default();
}

/* 'entry_AutoSAOffAfterEcnrResponse2' enter sequence for state AutoPaused */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_entry_AutoSAOffAfterEcnrResponse2()
{
	/* 'entry_AutoSAOffAfterEcnrResponse2' enter sequence for state AutoPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2();
}

/* 'entry_StopAfterEcnrResponse3' enter sequence for state AutoPaused */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_entry_StopAfterEcnrResponse3()
{
	/* 'entry_StopAfterEcnrResponse3' enter sequence for state AutoPaused */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3();
}

/* 'default' enter sequence for state WaitForEcnrDestroy */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default()
{
	/* 'default' enter sequence for state WaitForEcnrDestroy */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ChannelAutoPaused */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_default()
{
	/* 'default' enter sequence for state ChannelAutoPaused */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForEcnrStop */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_default()
{
	/* 'default' enter sequence for state WaitForEcnrStop */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StartToStream */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_default()
{
	/* 'default' enter sequence for state StartToStream */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ConfigureAndStream */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_default()
{
	/* 'default' enter sequence for state ConfigureAndStream */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrResponse */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_default()
{
	/* 'default' enter sequence for state StopAfterEcnrResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StopAfterEcnrStop */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_default()
{
	/* 'default' enter sequence for state StopAfterEcnrStop */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AutoSAOffAfterEcnrStop */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_default()
{
	/* 'default' enter sequence for state AutoSAOffAfterEcnrStop */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterEcnrDestroy */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_default()
{
	/* 'default' enter sequence for state PauseAfterEcnrDestroy */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PauseAfterEcnrStop */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_default()
{
	/* 'default' enter sequence for state PauseAfterEcnrStop */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop);
	}
	stateConfVector[0] = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region VoiceRecAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_default()
{
	/* 'default' enter sequence for region VoiceRecAudioRegion */
	react_VoiceRecAudioRegion__entry_Default();
}

/* 'default' enter sequence for region VoiceRecAudioStartRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_default()
{
	/* 'default' enter sequence for region VoiceRecAudioStartRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__entry_Default();
}

/* 'default' enter sequence for region VoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_default()
{
	/* 'default' enter sequence for region VoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion__entry_Default();
}

/* 'VoiceRecStartStreaming' enter sequence for region VoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_VoiceRecStartStreaming()
{
	/* 'VoiceRecStartStreaming' enter sequence for region VoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_VoiceRecStartStreaming();
}

/* 'StreamingOngoing' enter sequence for region VoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StreamingOngoing()
{
	/* 'StreamingOngoing' enter sequence for region VoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StreamingOngoing();
}

/* 'entry_StopEcnrAndDestroy3' enter sequence for region VoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_StopEcnrAndDestroy3()
{
	/* 'entry_StopEcnrAndDestroy3' enter sequence for region VoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_StopEcnrAndDestroy3();
}

/* 'entry_DestroyEcnrAndDeallocateRoute4' enter sequence for region VoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4()
{
	/* 'entry_DestroyEcnrAndDeallocateRoute4' enter sequence for region VoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4();
}

/* 'entry_DefaultStop1' enter sequence for region VoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DefaultStop1()
{
	/* 'entry_DefaultStop1' enter sequence for region VoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DefaultStop1();
}

/* 'entry_DeallocateRoute8' enter sequence for region VoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DeallocateRoute8()
{
	/* 'entry_DeallocateRoute8' enter sequence for region VoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DeallocateRoute8();
}

/* 'AutoSAPause' enter sequence for region PauseAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause()
{
	/* 'AutoSAPause' enter sequence for region PauseAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause();
}

/* 'default' enter sequence for region PauseAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_default()
{
	/* 'default' enter sequence for region PauseAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion__entry_Default();
}

/* 'Ready2Stream' enter sequence for region PauseAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream()
{
	/* 'Ready2Stream' enter sequence for region PauseAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream();
}

/* 'AutoSAPause' enter sequence for region PauseAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause()
{
	/* 'AutoSAPause' enter sequence for region PauseAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause();
}

/* 'default' enter sequence for region PauseAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_default()
{
	/* 'default' enter sequence for region PauseAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion__entry_Default();
}

/* 'default' enter sequence for region StopVoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_default()
{
	/* 'default' enter sequence for region StopVoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__entry_Default();
}

/* 'DeallocateRoute' enter sequence for region StopVoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DeallocateRoute()
{
	/* 'DeallocateRoute' enter sequence for region StopVoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DeallocateRoute();
}

/* 'DestroyEcnrAndDeallocateRoute' enter sequence for region StopVoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute()
{
	/* 'DestroyEcnrAndDeallocateRoute' enter sequence for region StopVoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
}

/* 'DestroyEcnrOnly' enter sequence for region StopVoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrOnly()
{
	/* 'DestroyEcnrOnly' enter sequence for region StopVoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrOnly();
}

/* 'StopEcnrAndDestroy' enter sequence for region StopVoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopEcnrAndDestroy()
{
	/* 'StopEcnrAndDestroy' enter sequence for region StopVoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopEcnrAndDestroy();
}

/* 'AutoSAOff' enter sequence for region StopVoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSAOff()
{
	/* 'AutoSAOff' enter sequence for region StopVoiceRecAudioStreamingRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSAOff();
}

/* 'default' enter sequence for region PauseVoiceRecAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_default()
{
	/* 'default' enter sequence for region PauseVoiceRecAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__entry_Default();
}

/* 'entry_StopAfterEcnrResponse0' enter sequence for region PauseVoiceRecAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_StopAfterEcnrResponse0()
{
	/* 'entry_StopAfterEcnrResponse0' enter sequence for region PauseVoiceRecAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_StopAfterEcnrResponse0();
}

/* 'entry_AutoSAOffAfterEcnrResponse3' enter sequence for region PauseVoiceRecAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOffAfterEcnrResponse3()
{
	/* 'entry_AutoSAOffAfterEcnrResponse3' enter sequence for region PauseVoiceRecAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOffAfterEcnrResponse3();
}

/* 'entry_AutoSAPauseAfterEcnrResponse5' enter sequence for region PauseVoiceRecAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAPauseAfterEcnrResponse5()
{
	/* 'entry_AutoSAPauseAfterEcnrResponse5' enter sequence for region PauseVoiceRecAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAPauseAfterEcnrResponse5();
}

/* 'entry_AutoSAOnAfterEcnrResponse9' enter sequence for region PauseVoiceRecAudioRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOnAfterEcnrResponse9()
{
	/* 'entry_AutoSAOnAfterEcnrResponse9' enter sequence for region PauseVoiceRecAudioRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOnAfterEcnrResponse9();
}

/* 'default' enter sequence for region AutoPauseRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_default()
{
	/* 'default' enter sequence for region AutoPauseRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion__entry_Default();
}

/* 'StopEcnrAndPause' enter sequence for region AutoPauseRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause()
{
	/* 'StopEcnrAndPause' enter sequence for region AutoPauseRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause();
}

/* 'entry_AutoSAOffAfterEcnrResponse2' enter sequence for region AutoPauseRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2()
{
	/* 'entry_AutoSAOffAfterEcnrResponse2' enter sequence for region AutoPauseRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2();
}

/* 'entry_StopAfterEcnrResponse3' enter sequence for region AutoPauseRegion */
void VoiceRecAudioSm::enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3()
{
	/* 'entry_StopAfterEcnrResponse3' enter sequence for region AutoPauseRegion */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3();
}

/* Default exit sequence for state IDLE */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_IDLE()
{
	/* Default exit sequence for state IDLE */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state VoiceRecAudio */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio()
{
	/* Default exit sequence for state VoiceRecAudio */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion();
}

/* Default exit sequence for state PreparingVoiceRecAudio */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio()
{
	/* Default exit sequence for state PreparingVoiceRecAudio */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion();
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion();
}

/* Default exit sequence for state WaitForPlayRequest */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest()
{
	/* Default exit sequence for state WaitForPlayRequest */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ReadyToStream */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream()
{
	/* Default exit sequence for state ReadyToStream */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForVoiceRecRouteAllocation */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation()
{
	/* Default exit sequence for state WaitForVoiceRecRouteAllocation */
	stateConfVector[1] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state VoiceRecSAOnReceived */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived()
{
	/* Default exit sequence for state VoiceRecSAOnReceived */
	stateConfVector[1] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForSAOn */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn()
{
	/* Default exit sequence for state WaitForSAOn */
	stateConfVector[1] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state StreamingVoiceRecAudio */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio()
{
	/* Default exit sequence for state StreamingVoiceRecAudio */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion();
}

/* Default exit sequence for state WaitForEcnrInit */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit()
{
	/* Default exit sequence for state WaitForEcnrInit */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrStart */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart()
{
	/* Default exit sequence for state WaitForEcnrStart */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrInit */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit()
{
	/* Default exit sequence for state StopAfterEcnrInit */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrStart */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart()
{
	/* Default exit sequence for state StopAfterEcnrStart */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAtEcnrStart */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart()
{
	/* Default exit sequence for state AutoSAOffAtEcnrStart */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAtEcnrInit */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit()
{
	/* Default exit sequence for state AutoSAOffAtEcnrInit */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Streaming */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming()
{
	/* Default exit sequence for state Streaming */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAudioRequestBeforeEcnrConfigured */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured()
{
	/* Default exit sequence for state PauseAudioRequestBeforeEcnrConfigured */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion();
}

/* Default exit sequence for state ChannelPaused */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused()
{
	/* Default exit sequence for state ChannelPaused */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse()
{
	/* Default exit sequence for state WaitForEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ReadyToStream */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream()
{
	/* Default exit sequence for state ReadyToStream */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ConfigureAndStream */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream()
{
	/* Default exit sequence for state ConfigureAndStream */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ChannelActivated */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated()
{
	/* Default exit sequence for state ChannelActivated */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse()
{
	/* Default exit sequence for state PlayAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAudioRequestBeforeEcnrStarted */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted()
{
	/* Default exit sequence for state PauseAudioRequestBeforeEcnrStarted */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion();
}

/* Default exit sequence for state ChannelPaused */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused()
{
	/* Default exit sequence for state ChannelPaused */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse()
{
	/* Default exit sequence for state WaitForEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ChannelActivated */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated()
{
	/* Default exit sequence for state ChannelActivated */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse()
{
	/* Default exit sequence for state PlayAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopVoiceRecAudioStreaming */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming()
{
	/* Default exit sequence for state StopVoiceRecAudioStreaming */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion();
}

/* Default exit sequence for state StopStreamingAndDeallocateChannel */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel()
{
	/* Default exit sequence for state StopStreamingAndDeallocateChannel */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation();
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation();
}

/* Default exit sequence for state WaitForEcnrStop */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop()
{
	/* Default exit sequence for state WaitForEcnrStop */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrDestroy */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy()
{
	/* Default exit sequence for state WaitForEcnrDestroy */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state EcnrDestroyed */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed()
{
	/* Default exit sequence for state EcnrDestroyed */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForVoiceRecRouteDeallocation */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation()
{
	/* Default exit sequence for state WaitForVoiceRecRouteDeallocation */
	stateConfVector[1] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state VoiceRecSAOff */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff()
{
	/* Default exit sequence for state VoiceRecSAOff */
	stateConfVector[1] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state StreamingStopped */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped()
{
	/* Default exit sequence for state StreamingStopped */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForRouteDeallocation */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation()
{
	/* Default exit sequence for state WaitForRouteDeallocation */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state DestroyEcnrAndDeallocateChannel */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel()
{
	/* Default exit sequence for state DestroyEcnrAndDeallocateChannel */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation();
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation();
}

/* Default exit sequence for state WaitForEcnrDestroy */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy()
{
	/* Default exit sequence for state WaitForEcnrDestroy */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state EcnrDestroyed */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed()
{
	/* Default exit sequence for state EcnrDestroyed */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForVoiceRecRouteDeallocation */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation()
{
	/* Default exit sequence for state WaitForVoiceRecRouteDeallocation */
	stateConfVector[1] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state VoiceRecSAOff */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff()
{
	/* Default exit sequence for state VoiceRecSAOff */
	stateConfVector[1] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 1;
}

/* Default exit sequence for state WaitForEcnrDestroy */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy()
{
	/* Default exit sequence for state WaitForEcnrDestroy */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrStop */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop()
{
	/* Default exit sequence for state WaitForEcnrStop */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSourceSwitch */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch()
{
	/* Default exit sequence for state AutoSourceSwitch */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseVoiceRecAudio */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio()
{
	/* Default exit sequence for state PauseVoiceRecAudio */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion();
}

/* Default exit sequence for state WaitForEcnrStop */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop()
{
	/* Default exit sequence for state WaitForEcnrStop */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state VoiceRecAudioPaused */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused()
{
	/* Default exit sequence for state VoiceRecAudioPaused */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse()
{
	/* Default exit sequence for state PlayAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrConfigure */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure()
{
	/* Default exit sequence for state WaitForEcnrConfigure */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse()
{
	/* Default exit sequence for state PauseAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse()
{
	/* Default exit sequence for state StopAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAPauseAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAPauseAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOnAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAOnAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoPaused */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused()
{
	/* Default exit sequence for state AutoPaused */
	exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion();
}

/* Default exit sequence for state WaitForEcnrDestroy */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy()
{
	/* Default exit sequence for state WaitForEcnrDestroy */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ChannelAutoPaused */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused()
{
	/* Default exit sequence for state ChannelAutoPaused */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForEcnrStop */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop()
{
	/* Default exit sequence for state WaitForEcnrStop */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StartToStream */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream()
{
	/* Default exit sequence for state StartToStream */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ConfigureAndStream */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream()
{
	/* Default exit sequence for state ConfigureAndStream */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse()
{
	/* Default exit sequence for state AutoSAOffAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrResponse */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse()
{
	/* Default exit sequence for state StopAfterEcnrResponse */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StopAfterEcnrStop */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop()
{
	/* Default exit sequence for state StopAfterEcnrStop */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AutoSAOffAfterEcnrStop */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop()
{
	/* Default exit sequence for state AutoSAOffAfterEcnrStop */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterEcnrDestroy */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy()
{
	/* Default exit sequence for state PauseAfterEcnrDestroy */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PauseAfterEcnrStop */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop()
{
	/* Default exit sequence for state PauseAfterEcnrStop */
	stateConfVector[0] = VoiceRecAudioSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for region VoiceRecAudioRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion()
{
	/* Default exit sequence for region VoiceRecAudioRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_IDLE :
		{
			exseq_VoiceRecAudioRegion_IDLE();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region VoiceRecAudioStartRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion()
{
	/* Default exit sequence for region VoiceRecAudioStartRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AmClientRequestWaitRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion()
{
	/* Default exit sequence for region AmClientRequestWaitRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.PreparingVoiceRecAudio.AmClientRequestWaitRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ArlResponseWaitRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion()
{
	/* Default exit sequence for region ArlResponseWaitRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.PreparingVoiceRecAudio.ArlResponseWaitRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region VoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion()
{
	/* Default exit sequence for region VoiceRecAudioStreamingRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StreamingVoiceRecAudio.VoiceRecAudioStreamingRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region PauseAudioRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion()
{
	/* Default exit sequence for region PauseAudioRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StreamingVoiceRecAudio.VoiceRecAudioStreamingRegion.PauseAudioRequestBeforeEcnrConfigured.PauseAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region PauseAudioRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion()
{
	/* Default exit sequence for region PauseAudioRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StreamingVoiceRecAudio.VoiceRecAudioStreamingRegion.PauseAudioRequestBeforeEcnrStarted.PauseAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region StopVoiceRecAudioStreamingRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion()
{
	/* Default exit sequence for region StopVoiceRecAudioStreamingRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StopVoiceRecAudioStreaming.StopVoiceRecAudioStreamingRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch();
			break;
		}
		default: break;
	}
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StopVoiceRecAudioStreaming.StopVoiceRecAudioStreamingRegion) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region EcnrOperation */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation()
{
	/* Default exit sequence for region EcnrOperation */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StopVoiceRecAudioStreaming.StopVoiceRecAudioStreamingRegion.StopStreamingAndDeallocateChannel.EcnrOperation) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ArlOperation */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation()
{
	/* Default exit sequence for region ArlOperation */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StopVoiceRecAudioStreaming.StopVoiceRecAudioStreamingRegion.StopStreamingAndDeallocateChannel.ArlOperation) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region EcnrOperation */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation()
{
	/* Default exit sequence for region EcnrOperation */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StopVoiceRecAudioStreaming.StopVoiceRecAudioStreamingRegion.DestroyEcnrAndDeallocateChannel.EcnrOperation) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region ArlOperation */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation()
{
	/* Default exit sequence for region ArlOperation */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.StopVoiceRecAudioStreaming.StopVoiceRecAudioStreamingRegion.DestroyEcnrAndDeallocateChannel.ArlOperation) at position 1... */
	switch(stateConfVector[ 1 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region PauseVoiceRecAudioRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion()
{
	/* Default exit sequence for region PauseVoiceRecAudioRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.PauseVoiceRecAudio.PauseVoiceRecAudioRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region AutoPauseRegion */
void VoiceRecAudioSm::exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion()
{
	/* Default exit sequence for region AutoPauseRegion */
	/* Handle exit of all possible states (of VoiceRecAudioSm.VoiceRecAudioRegion.VoiceRecAudio.VoiceRecAudioStartRegion.AutoPaused.AutoPauseRegion) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
			break;
		}
		case VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop :
		{
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
			break;
		}
		default: break;
	}
}

/* The reactions of state null. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0()
{
	/* The reactions of state null. */
	if (check_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr0_tr0())
	{ 
		effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr0();
	}  else
	{
		effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0_tr1();
	}
}

/* The reactions of state null. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1()
{
	/* The reactions of state null. */
	if (check_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr0_tr0())
	{ 
		effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr0();
	}  else
	{
		effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1_tr1();
	}
}

/* Default react sequence for initial entry  */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__sync0();
}

/* Default react sequence for initial entry  */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit_default();
}

/* Default react sequence for initial entry VoiceRecStartStreaming */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_VoiceRecStartStreaming()
{
	/* Default react sequence for initial entry VoiceRecStartStreaming */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_default();
}

/* Default react sequence for initial entry AutoSAPause */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_AutoSAPause()
{
	/* Default react sequence for initial entry AutoSAPause */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
}

/* Default react sequence for initial entry  */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_default();
}

/* Default react sequence for initial entry Ready2Stream */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_Ready2Stream()
{
	/* Default react sequence for initial entry Ready2Stream */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_default();
}

/* Default react sequence for initial entry AutoSAPause */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_AutoSAPause()
{
	/* Default react sequence for initial entry AutoSAPause */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_default();
}

/* Default react sequence for initial entry  */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_default();
}

/* Default react sequence for initial entry StreamingOngoing */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StreamingOngoing()
{
	/* Default react sequence for initial entry StreamingOngoing */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming_default();
}

/* Default react sequence for initial entry entry_StopEcnrAndDestroy3 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_StopEcnrAndDestroy3()
{
	/* Default react sequence for initial entry entry_StopEcnrAndDestroy3 */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopEcnrAndDestroy();
}

/* Default react sequence for initial entry entry_DestroyEcnrAndDeallocateRoute4 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DestroyEcnrAndDeallocateRoute4()
{
	/* Default react sequence for initial entry entry_DestroyEcnrAndDeallocateRoute4 */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
}

/* Default react sequence for initial entry entry_DefaultStop1 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DefaultStop1()
{
	/* Default react sequence for initial entry entry_DefaultStop1 */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DefaultStop();
}

/* Default react sequence for initial entry entry_DeallocateRoute8 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_entry_DeallocateRoute8()
{
	/* Default react sequence for initial entry entry_DeallocateRoute8 */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DeallocateRoute();
}

/* Default react sequence for initial entry  */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync0();
}

/* Default react sequence for initial entry DeallocateRoute */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DeallocateRoute()
{
	/* Default react sequence for initial entry DeallocateRoute */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation_default();
}

/* Default react sequence for initial entry DestroyEcnrAndDeallocateRoute */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute()
{
	/* Default react sequence for initial entry DestroyEcnrAndDeallocateRoute */
	react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync3();
}

/* Default react sequence for initial entry DestroyEcnrOnly */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrOnly()
{
	/* Default react sequence for initial entry DestroyEcnrOnly */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy_default();
}

/* Default react sequence for initial entry StopEcnrAndDestroy */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopEcnrAndDestroy()
{
	/* Default react sequence for initial entry StopEcnrAndDestroy */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop_default();
}

/* Default react sequence for initial entry AutoSAOff */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSAOff()
{
	/* Default react sequence for initial entry AutoSAOff */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch_default();
}

/* Default react sequence for initial entry  */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop_default();
}

/* Default react sequence for initial entry entry_StopAfterEcnrResponse0 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_StopAfterEcnrResponse0()
{
	/* Default react sequence for initial entry entry_StopAfterEcnrResponse0 */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse3 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOffAfterEcnrResponse3()
{
	/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse3 */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAPauseAfterEcnrResponse5 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAPauseAfterEcnrResponse5()
{
	/* Default react sequence for initial entry entry_AutoSAPauseAfterEcnrResponse5 */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_AutoSAOnAfterEcnrResponse9 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_entry_AutoSAOnAfterEcnrResponse9()
{
	/* Default react sequence for initial entry entry_AutoSAOnAfterEcnrResponse9 */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse_default();
}

/* Default react sequence for initial entry  */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default();
}

/* Default react sequence for initial entry StopEcnrAndPause */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopEcnrAndPause()
{
	/* Default react sequence for initial entry StopEcnrAndPause */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_default();
}

/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse2 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_AutoSAOffAfterEcnrResponse2()
{
	/* Default react sequence for initial entry entry_AutoSAOffAfterEcnrResponse2 */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_default();
}

/* Default react sequence for initial entry entry_StopAfterEcnrResponse3 */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_entry_StopAfterEcnrResponse3()
{
	/* Default react sequence for initial entry entry_StopAfterEcnrResponse3 */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_default();
}

/* Default react sequence for initial entry  */
void VoiceRecAudioSm::react_VoiceRecAudioRegion__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_VoiceRecAudioRegion_IDLE_default();
}

/* The reactions of exit StopEcnrAndDestroy. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopEcnrAndDestroy()
{
	/* The reactions of exit StopEcnrAndDestroy. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr2();
}

/* The reactions of exit DestroyEcnrAndDeallocateRoute. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute()
{
	/* The reactions of exit DestroyEcnrAndDeallocateRoute. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr5();
}

/* The reactions of exit DefaultStop. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DefaultStop()
{
	/* The reactions of exit DefaultStop. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr6();
}

/* The reactions of exit StreamAudio. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio()
{
	/* The reactions of exit StreamAudio. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_tr4();
}

/* The reactions of exit DestroyEcnr. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnr()
{
	/* The reactions of exit DestroyEcnr. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr7();
}

/* The reactions of exit AutoSAOff. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOff()
{
	/* The reactions of exit AutoSAOff. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr9();
}

/* The reactions of exit DeallocateRoute. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DeallocateRoute()
{
	/* The reactions of exit DeallocateRoute. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr0();
}

/* The reactions of exit DestroyEcnrAndPause. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndPause()
{
	/* The reactions of exit DestroyEcnrAndPause. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr10();
}

/* The reactions of exit ReadyToStream. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ReadyToStream()
{
	/* The reactions of exit ReadyToStream. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr2();
}

/* The reactions of exit StreamingStarted. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_StreamingStarted()
{
	/* The reactions of exit StreamingStarted. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_tr3();
}

/* The reactions of exit StopEcnrAndPause. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopEcnrAndPause()
{
	/* The reactions of exit StopEcnrAndPause. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr11();
}

/* The reactions of exit PauseAudio. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudio()
{
	/* The reactions of exit PauseAudio. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_tr12();
}

/* The reactions of exit ExitOnchannelDeallocated. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_ExitOnchannelDeallocated()
{
	/* The reactions of exit ExitOnchannelDeallocated. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_tr1();
}

/* The reactions of exit ChannelDeallocated. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDeallocated()
{
	/* The reactions of exit ChannelDeallocated. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_tr0();
}

/* The reactions of exit VoiceRecStartStreaming. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecStartStreaming()
{
	/* The reactions of exit VoiceRecStartStreaming. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr1();
}

/* The reactions of exit DestroEcnrAndDeallocate. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_DestroEcnrAndDeallocate()
{
	/* The reactions of exit DestroEcnrAndDeallocate. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr2();
}

/* The reactions of exit DestroyEcnr. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_DestroyEcnr()
{
	/* The reactions of exit DestroyEcnr. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr4();
}

/* The reactions of exit AutoSAPause. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPause()
{
	/* The reactions of exit AutoSAPause. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_tr6();
}

/* The reactions of exit ChannelDenied. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDenied()
{
	/* The reactions of exit ChannelDenied. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_tr1();
}

/* The reactions of exit StartStreaming. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartStreaming()
{
	/* The reactions of exit StartStreaming. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr1();
}

/* The reactions of exit ConfigureEcnrAndStart. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureEcnrAndStart()
{
	/* The reactions of exit ConfigureEcnrAndStart. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr0();
}

/* The reactions of exit DeallocateRoute. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DeallocateRoute()
{
	/* The reactions of exit DeallocateRoute. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr4();
}

/* The reactions of exit AutoSAOff. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOff()
{
	/* The reactions of exit AutoSAOff. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr6();
}

/* The reactions of exit DestroyEcnrAndDeallocate. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrAndDeallocate()
{
	/* The reactions of exit DestroyEcnrAndDeallocate. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr5();
}

/* The reactions of exit DestroyEcnrOnly. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrOnly()
{
	/* The reactions of exit DestroyEcnrOnly. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr7();
}

/* The reactions of exit ECNR_STOP_FAILURE. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ECNR_STOP_FAILURE()
{
	/* The reactions of exit ECNR_STOP_FAILURE. */
	effect_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_tr8();
}

/* The reactions of state null. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__sync0()
{
	/* The reactions of state null. */
	enact_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest_default();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation_default();
}

/* The reactions of state null. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__sync1()
{
	/* The reactions of state null. */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_default();
}

/* The reactions of state null. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync0()
{
	/* The reactions of state null. */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_default();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_default();
}

/* The reactions of state null. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync1()
{
	/* The reactions of state null. */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped_default();
}

/* The reactions of state null. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync2()
{
	/* The reactions of state null. */
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped_default();
}

/* The reactions of state null. */
void VoiceRecAudioSm::react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync3()
{
	/* The reactions of state null. */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel);
	}
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default();
	enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_default();
}

sc_boolean VoiceRecAudioSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_IDLE_react(const sc_boolean try_transition) {
	/* The reactions of state IDLE. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICEREC_CHANNEL_raised)
		{ 
			exseq_VoiceRecAudioRegion_IDLE();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_default();
			react();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
		} 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_OFF);
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceRecAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_react(const sc_boolean try_transition) {
	/* The reactions of state PreparingVoiceRecAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_CHANNEL_DENIED_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Channel Denied");
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDenied();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_AutoSAOff();
				VoiceRecAudioRegion_VoiceRecAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPlayRequest. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_WaitForPlayRequest();
			ifaceVoiceRecAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_value);
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream_react(const sc_boolean try_transition) {
	/* The reactions of state ReadyToStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.READY_TO_PLAY_raised) && (isStateActive(VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived))) && (ifaceInternalSCI.READY_TO_PLAY_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForVoiceRecRouteAllocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
			ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDeallocated();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_CHANNEL_GRANTED_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForVoiceRecRouteAllocation();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceRecSAOnReceived. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.READY_TO_PLAY_raised) && (isStateActive(VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_AmClientRequestWaitRegion_ReadyToStream))) && (ifaceInternalSCI.READY_TO_PLAY_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion__sync1();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_DeallocateRoute();
				VoiceRecAudioRegion_VoiceRecAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSAOn. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_WaitForSAOn();
			ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_ArlResponseWaitRegion_VoiceRecSAOnReceived_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_CHANNEL_DEALLOCATED_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
				ifaceVoiceRecAudioSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDeallocated();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_AutoSAOff();
					VoiceRecAudioRegion_VoiceRecAudio_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
		{ 
			ifaceAudioWrapperReqIf_OCB->sendDeAllocateRequest();
		} 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PreparingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingVoiceRecAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DefaultStop1();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_StopEcnrAndDestroy3();
			}  else
			{
				if (ifaceEcnrResponse.ECNR_START_FAILURE_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DestroyEcnrAndDeallocateRoute4();
				}  else
				{
					if (ifaceEcnrResponse.ECNR_INIT_FAILURE_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio();
						enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_entry_DeallocateRoute8();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICEREC_CHANNEL_raised)
		{ 
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Channel Already Prepared");
		} 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrInit. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
				}  else
				{
					if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
						enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_default();
						VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
					}  else
					{
						if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
						{ 
							exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit();
							enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_AutoSAPause();
							VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStart. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
			}  else
			{
				if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
				}  else
				{
					if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
						enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_default();
						VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
					}  else
					{
						if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
						{ 
							exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart();
							enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_AutoSAPause();
							VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrInit. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrStart. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DefaultStop();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAtEcnrStart. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopEcnrAndDestroy();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_START_FAILURE_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnr();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAtEcnrInit. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnr();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_FAILURE_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOff();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming_react(const sc_boolean try_transition) {
	/* The reactions of state Streaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudio();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_Streaming();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopEcnrAndPause();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAudioRequestBeforeEcnrConfigured. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrInit_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
		}  else
		{
			if ((ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised) || (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised))
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrInit_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrInit_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
						react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndPause();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndPause();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_FAILURE_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
				ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_PAUSE);
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused();
					ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_FAILURE_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
					ifaceVoiceRecAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_value);
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse();
						enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
						VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream_react(const sc_boolean try_transition) {
	/* The reactions of state ReadyToStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnr();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateRoute();
			}  else
			{
				if (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ReadyToStream();
					ifaceVoiceRecAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_value);
					react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ConfigureAndStream_react(const sc_boolean try_transition) {
	/* The reactions of state ConfigureAndStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOff();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DeallocateRoute();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
		{ 
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
		} 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelActivated. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelActivated();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_WaitForEcnrResponse_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_INIT_SUCCESS_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_StreamAudio();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_PlayAfterEcnrResponse();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_PauseAudioRegion_ChannelPaused_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrConfigured_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAudioRequestBeforeEcnrStarted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_AutoSAOffAtEcnrStart_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopAfterEcnrStart_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
			}  else
			{
				if ((ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised) || (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised))
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_WaitForEcnrStart_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
						if(ifaceTraceObserver != sc_null) {
							ifaceTraceObserver->stateEntered(VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted);
						}
						enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_default();
						VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_StopEcnrAndPause();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_START_FAILURE_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_DestroyEcnrAndPause();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelPaused();
					ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudio();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_START_FAILURE_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ReadyToStream();
			}  else
			{
				if (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse();
					ifaceVoiceRecAudioSmHandler_OCB->updateSamplingType(ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_value);
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelActivated. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_ChannelActivated();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_StreamingStarted();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_WaitForEcnrResponse_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_START_SUCCESS_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_PlayAfterEcnrResponse();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_PauseAudioRegion_StreamingStarted();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecAudioStreamingRegion_PauseAudioRequestBeforeEcnrStarted_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state StopVoiceRecAudioStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_CHANNEL_DEALLOCATED_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming();
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Deallocated");
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_ChannelDeallocated();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICEREC_CHANNEL_raised)
		{ 
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Stop In Progress");
		} 
		if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
		{ 
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "PauseAudio-Stop In Progress");
		} 
		if (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised)
		{ 
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "PlayAudio-Stop In Progress");
		} 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(const sc_boolean try_transition) {
	/* The reactions of state StopStreamingAndDeallocateChannel. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrStop();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(const sc_boolean try_transition) {
	/* The reactions of state EcnrDestroyed. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForVoiceRecRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_ArlOperation_VoiceRecSAOff_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceRecSAOff. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_EcnrOperation_EcnrDestroyed))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync1();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StopStreamingAndDeallocateChannel_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingStopped. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForRouteDeallocation();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_StreamingStopped_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(const sc_boolean try_transition) {
	/* The reactions of state DestroyEcnrAndDeallocateChannel. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_WaitForEcnrDestroy();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_default();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed_react(const sc_boolean try_transition) {
	/* The reactions of state EcnrDestroyed. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync2();
		}  else
		{
			did_transition = false;
		}
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForVoiceRecRouteDeallocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_WaitForVoiceRecRouteDeallocation();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_ArlOperation_VoiceRecSAOff_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceRecSAOff. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised) && (isStateActive(VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_EcnrOperation_EcnrDestroyed))) && (ifaceInternalSCI.SEND_SRC_ACTIVITY_OFF_RESULT_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion__sync2();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_DestroyEcnrAndDeallocateChannel_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrStop();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_WaitForEcnrDestroy_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSourceSwitch. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_CHANNEL_DEALLOCATED_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_AutoSourceSwitch();
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(NOT_ALLOCATED, (sc_string) "Source Switch");
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_StopVoiceRecAudioStreamingRegion_ExitOnchannelDeallocated();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StopVoiceRecAudioStreaming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(const sc_boolean try_transition) {
	/* The reactions of state PauseVoiceRecAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_StopAfterEcnrResponse0();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAOffAfterEcnrResponse3();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAPauseAfterEcnrResponse5();
				}  else
				{
					if (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
						enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_StreamingOngoing();
						VoiceRecAudioRegion_VoiceRecAudio_react(false);
					}  else
					{
						if (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised)
						{ 
							exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
							enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_StreamingVoiceRecAudio_VoiceRecStartStreaming();
							VoiceRecAudioRegion_VoiceRecAudio_react(false);
						}  else
						{
							if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
							{ 
								exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio();
								ifaceAudioWrapperReqIf_OCB->sendSrcActivityResult(SRC_ACTIVITY_ON);
								enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_entry_AutoSAOnAfterEcnrResponse9();
							}  else
							{
								did_transition = false;
							}
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICEREC_CHANNEL_raised)
		{ 
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(READY_TO_STREAM, (sc_string) "Channel Already Prepared");
		} 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrStop();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused_react(const sc_boolean try_transition) {
	/* The reactions of state VoiceRecAudioPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_1();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_DestroyEcnr();
			}  else
			{
				if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
					react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_DestroEcnrAndDeallocate();
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused();
						react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPause();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PlayAfterEcnrResponse();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecStartStreaming();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrConfigure. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(false);
		}  else
		{
			if (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_WaitForEcnrConfigure();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecStartStreaming();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			ifaceEcnrRequest_OCB->sendEcnrSetConfiguration(ifaceVoiceRecAudioSmHandler.samplingType);
		} 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecAudioPaused_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(false);
		}  else
		{
			if (ifaceAmClientRequest.STREAM_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_PauseAfterEcnrResponse();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion__choice_0();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_StopAfterEcnrResponse();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_DestroEcnrAndDeallocate();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOffAfterEcnrResponse();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_DestroyEcnr();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAPauseAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_SUCCESS_raised)) || (ifaceEcnrResponse.ECNR_SET_CONFIGURATION_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPauseAfterEcnrResponse();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAPause();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOnAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_AutoSAOnAfterEcnrResponse();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_PauseVoiceRecAudioRegion_VoiceRecStartStreaming();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_PauseVoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(const sc_boolean try_transition) {
	/* The reactions of state AutoPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_entry_AutoSAOffAfterEcnrResponse2();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_entry_StopAfterEcnrResponse3();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PREPARE_VOICEREC_CHANNEL_raised)
		{ 
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(FAILURE, (sc_string) "ChannelAcquisition-Channel Already Prepared");
		} 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_react(const sc_boolean try_transition) {
	/* The reactions of state ChannelAutoPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureEcnrAndStart();
		}  else
		{
			if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DeallocateRoute();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused();
					react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOff();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.PAUSE_VOICEREC_AUDIO_raised)
		{ 
			ifaceVoiceRecAudioSmHandler_OCB->updateStatus(STREAMING_PAUSED, (sc_string) "Audio paused");
		} 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrStop();
						enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_default();
						VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_react(const sc_boolean try_transition) {
	/* The reactions of state StartToStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartStreaming();
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				if (ifaceAmClientRequest.STOP_VOICEREC_AUDIO_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
				}  else
				{
					if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_OFF_raised)
					{ 
						exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
						enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_default();
						VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
					}  else
					{
						if (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised)
						{ 
							exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream();
							react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ECNR_STOP_FAILURE();
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_react(const sc_boolean try_transition) {
	/* The reactions of state ConfigureAndStream. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised)
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartStreaming();
		}  else
		{
			if (ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
				react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureEcnrAndStart();
			}  else
			{
				if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_PAUSE_raised)
				{ 
					exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream();
					enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_default();
					VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrResponse();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOff();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrResponse();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DeallocateRoute();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state StopAfterEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StopAfterEcnrStop();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrAndDeallocate();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state AutoSAOffAfterEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_AutoSAOffAfterEcnrStop();
			react_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_DestroyEcnrOnly();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterEcnrDestroy. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_DESTROY_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_DESTROY_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ChannelAutoPaused_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrDestroy();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_ConfigureAndStream_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}

sc_boolean VoiceRecAudioSm::VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop_react(const sc_boolean try_transition) {
	/* The reactions of state PauseAfterEcnrStop. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceEcnrResponse.ECNR_STOP_SUCCESS_raised) || (ifaceEcnrResponse.ECNR_STOP_FAILURE_raised))
		{ 
			exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
			enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_WaitForEcnrDestroy_default();
			VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
		}  else
		{
			if (ifaceAudioWrapperResponse.VOICEREC_AUDIO_SA_ON_raised)
			{ 
				exseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_PauseAfterEcnrStop();
				enseq_VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_AutoPauseRegion_StartToStream_default();
				VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = VoiceRecAudioRegion_VoiceRecAudio_VoiceRecAudioStartRegion_AutoPaused_react(try_transition);
	} 
	return did_transition;
}



