/* *
 * @file VoiceCallAudioSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from VoiceCallAudioSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 * */

#include "MuteUnmuteSm.h"

/*! \file Implementation of the state machine 'MuteUnmuteSm'
*/




MuteUnmuteSm::MuteUnmuteSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceAmClientRequest(this),
ifaceEcnrRequest(this),
ifaceEcnrRequest_OCB(sc_null),
ifaceEcnrResponse(this),
ifaceSmHandler(this),
ifaceSmHandler_OCB(sc_null),
isRunningCycle(false)
{
}

MuteUnmuteSm::~MuteUnmuteSm()
{
}


using namespace muteunmutesm_events;

SctEvent* MuteUnmuteSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void MuteUnmuteSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_AmClientRequest_MUTE_AUDIO:
		case SCI_AmClientRequest_DEMUTE_AUDIO:
		{
			ifaceAmClientRequest.dispatch_event(event);
			break;
		}
		case SCI_EcnrResponse_REQUEST_SUCCESS:
		case SCI_EcnrResponse_REQUEST_FAILURE:
		{
			ifaceEcnrResponse.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void MuteUnmuteSm::SCI_AmClientRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AmClientRequest_MUTE_AUDIO:
		{
			internal_raise_mUTE_AUDIO();
			break;
		}
		case SCI_AmClientRequest_DEMUTE_AUDIO:
		{
			internal_raise_dEMUTE_AUDIO();
			break;
		}
		default:
			break;
	}
}
void MuteUnmuteSm::SCI_EcnrRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void MuteUnmuteSm::SCI_EcnrResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_EcnrResponse_REQUEST_SUCCESS:
		{
			internal_raise_rEQUEST_SUCCESS();
			break;
		}
		case SCI_EcnrResponse_REQUEST_FAILURE:
		{
			internal_raise_rEQUEST_FAILURE();
			break;
		}
		default:
			break;
	}
}
void MuteUnmuteSm::SCI_SmHandler::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}


void MuteUnmuteSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = MuteUnmuteSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
}

void MuteUnmuteSm::enter()
{
	/* Default enter sequence for statechart MuteUnmuteSm */
	enseq_mute_unmute_region_default();
}

void MuteUnmuteSm::exit()
{
	/* Default exit sequence for statechart MuteUnmuteSm */
	exseq_mute_unmute_region();
}

sc_boolean MuteUnmuteSm::isActive() const
{
	return stateConfVector[0] != MuteUnmuteSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean MuteUnmuteSm::isFinal() const
{
   return false;}

void MuteUnmuteSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case mute_unmute_region_Muting :
				{
					mute_unmute_region_Muting_react(true);
					break;
				}
				case mute_unmute_region_DeMuting :
				{
					mute_unmute_region_DeMuting_react(true);
					break;
				}
				case mute_unmute_region_Demuted :
				{
					mute_unmute_region_Demuted_react(true);
					break;
				}
				case mute_unmute_region_Muted :
				{
					mute_unmute_region_Muted_react(true);
					break;
				}
				case mute_unmute_region_DemuteAfterMuted :
				{
					mute_unmute_region_DemuteAfterMuted_react(true);
					break;
				}
				case mute_unmute_region_MuteAfterDemuted :
				{
					mute_unmute_region_MuteAfterDemuted_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void MuteUnmuteSm::clearInEvents()
{
	ifaceAmClientRequest.MUTE_AUDIO_raised = false;
	ifaceAmClientRequest.DEMUTE_AUDIO_raised = false;
	ifaceEcnrResponse.REQUEST_SUCCESS_raised = false;
	ifaceEcnrResponse.REQUEST_FAILURE_raised = false;
}

void MuteUnmuteSm::clearOutEvents()
{
}


sc_boolean MuteUnmuteSm::isStateActive(MuteUnmuteSmStates state) const
{
	switch (state)
	{
		case mute_unmute_region_Muting : 
			return (sc_boolean) (stateConfVector[SCVI_MUTE_UNMUTE_REGION_MUTING] == mute_unmute_region_Muting
			);
		case mute_unmute_region_DeMuting : 
			return (sc_boolean) (stateConfVector[SCVI_MUTE_UNMUTE_REGION_DEMUTING] == mute_unmute_region_DeMuting
			);
		case mute_unmute_region_Demuted : 
			return (sc_boolean) (stateConfVector[SCVI_MUTE_UNMUTE_REGION_DEMUTED] == mute_unmute_region_Demuted
			);
		case mute_unmute_region_Muted : 
			return (sc_boolean) (stateConfVector[SCVI_MUTE_UNMUTE_REGION_MUTED] == mute_unmute_region_Muted
			);
		case mute_unmute_region_DemuteAfterMuted : 
			return (sc_boolean) (stateConfVector[SCVI_MUTE_UNMUTE_REGION_DEMUTEAFTERMUTED] == mute_unmute_region_DemuteAfterMuted
			);
		case mute_unmute_region_MuteAfterDemuted : 
			return (sc_boolean) (stateConfVector[SCVI_MUTE_UNMUTE_REGION_MUTEAFTERDEMUTED] == mute_unmute_region_MuteAfterDemuted
			);
		default: return false;
	}
}

MuteUnmuteSm::SCI_AmClientRequest* MuteUnmuteSm::getSCI_AmClientRequest()
{
	return &ifaceAmClientRequest;
}
/* Functions for event MUTE_AUDIO in interface SCI_AmClientRequest */
void MuteUnmuteSm::SCI_AmClientRequest::raise_mUTE_AUDIO()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_MUTE_AUDIO(SCI_AmClientRequest_MUTE_AUDIO));
	parent->runCycle();
}
void MuteUnmuteSm::SCI_AmClientRequest::internal_raise_mUTE_AUDIO()
{
	MUTE_AUDIO_raised = true;
}
/* Functions for event DEMUTE_AUDIO in interface SCI_AmClientRequest */
void MuteUnmuteSm::SCI_AmClientRequest::raise_dEMUTE_AUDIO()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AmClientRequest_DEMUTE_AUDIO(SCI_AmClientRequest_DEMUTE_AUDIO));
	parent->runCycle();
}
void MuteUnmuteSm::SCI_AmClientRequest::internal_raise_dEMUTE_AUDIO()
{
	DEMUTE_AUDIO_raised = true;
}
MuteUnmuteSm::SCI_EcnrRequest* MuteUnmuteSm::getSCI_EcnrRequest()
{
	return &ifaceEcnrRequest;
}
void MuteUnmuteSm::setSCI_EcnrRequest_OCB(SCI_EcnrRequest_OCB* operationCallback)
{
	ifaceEcnrRequest_OCB = operationCallback;
}
MuteUnmuteSm::SCI_EcnrResponse* MuteUnmuteSm::getSCI_EcnrResponse()
{
	return &ifaceEcnrResponse;
}
/* Functions for event REQUEST_SUCCESS in interface SCI_EcnrResponse */
void MuteUnmuteSm::SCI_EcnrResponse::raise_rEQUEST_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_REQUEST_SUCCESS(SCI_EcnrResponse_REQUEST_SUCCESS));
	parent->runCycle();
}
void MuteUnmuteSm::SCI_EcnrResponse::internal_raise_rEQUEST_SUCCESS()
{
	REQUEST_SUCCESS_raised = true;
}
/* Functions for event REQUEST_FAILURE in interface SCI_EcnrResponse */
void MuteUnmuteSm::SCI_EcnrResponse::raise_rEQUEST_FAILURE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_EcnrResponse_REQUEST_FAILURE(SCI_EcnrResponse_REQUEST_FAILURE));
	parent->runCycle();
}
void MuteUnmuteSm::SCI_EcnrResponse::internal_raise_rEQUEST_FAILURE()
{
	REQUEST_FAILURE_raised = true;
}
MuteUnmuteSm::SCI_SmHandler* MuteUnmuteSm::getSCI_SmHandler()
{
	return &ifaceSmHandler;
}
void MuteUnmuteSm::setSCI_SmHandler_OCB(SCI_SmHandler_OCB* operationCallback)
{
	ifaceSmHandler_OCB = operationCallback;
}

void MuteUnmuteSm::setTraceObserver(ysc::TraceObserver<MuteUnmuteSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<MuteUnmuteSm::MuteUnmuteSmStates>* MuteUnmuteSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

/* Exit action for state 'Muted'. */
void MuteUnmuteSm::exact_mute_unmute_region_Muted()
{
	/* Exit action for state 'Muted'. */
	ifaceEcnrRequest_OCB->sendEcnrDeMuteRequest();
}

/* 'default' enter sequence for state Muting */
void MuteUnmuteSm::enseq_mute_unmute_region_Muting_default()
{
	/* 'default' enter sequence for state Muting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(MuteUnmuteSm::mute_unmute_region_Muting);
	}
	stateConfVector[0] = mute_unmute_region_Muting;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state DeMuting */
void MuteUnmuteSm::enseq_mute_unmute_region_DeMuting_default()
{
	/* 'default' enter sequence for state DeMuting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(MuteUnmuteSm::mute_unmute_region_DeMuting);
	}
	stateConfVector[0] = mute_unmute_region_DeMuting;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Demuted */
void MuteUnmuteSm::enseq_mute_unmute_region_Demuted_default()
{
	/* 'default' enter sequence for state Demuted */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(MuteUnmuteSm::mute_unmute_region_Demuted);
	}
	stateConfVector[0] = mute_unmute_region_Demuted;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Muted */
void MuteUnmuteSm::enseq_mute_unmute_region_Muted_default()
{
	/* 'default' enter sequence for state Muted */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(MuteUnmuteSm::mute_unmute_region_Muted);
	}
	stateConfVector[0] = mute_unmute_region_Muted;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state DemuteAfterMuted */
void MuteUnmuteSm::enseq_mute_unmute_region_DemuteAfterMuted_default()
{
	/* 'default' enter sequence for state DemuteAfterMuted */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(MuteUnmuteSm::mute_unmute_region_DemuteAfterMuted);
	}
	stateConfVector[0] = mute_unmute_region_DemuteAfterMuted;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state MuteAfterDemuted */
void MuteUnmuteSm::enseq_mute_unmute_region_MuteAfterDemuted_default()
{
	/* 'default' enter sequence for state MuteAfterDemuted */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(MuteUnmuteSm::mute_unmute_region_MuteAfterDemuted);
	}
	stateConfVector[0] = mute_unmute_region_MuteAfterDemuted;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region mute_unmute_region */
void MuteUnmuteSm::enseq_mute_unmute_region_default()
{
	/* 'default' enter sequence for region mute_unmute_region */
	react_mute_unmute_region__entry_Default();
}

/* Default exit sequence for state Muting */
void MuteUnmuteSm::exseq_mute_unmute_region_Muting()
{
	/* Default exit sequence for state Muting */
	stateConfVector[0] = MuteUnmuteSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state DeMuting */
void MuteUnmuteSm::exseq_mute_unmute_region_DeMuting()
{
	/* Default exit sequence for state DeMuting */
	stateConfVector[0] = MuteUnmuteSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Demuted */
void MuteUnmuteSm::exseq_mute_unmute_region_Demuted()
{
	/* Default exit sequence for state Demuted */
	stateConfVector[0] = MuteUnmuteSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Muted */
void MuteUnmuteSm::exseq_mute_unmute_region_Muted()
{
	/* Default exit sequence for state Muted */
	stateConfVector[0] = MuteUnmuteSm_last_state;
	stateConfVectorPosition = 0;
	exact_mute_unmute_region_Muted();
}

/* Default exit sequence for state DemuteAfterMuted */
void MuteUnmuteSm::exseq_mute_unmute_region_DemuteAfterMuted()
{
	/* Default exit sequence for state DemuteAfterMuted */
	stateConfVector[0] = MuteUnmuteSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state MuteAfterDemuted */
void MuteUnmuteSm::exseq_mute_unmute_region_MuteAfterDemuted()
{
	/* Default exit sequence for state MuteAfterDemuted */
	stateConfVector[0] = MuteUnmuteSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for region mute_unmute_region */
void MuteUnmuteSm::exseq_mute_unmute_region()
{
	/* Default exit sequence for region mute_unmute_region */
	/* Handle exit of all possible states (of MuteUnmuteSm.mute_unmute_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case mute_unmute_region_Muting :
		{
			exseq_mute_unmute_region_Muting();
			break;
		}
		case mute_unmute_region_DeMuting :
		{
			exseq_mute_unmute_region_DeMuting();
			break;
		}
		case mute_unmute_region_Demuted :
		{
			exseq_mute_unmute_region_Demuted();
			break;
		}
		case mute_unmute_region_Muted :
		{
			exseq_mute_unmute_region_Muted();
			break;
		}
		case mute_unmute_region_DemuteAfterMuted :
		{
			exseq_mute_unmute_region_DemuteAfterMuted();
			break;
		}
		case mute_unmute_region_MuteAfterDemuted :
		{
			exseq_mute_unmute_region_MuteAfterDemuted();
			break;
		}
		default: break;
	}
}

/* Default react sequence for initial entry  */
void MuteUnmuteSm::react_mute_unmute_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_mute_unmute_region_Demuted_default();
}

sc_boolean MuteUnmuteSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean MuteUnmuteSm::mute_unmute_region_Muting_react(const sc_boolean try_transition) {
	/* The reactions of state Muting. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.REQUEST_SUCCESS_raised)
		{ 
			exseq_mute_unmute_region_Muting();
			ifaceSmHandler_OCB->updateStatus((sc_string) "Mic Muted");
			enseq_mute_unmute_region_Muted_default();
			react();
		}  else
		{
			if (ifaceAmClientRequest.DEMUTE_AUDIO_raised)
			{ 
				exseq_mute_unmute_region_Muting();
				enseq_mute_unmute_region_DemuteAfterMuted_default();
				react();
			}  else
			{
				if (ifaceEcnrResponse.REQUEST_FAILURE_raised)
				{ 
					exseq_mute_unmute_region_Muting();
					ifaceSmHandler_OCB->updateStatus((sc_string) "Mic mute failure");
					enseq_mute_unmute_region_Demuted_default();
					react();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.MUTE_AUDIO_raised)
		{ 
			ifaceSmHandler_OCB->updateStatus((sc_string) "Mic mute failure");
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean MuteUnmuteSm::mute_unmute_region_DeMuting_react(const sc_boolean try_transition) {
	/* The reactions of state DeMuting. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.REQUEST_SUCCESS_raised)
		{ 
			exseq_mute_unmute_region_DeMuting();
			ifaceSmHandler_OCB->updateStatus((sc_string) "Mic Demuted");
			enseq_mute_unmute_region_Demuted_default();
			react();
		}  else
		{
			if (ifaceAmClientRequest.MUTE_AUDIO_raised)
			{ 
				exseq_mute_unmute_region_DeMuting();
				enseq_mute_unmute_region_MuteAfterDemuted_default();
				react();
			}  else
			{
				if (ifaceEcnrResponse.REQUEST_FAILURE_raised)
				{ 
					exseq_mute_unmute_region_DeMuting();
					ifaceSmHandler_OCB->updateStatus((sc_string) "Mic demute failure");
					enseq_mute_unmute_region_Muted_default();
					react();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.DEMUTE_AUDIO_raised)
		{ 
			ifaceSmHandler_OCB->updateStatus((sc_string) "Mic demute failure");
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean MuteUnmuteSm::mute_unmute_region_Demuted_react(const sc_boolean try_transition) {
	/* The reactions of state Demuted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.MUTE_AUDIO_raised)
		{ 
			exseq_mute_unmute_region_Demuted();
			ifaceEcnrRequest_OCB->sendEcnrMuteRequest();
			enseq_mute_unmute_region_Muting_default();
			react();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean MuteUnmuteSm::mute_unmute_region_Muted_react(const sc_boolean try_transition) {
	/* The reactions of state Muted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.DEMUTE_AUDIO_raised)
		{ 
			exseq_mute_unmute_region_Muted();
			enseq_mute_unmute_region_DeMuting_default();
			react();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAmClientRequest.MUTE_AUDIO_raised)
		{ 
			ifaceSmHandler_OCB->updateStatus((sc_string) "Mic Muted");
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean MuteUnmuteSm::mute_unmute_region_DemuteAfterMuted_react(const sc_boolean try_transition) {
	/* The reactions of state DemuteAfterMuted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceEcnrResponse.REQUEST_SUCCESS_raised)
		{ 
			exseq_mute_unmute_region_DemuteAfterMuted();
			ifaceEcnrRequest_OCB->sendEcnrDeMuteRequest();
			enseq_mute_unmute_region_DeMuting_default();
			react();
		}  else
		{
			if (ifaceAmClientRequest.MUTE_AUDIO_raised)
			{ 
				exseq_mute_unmute_region_DemuteAfterMuted();
				enseq_mute_unmute_region_Muting_default();
				react();
			}  else
			{
				if (ifaceEcnrResponse.REQUEST_FAILURE_raised)
				{ 
					exseq_mute_unmute_region_DemuteAfterMuted();
					ifaceSmHandler_OCB->updateStatus((sc_string) "Mic mute failure");
					enseq_mute_unmute_region_Demuted_default();
					react();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean MuteUnmuteSm::mute_unmute_region_MuteAfterDemuted_react(const sc_boolean try_transition) {
	/* The reactions of state MuteAfterDemuted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAmClientRequest.DEMUTE_AUDIO_raised)
		{ 
			exseq_mute_unmute_region_MuteAfterDemuted();
			enseq_mute_unmute_region_DeMuting_default();
			react();
		}  else
		{
			if (ifaceEcnrResponse.REQUEST_FAILURE_raised)
			{ 
				exseq_mute_unmute_region_MuteAfterDemuted();
				ifaceSmHandler_OCB->updateStatus((sc_string) "Mic demute failure");
				enseq_mute_unmute_region_Muted_default();
				react();
			}  else
			{
				if (ifaceEcnrResponse.REQUEST_SUCCESS_raised)
				{ 
					exseq_mute_unmute_region_MuteAfterDemuted();
					ifaceEcnrRequest_OCB->sendEcnrMuteRequest();
					enseq_mute_unmute_region_Muting_default();
					react();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}



