/**
 * @file AmSessionController.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the AmSessionController class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the AmSessionController interfaces of PmAudioManager
 *
 * @ingroup PmAudioManager
 */

#ifndef AmSessionController_h
#define AmSessionController_h

#include "PmAudioManagerTypesInternal.h"

namespace pmaudiomanager
{
   //class forward declarations
   class ISmAudioSessionIf;

   //Method Requests
   class AmIfMessage_PrepareAudioRouteRequest;
   class AmIfMessage_PlayAudioFileRequest;
   class AmIfMessage_PlayHfAudioRequest;
   class AmIfMessage_StopAudioRequest;
   class AmIfMessage_PauseAudioRequest;
   class AmIfMessage_SetMicMuteStateRequest;


   //Method Results
   class AmIfMessage_EcnrInitializeResult;
   class AmIfMessage_EcnrDestroyResult;
   class AmIfMessage_EcnrSetConfigurationResult;
   class AmIfMessage_EcnrSetSendMuteSwitchResult;
   class AmIfMessage_EcnrStartAudioResult;
   class AmIfMessage_EcnrStopAudioResult;
   class AmIfMessage_EcnrGetVersionResult;
   class AmIfMessage_RequestAudioRouteResult;
   class AmIfMessage_ReleaseAudioRouteResult;
   class AmIfMessage_SourceActivityResult;
   class AmIfMessage_PlaybackStatus;

   class AmSessionController
   {
   public:
      /**
       * Constructor of AmSessionController class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      AmSessionController();

      /**
       * Destructor of AmSessionController class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      ~AmSessionController();

      /**
       * Copy constructor of AmSessionController class
       *
       * @param[in] ref - Reference to AmSessionController
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AmSessionController(const AmSessionController& ref);

      /**
       * operator= overloaded function
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return Returns the object of the AmSessionController
       *
       */
      AmSessionController& operator=(const AmSessionController& ref);

      /**
       * This method is used to handle PrepareAudioRoute Request
       *
       * @param[in] amIfMessage - shared pointer to PrepareAudioRouteRequest
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void prepareAudioRouteRequest(IN std::shared_ptr<AmIfMessage_PrepareAudioRouteRequest> amIfMessage);

      /**
       * This method is used to handle PlayAudioFile Request
       *
       * @param[in] amIfMessage - shared pointer to PlayAudioFileRequest
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void playAudioFileRequest(IN std::shared_ptr<AmIfMessage_PlayAudioFileRequest> amIfMessage);

      /**
       * This method is used to handle PlayHfAudio Request
       *
       * @param[in] amIfMessage - shared pointer to PlayHfAudioRequest
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void playHfAudioRequest(IN std::shared_ptr<AmIfMessage_PlayHfAudioRequest> amIfMessage);

      /**
       * This method is used to handle StopAudio Request
       *
       * @param[in] amIfMessage - shared pointer to StopAudioRequest
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void stopAudioRequest(IN std::shared_ptr<AmIfMessage_StopAudioRequest> amIfMessage);

      /**
       * This method is used to handle PauseAudio Request
       *
       * @param[in] amIfMessage - shared pointer to PauseAudioRequest
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void pauseAudioRequest(IN std::shared_ptr<AmIfMessage_PauseAudioRequest> amIfMessage);

      /**
       * This method is used to handle set Mic Mute State Request
       *
       * @param[in] amIfMessage - shared pointer to Mic Mute State Request
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void setMicMuteStateRequest(IN std::shared_ptr<AmIfMessage_SetMicMuteStateRequest> amIfMessage);

      /**
       * This method is used to handle EcnrInitialize Result
       *
       * @param[in] amIfMessage - shared pointer to EcnrInitializeResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrInitializeResult(IN std::shared_ptr<AmIfMessage_EcnrInitializeResult> amIfMessage);

      /**
       * This method is used to handle EcnrDestroy Result
       *
       * @param[in] amIfMessage - shared pointer to EcnrDestroyResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrDestroyResult(IN std::shared_ptr<AmIfMessage_EcnrDestroyResult> amIfMessage);

      /**
       * This method is used to handle EcnrSetConfiguration Result
       *
       * @param[in] amIfMessage - shared pointer to EcnrSetConfigurationResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrSetConfigurationResult(IN std::shared_ptr<AmIfMessage_EcnrSetConfigurationResult> amIfMessage);

      /**
       * This method is used to handle EcnrSetSendMuteSwitch Result
       *
       * @param[in] amIfMessage - shared pointer to EcnrSetSendMuteSwitchResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrSetSendMuteSwitchResult(IN std::shared_ptr<AmIfMessage_EcnrSetSendMuteSwitchResult> amIfMessage);

      /**
       * This method is used to handle EcnrStartAudio Result
       *
       * @param[in] amIfMessage - shared pointer to EcnrStartAudioResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrStartAudioResult(IN std::shared_ptr<AmIfMessage_EcnrStartAudioResult> amIfMessage);

      /**
       * This method is used to handle EcnrStopAudio Result
       *
       * @param[in] amIfMessage - shared pointer to EcnrStopAudioResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrStopAudioResult(IN std::shared_ptr<AmIfMessage_EcnrStopAudioResult> amIfMessage);

      /**
       * This method is used to handle EcnrGetVersion Result
       *
       * @param[in] amIfMessage - shared pointer to EcnrGetVersionResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void ecnrGetVersionResult(IN std::shared_ptr<AmIfMessage_EcnrGetVersionResult> amIfMessage);

      /**
       * This method is used to handle RequestAudioRoute Result
       *
       * @param[in] amIfMessage - shared pointer to RequestAudioRouteResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void requestAudioRouteResult(IN std::shared_ptr<AmIfMessage_RequestAudioRouteResult> amIfMessage);

      /**
       * This method is used to handle ReleaseAudioRoute Result
       *
       * @param[in] amIfMessage - shared pointer to ReleaseAudioRouteResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void releaseAudioRouteResult(IN std::shared_ptr<AmIfMessage_ReleaseAudioRouteResult> amIfMessage);

      /**
       * This method is used to handle SourceActivity Result
       *
       * @param[in] amIfMessage - shared pointer to SourceActivityResult
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void sourceActivityResult(IN std::shared_ptr<AmIfMessage_SourceActivityResult> amIfMessage);

      /**
       * This method is used to handle audio player Playback Status
       *
       * @param[in] amIfMessage - shared pointer to PlaybackStatus
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      void playbackStatus(IN std::shared_ptr<AmIfMessage_PlaybackStatus> amIfMessage);

   private:
      ISmAudioSessionIf*      _smAudioSessionIf;      /**< pointer for audio session sm interface */
   };
}

#endif // AmSessionController_h
