/**
 * @file PmAudioManagerCallbackIfWrapper.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PmAudioManagerCallbackIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the CPP callback interfaces of PmAudioManager.
 *
 * @ingroup PmAudioManager
 */


#include "PmAudioManagerCallbackIfWrapper.h"
#include "IPmAudioManagerCallbackIf.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PmAudioManagerCallbackIfWrapper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#endif
#endif

namespace pmaudiomanager
{

PmAudioManagerCallbackIfWrapper::PmAudioManagerCallbackIfWrapper
(IPmAudioManagerCallbackIf* pmAudioManagerCallbackIf) : _pmAudioManagerCallbackIf(pmAudioManagerCallbackIf)
{
   ETG_TRACE_USR4(("PmAudioManagerCallbackIfWrapper"));
}

PmAudioManagerCallbackIfWrapper::~PmAudioManagerCallbackIfWrapper()
{
   _pmAudioManagerCallbackIf = nullptr;
}

void PmAudioManagerCallbackIfWrapper::prepareAudioRouteResponse(IN const AmSessionId amSessionId,
      IN const AmResult amResult)
{
   ETG_TRACE_USR4(("prepareAudioRouteResponse: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->prepareAudioRouteResponse(amSessionId, amResult);
   }
}

void PmAudioManagerCallbackIfWrapper::playAudioResponse(IN const AmSessionId amSessionId, IN const AmResult amResult)
{
   ETG_TRACE_USR4(("playAudioResponse: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->playAudioResponse(amSessionId, amResult);
   }
}

void PmAudioManagerCallbackIfWrapper::stopAudioResponse(IN const AmSessionId amSessionId, IN const AmResult amResult)
{
   ETG_TRACE_USR4(("stopAudioResponse: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->stopAudioResponse(amSessionId, amResult);
   }
}

void PmAudioManagerCallbackIfWrapper::amNotificationEvent(IN const AmSessionId amSessionId,
      IN const AudioChannel audioChannelId, IN const StreamingState streamingState, IN const AmEventDetails eventInfo)
{
   ETG_TRACE_USR4(("amNotificationEvent: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->amNotificationEvent(amSessionId, audioChannelId, streamingState, eventInfo);
   }
}

void PmAudioManagerCallbackIfWrapper::setMicMuteStateResponse(IN const AmSessionId amSessionId,
      IN const AmResult amResult)
{
   ETG_TRACE_USR4(("setMicMuteStateResponse: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->setMicMuteStateResponse(amSessionId, amResult);
   }
}

void PmAudioManagerCallbackIfWrapper::pauseAudioResponse(IN const AmSessionId amSessionId, IN const AmResult amResult)
{
   ETG_TRACE_USR4(("pauseAudioResponse: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->pauseAudioResponse(amSessionId, amResult);
   }
}

void PmAudioManagerCallbackIfWrapper::getAudioSinkVolumeResponse(IN const AmSessionId amSessionId,
      IN const AmResult amResult)
{
   (void)(amResult);
   ETG_TRACE_USR4(("getAudioSinkVolumeResponse: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->getAudioSinkVolumeResponse(amSessionId, amResult);
   }
}

void PmAudioManagerCallbackIfWrapper::setAudioSinkVolumeResponse(IN const AmSessionId amSessionId,
      IN const AmResult amResult)
{
   (void)(amResult);
   ETG_TRACE_USR4(("setAudioSinkVolumeResponse: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->setAudioSinkVolumeResponse(amSessionId, amResult);
   }
}

void PmAudioManagerCallbackIfWrapper::updateAudioSinkVolumeList(IN const AmSessionId amSessionId,
      IN const AmResult amResult, IN const GeniviAMSinkId sinkId, IN const AmPropertyType2VolumeMap propertyList)
{
   (void)(amResult);
   (void)(sinkId);
   (void)(propertyList);
   ETG_TRACE_USR4(("updateAudioSinkVolumeList: amSessionId = %u", amSessionId));

   if (_pmAudioManagerCallbackIf)
   {
      _pmAudioManagerCallbackIf->updateAudioSinkVolumeList(amSessionId, amResult, sinkId, propertyList);
   }
}

} /* namespace pmaudiomanager */
