/**
 * @file AmResult.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AmResult class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "AmResult.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AmResult.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#endif
#endif

namespace pmaudiomanager
{
   AmResult::AmResult() : _amResultCode(AM_RESULT_OK), _amResultMessage("")
   {
   }

   AmResult::AmResult(const AmResultCode amResultCode, const AmResultMessage amResultMessage) :
         _amResultCode(amResultCode), _amResultMessage(amResultMessage)
   {
   }

   AmResult::AmResult(const AmResult& other) :
         _amResultCode(other._amResultCode), _amResultMessage(other._amResultMessage)
   {
   }

   AmResult::~AmResult()
   {
   }

   void swap(AmResult& first, AmResult& second)
   {
      using std::swap;

      swap(first._amResultCode, second._amResultCode);
      swap(first._amResultMessage, second._amResultMessage);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   AmResult& AmResult::operator=(AmResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool AmResult::operator==(const AmResult& rhs) const
   {
      return ((this->_amResultCode == rhs._amResultCode)
            && (this->_amResultMessage == rhs._amResultMessage));
   }

   bool AmResult::operator!=(const AmResult& rhs) const
   {
      return (!((this->_amResultCode == rhs._amResultCode)
            && (this->_amResultMessage == rhs._amResultMessage)));
   }
} // namespace pmaudiomanager
