/**
 * @file AmEventDetails.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AmEventDetails class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef AmEventDetails_h
#define AmEventDetails_h

#include "PmAudioManagerTypesInternal.h"

namespace pmaudiomanager
{
   class AmEventDetails
   {
   public:

      /**
       * Constructor of AmEventDetails class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AmEventDetails();

      /**
       * Parameterized Constructor of AmEventDetails class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AmEventDetails(const EventType& event, const StatusMessage& message);

      /**
       * Copy Constructor of AmEventDetails class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      AmEventDetails(const AmEventDetails& ref);

      /**
       * Destructor of AmEventDetails class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~AmEventDetails();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(AmEventDetails& first, AmEventDetails& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      AmEventDetails& operator=(AmEventDetails ref);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const AmEventDetails& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const AmEventDetails& rhs) const;

      EventType _event;
      StatusMessage _message;
   };

} // namespace pmaudiomanager

#endif // AmEventDetails_h
