/**
 * @file AmEventDetails.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AmEventDetails class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#include "AmEventDetails.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AmEventDetails.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#endif
#endif

namespace pmaudiomanager
{
   AmEventDetails::AmEventDetails() : _event(AUDIO_STATE_CHANGE), _message("")
   {
   }

   AmEventDetails::AmEventDetails(const EventType& event, const StatusMessage& message) :
      _event(event), _message(message)
   {
   }

   AmEventDetails::AmEventDetails(const AmEventDetails& ref) :
         _event(ref._event), _message(ref._message)
   {
   }

   AmEventDetails::~AmEventDetails()
   {
   }

   void swap(AmEventDetails& first, AmEventDetails& second)
   {
      using std::swap;

      swap(first._event, second._event);
      swap(first._message, second._message);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   AmEventDetails& AmEventDetails::operator=(AmEventDetails other)
   {
      swap(*this, other);

      return *this;
   }

   bool AmEventDetails::operator==(const AmEventDetails& rhs) const
   {
      return ((this->_event == rhs._event)
            && (this->_message == rhs._message));
   }

   bool AmEventDetails::operator!=(const AmEventDetails& rhs) const
   {
      return (!((this->_event == rhs._event)
            && (this->_message == rhs._message)));
   }
} // namespace pmaudiomanager
