/**
 * @file IGeniviAmRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for Genivi Audio Manager DBUS Proxy
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef IGeniviAmRequestIf_h
#define IGeniviAmRequestIf_h

#include "asf/core/Types.h"
#include "PmAudioManagerTypesInternal.h"

namespace pmaudiomanager {

// class forward declarations
class IGeniviAmCallBackIf;

/**
 * Genivi Audio Manager Request interface class
 */
 class IGeniviAmRequestIf
 {
 public:
    /**
    * Destructor of IGeniviAmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~IGeniviAmRequestIf() {}

   /**
    * Set callback handler.
    *
    * @param[in] callBackIf: callback handler
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IGeniviAmCallBackIf* callBackIf) = 0;

   /**
    * Send GetMainSinkSoundPropertiesList Request
    *
    * @param[in] sinkId: Sink id
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendGetMainSinkSoundPropertiesList(const GeniviAMSinkId sinkId) = 0;

   /**
    * Send GetMainSinkSoundProperty Request
    *
    * @param[in] sinkId: Sink id
    * @param[in] propertyType: Property Type
    * @param[in] volumeLevel: Volume Level
    * @param[out]
    * @param[in,out]
    *
    * @return asynchronous completion token
    */
   virtual act_t sendSetMainSinkSoundProperty(const GeniviAMSinkId sinkId, const GeniviAMPropertyType propertyType, const GeniviAMVolumeLevel volumeLevel) = 0;

   /**
    * registerProperties
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual void registerProperties() = 0;

   /**
    * deRegisterProperties
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual void deRegisterProperties() = 0;

protected:
   /**
    * Parameterized constructor of IGeniviAmRequestIf
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   IGeniviAmRequestIf(bool cmdIfAvailability){_cmdIfAvailability = cmdIfAvailability;}

   bool _cmdIfAvailability;
};

} //pmaudiomanager

#endif //IGeniviAmRequestIf_h
