/**
 * @file IGeniviAmCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for GeniviAm Command Interface DBUS callback
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef IGeniviAmCallBackIf_h
#define IGeniviAmCallBackIf_h

#include "org/genivi/audiomanager/CommandInterfaceProxy.h"
#include <string>

using namespace ::asf::core;

namespace pmaudiomanager {

/**
 *  GeniviAm CallBack Interface Class
 */
class IGeniviAmCallBackIf:
    public ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesCallbackIF,
    public ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyCallbackIF,
    public ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedCallbackIF
{
public:
   /**
    * Destructor of IGeniviAmCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
    virtual ~IGeniviAmCallBackIf() {}

   /**
    * This method is used to notify the proxy availability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
    virtual void onServiceProxyAvailable(const ServiceState previousState, const ServiceState currentState,
        const ::std::string& objPath) = 0;

   /**
    * This method is used to notify the proxy unavailability status
    *
    * @param[in] previousState - previous state of the proxy
    * @param[in] currentState - current state of the proxy
    * @param[in] objPath - object path
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
    virtual void onServiceProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
        const ::std::string& objPath) = 0;

protected:
    /**
    * Error Callback method for GetMainSinkPropertiesList request
    *
    * @param[in] proxy - reference of GeniviAm proxy
    * @param[in] error - reference to GetListMainSinkSoundPropertiesError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
    virtual void onGetListMainSinkSoundPropertiesError(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesError >& error) override = 0;

   /**
    * Callback method for GetMainSinkPropertiesList request
    *
    * @param[in] proxy - reference of GeniviAm proxy
    * @param[in] response - reference to GetListMainSinkSoundPropertiesResponse
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
    virtual void onGetListMainSinkSoundPropertiesResponse(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponse >& response) override = 0;

    /**
    * Error Callback method for SetMainSinkSoundProperty request
    *
    * @param[in] proxy - reference of GeniviAm proxy
    * @param[in] error - reference to SetMainSinkSoundPropertyError
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
    virtual void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyError >& error) override = 0;

   /**
    * Callback method for SetMainSinkSoundProperty request
    *
    * @param[in] proxy - reference of GeniviAm proxy
    * @param[in] response - reference to SetMainSinkSoundProperty Response
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
    virtual void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyResponse >& response) override = 0;

    /**
     * Error Callback method for MainSinkSoundPropertyChanged Signal
     *
     * @param[in] proxy - A reference to GeniviAm Proxy
     * @param[in] response - Reference to MainSinkSoundPropertyChangedError
     * @param[out]
     * @param[in,out]
     *
     * @return void
     */
    virtual void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, 
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedError >& error) override = 0;
     
     /**
     * Callback method for MainSinkSoundPropertyChanged Signal
     *
     * @param[in] proxy - A reference to GeniviAm Proxy
     * @param[in] response - Reference to MainSinkSoundPropertyChanged response
     * @param[out]
     * @param[in,out]
     *
     * @return void
     */
     virtual void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, 
          const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignal >& signal) override = 0;

};

}   //pmaudiomanager

#endif  //IGeniviAmCallBackIf_h