/**
 * @file GeniviAmRequestIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for Genivi Audio Manager DBUS Proxy
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef GeniviAmRequestIf_h
#define GeniviAmRequestIf_h

#include "ICcDbusIfCreateProxy.h"
#include "ICcDbusIfDestroyProxy.h"
#include "IGeniviAmRequestIf.h"
#include "org/genivi/audiomanager/CommandInterfaceProxy.h"

using namespace ::asf::core;

namespace pmaudiomanager {

// class forward declarations
class IGeniviAmRequestIf;
class IGeniviAmCallBackIf;

/**
 * Genivi Audio Manager Request class
 */
class GeniviAmRequestIf final :
      public ServiceAvailableIF,
      public ::ccdbusif::ICcDbusIfCreateProxy,
      public ::ccdbusif::ICcDbusIfDestroyProxy,
      public IGeniviAmRequestIf
{
public:
   /**
    * Constructor of GeniviAmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   GeniviAmRequestIf();

   /**
    * Destructor of GeniviAmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual ~GeniviAmRequestIf();

   /**
    * Member function Overridden from ICcDbusIfCreateProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void createProxy(void) override;

   /**
    * Member function Overridden from ICcDbusIfDestroyProxy class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void destroyProxy(void) override;

   /**
    * Member function Overridden from IGeniviAmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void setCallbackIf(IGeniviAmCallBackIf* callBackIf) override;

   /**
    * Member function Overridden from ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

   /**
    * Member function Overridden from ServiceAvailableIF class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange) override;

    /**
    * Member function Overridden from IGeniviAmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendGetMainSinkSoundPropertiesList(const GeniviAMSinkId sinkId) override;

   /**
    * Member function Overridden from IGeniviAmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
   virtual act_t sendSetMainSinkSoundProperty(const GeniviAMSinkId sinkId, const GeniviAMPropertyType propertyType, const GeniviAMVolumeLevel volumeLevel) override;

   /**
    * Member function Overridden from IGeniviAmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual void registerProperties() override;

   /**
    * Member function Overridden from IGeniviAmRequestIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
   virtual void deRegisterProperties() override;

private:
   ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy > _cmdIfProxy; /**< GeniviAm proxy */
   IGeniviAmCallBackIf* _callBackIf; /**< pointer to GeniviAm callback */
};

}

#endif  //GeniviAmRequestIf_h
