/**
 * @file GeniviAmCallBackIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for GeniviAm Command Interface DBUS callback
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmAudioManager
 */

#ifndef GeniviAmCallBackIf_h
#define GeniviAmCallBackIf_h

#include "IGeniviAmCallBackIf.h"

namespace pmaudiomanager {

//class forward declarations
class GeniviAmWrapper;

/**
 * GeniviAm Callback class
 */
class GeniviAmCallBackIf : public IGeniviAmCallBackIf
{
public:
    /**
    * Parameterized Constructor of GeniviAmCallBackIf class
    *
    * @param[in] GeniviAmWrapper - pointer to GeniviAmWrapper
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
    GeniviAmCallBackIf(GeniviAmWrapper* geniviAmWrapper);

   /**
    * Destructor of GeniviAmCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    */
    virtual ~GeniviAmCallBackIf();

   /**
    * Member function Overridden from GeniviAmCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
    virtual void onServiceProxyAvailable(const ServiceState previousState, const ServiceState currentState,
        const ::std::string& objPath) override;

   /**
    * Member function Overridden from GeniviAmCallBackIf class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return void
    */
    virtual void onServiceProxyUnavailable(const ServiceState previousState, const ServiceState currentState,
        const ::std::string& objPath) override;

protected:
   /**
    * Constructor of GeniviAm CallBack class
    *
    * @param[in]
    * @param[out]
    * @param[inout]
    *
    * @return
    */
    GeniviAmCallBackIf();

   /**
    * Member function overridden from GeniviAmCallBackIf
    *
    * @param[in]
    * @param[out]
    * @param[inout]
    *
    * @return void
    */
    virtual void onGetListMainSinkSoundPropertiesError(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesError >& error) override;

    /**
    * Member function overridden from GeniviAmCallBackIf
    *
    * @param[in]
    * @param[out]
    * @param[inout]
    *
    * @return void
    */
    virtual void onGetListMainSinkSoundPropertiesResponse(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponse >& response) override;

   /**
    * Member function overridden from GeniviAmCallBackIf
    *
    * @param[in]
    * @param[out]
    * @param[inout]
    *
    * @return void
    */
    virtual void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyError >& error) override;

   /**
    * Member function overridden from GeniviAmCallBackIf
    *
    * @param[in]
    * @param[out]
    * @param[inout]
    *
    * @return void
    */
    virtual void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyResponse >& response) override;

    /**
    * Member function overridden from GeniviAmCallBackIf
    *
    * @param[in]
    * @param[out]
    * @param[inout]
    *
    * @return void
    */
    virtual void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, 
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedError >& error) override;

    /**
    * Member function overridden from GeniviAmCallBackIf
    *
    * @param[in]
    * @param[out]
    * @param[inout]
    *
    * @return void
    */
    virtual void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy, 
        const ::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignal >& signal) override;

private:
    GeniviAmWrapper* _geniviAmWrapper;
};

}   //pmaudiomanager

#endif  //GeniviAmCallBackIf_h