/**
 * @file IAudioPlayer.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details Interface file for Audio player
 *
 * @ingroup PmAudioManager
 */

#ifndef IAudioPlayer_h
#define IAudioPlayer_h

#include "PmAudioManagerIfTypes.h"
#include "AudioPlayerTypes.h"

namespace pmaudiomanager {

class IAudioPlayer
{
public:
   /**
    * Constructor of IAudioPlayer class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * return
    */
   IAudioPlayer(){}

   /**
    * Destructor of IAudioPlayer class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * return
    */
   virtual ~IAudioPlayer(){}

   /**
    * This method is used to play the given audio file
    *
    * @param[in] filePath: audio file path
    * @param[in] playCount: play count
    *            Possible values: FF = Continuous play, 01 - FE - play count
    * @param[out]
    * @param[in,out]
    *
    * @return AmResultCode
    */
   virtual AmResultCode playAudioFileRequest(IN const FilePath& filePath, IN const PlayCount playCount = PLAY_COUNT_DEFAULT) = 0;

   /**
    * This method is used to stop the play back which is in progress
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return AmResultCode
    */
   virtual AmResultCode stopPlaybackRequest() = 0;

   /**
    * This method is used to set the ALSA device
    *
    * @param[in] sink: audio sink
    * @param[in] source: audio source
    * @param[in] toneType : Type of tone
    * @param[out]
    * @param[in,out]
    *
    * @return AmResultCode
    */
   virtual AmResultCode setAlsaDeviceRequest(IN const AudioSink& sink, IN const AudioSource& source,
   IN const ToneType toneType) = 0;

}; // class IAudioPlayer

} // namespace pmaudiomanager

#endif //IAudioPlayer_h
