/**
 * @file AmIfMessage.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the AmIfMessage class method
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the Base implementation for all request and response
 *          messages in PmAudioManager
 *
 * @ingroup PmAudioManager
 */

#include "AmIfMessage.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AmIfMessage.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_AUDIO_MANAGER
#endif
#endif

namespace pmaudiomanager
{

void swap(AmIfMessage& first, AmIfMessage& second)
{
   using std::swap;

   swap(first._messageId, second._messageId);
   swap(first._amSessionId, second._amSessionId);
}

AmIfMessage::AmIfMessage(IN const AmIfMsgId messageId, IN const AmSessionId amSessionId) :
      _messageId(messageId), _amSessionId(amSessionId)
{
   ETG_TRACE_USR4(("AmIfMessage: [0x%p] being created", (void*) this));
}

AmIfMessage::AmIfMessage(IN const AmIfMessage& other) :
      _messageId(other._messageId), _amSessionId(other._amSessionId)
{
   ETG_TRACE_USR4(("AmIfMessage: [0x%p] being copy-created", (void*) this));
}

AmIfMessage::~AmIfMessage()
{
   ETG_TRACE_USR4(("~AmIfMessage: [0x%p] being destroyed", (void*) this));
}

//lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
AmIfMessage& AmIfMessage::operator=(AmIfMessage other)
{
   swap(*this, other);

   return *this;
}

bool AmIfMessage::operator==(const AmIfMessage& rhs) const
{
   return ((this->_messageId == rhs._messageId)
         && (this->_amSessionId == rhs._amSessionId));
}

void AmIfMessage::traceMessage(void) const
{
   ETG_TRACE_USR4(("traceMessage: [0x%p] AmIfMsgId = %u, AmSessionId = %d", (const void*) this,
         ETG_CENUM(AmIfMsgId, _messageId), _amSessionId));
}

}
