/**
 * @file AmIfMessageResult.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AmIfMessageResult
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @detailss
 *
 * @ingroup PmAudioManager
 */

#ifndef AmIfMessageResult_h
#define AmIfMessageResult_h

#include "AmIfMessage.h"
#include "ArlTypes.h"
#include "EcnrTypes.h"
#include "GeniviAmTypes.h"
#include "AudioPlayerTypes.h"
#include "LoopbackData.h"

/**
 * Note:
 * Function headers are not added to avoid large file length
 */

namespace pmaudiomanager
{
   class AmIfMessageResult : public AmIfMessage
   {
   public:

      friend void swap(AmIfMessageResult& first, AmIfMessageResult& second);

      explicit AmIfMessageResult(IN const AmIfMsgId messageId, IN const AmSessionId amSessionId,
            IN const AmResult& amResult);

      AmIfMessageResult(IN const AmIfMessageResult& other);

      virtual ~AmIfMessageResult();

      AmIfMessageResult& operator=(AmIfMessageResult other);

      bool operator==(const AmIfMessageResult& rhs) const;

      inline void setAmResult(IN const AmResult& amResult)
      {
         _amResult = amResult;
      }

      inline const AmResult getAmResult(void) const
      {
         return _amResult;
      }

      virtual void traceMessage(void) const override;

   private:
      AmResult  _amResult;  /**< Instance of AmResult */
   };

   class AmIfMessage_EcnrInitializeResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_EcnrInitializeResult& first, AmIfMessage_EcnrInitializeResult& second);

      explicit AmIfMessage_EcnrInitializeResult();

      explicit AmIfMessage_EcnrInitializeResult(IN const AmSessionId amSessionId, IN const AmResult& amResult);

      AmIfMessage_EcnrInitializeResult(IN const AmIfMessage_EcnrInitializeResult& other);

      virtual ~AmIfMessage_EcnrInitializeResult();

      AmIfMessage_EcnrInitializeResult& operator=(AmIfMessage_EcnrInitializeResult other);

      bool operator==(const AmIfMessage_EcnrInitializeResult& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_EcnrDestroyResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_EcnrDestroyResult& first, AmIfMessage_EcnrDestroyResult& second);

      explicit AmIfMessage_EcnrDestroyResult();

      explicit AmIfMessage_EcnrDestroyResult(IN const AmSessionId amSessionId, IN const AmResult& amResult);

      AmIfMessage_EcnrDestroyResult(IN const AmIfMessage_EcnrDestroyResult& other);

      virtual ~AmIfMessage_EcnrDestroyResult();

      AmIfMessage_EcnrDestroyResult& operator=(AmIfMessage_EcnrDestroyResult other);

      bool operator==(const AmIfMessage_EcnrDestroyResult& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_EcnrSetConfigurationResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_EcnrSetConfigurationResult& first, AmIfMessage_EcnrSetConfigurationResult& second);

      explicit AmIfMessage_EcnrSetConfigurationResult();

      explicit AmIfMessage_EcnrSetConfigurationResult(IN const AmSessionId amSessionId, IN const AmResult& amResult);

      AmIfMessage_EcnrSetConfigurationResult(IN const AmIfMessage_EcnrSetConfigurationResult& other);

      virtual ~AmIfMessage_EcnrSetConfigurationResult();

      AmIfMessage_EcnrSetConfigurationResult& operator=(AmIfMessage_EcnrSetConfigurationResult other);

      bool operator==(const AmIfMessage_EcnrSetConfigurationResult& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_EcnrSetSendMuteSwitchResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_EcnrSetSendMuteSwitchResult& first,
            AmIfMessage_EcnrSetSendMuteSwitchResult& second);

      explicit AmIfMessage_EcnrSetSendMuteSwitchResult();

      explicit AmIfMessage_EcnrSetSendMuteSwitchResult(IN const AmSessionId amSessionId, IN const AmResult& amResult);

      AmIfMessage_EcnrSetSendMuteSwitchResult(IN const AmIfMessage_EcnrSetSendMuteSwitchResult& other);

      virtual ~AmIfMessage_EcnrSetSendMuteSwitchResult();

      AmIfMessage_EcnrSetSendMuteSwitchResult& operator=(AmIfMessage_EcnrSetSendMuteSwitchResult other);

      bool operator==(const AmIfMessage_EcnrSetSendMuteSwitchResult& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_EcnrStartAudioResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_EcnrStartAudioResult& first, AmIfMessage_EcnrStartAudioResult& second);

      explicit AmIfMessage_EcnrStartAudioResult();

      explicit AmIfMessage_EcnrStartAudioResult(IN const AmSessionId amSessionId, IN const AmResult& amResult);

      AmIfMessage_EcnrStartAudioResult(IN const AmIfMessage_EcnrStartAudioResult& other);

      virtual ~AmIfMessage_EcnrStartAudioResult();

      AmIfMessage_EcnrStartAudioResult& operator=(AmIfMessage_EcnrStartAudioResult other);

      bool operator==(const AmIfMessage_EcnrStartAudioResult& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_EcnrStopAudioResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_EcnrStopAudioResult& first, AmIfMessage_EcnrStopAudioResult& second);

      explicit AmIfMessage_EcnrStopAudioResult();

      explicit AmIfMessage_EcnrStopAudioResult(IN const AmSessionId amSessionId, IN const AmResult& amResult);

      AmIfMessage_EcnrStopAudioResult(IN const AmIfMessage_EcnrStopAudioResult& other);

      virtual ~AmIfMessage_EcnrStopAudioResult();

      AmIfMessage_EcnrStopAudioResult& operator=(AmIfMessage_EcnrStopAudioResult other);

      bool operator==(const AmIfMessage_EcnrStopAudioResult& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_EcnrGetVersionResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_EcnrGetVersionResult& first, AmIfMessage_EcnrGetVersionResult& second);

      explicit AmIfMessage_EcnrGetVersionResult();

      explicit AmIfMessage_EcnrGetVersionResult(IN const AmSessionId amSessionId, IN const AmResult& amResult,
            IN const Version& version, IN const VersionComment& versionComment, IN const VersionNumber& versionNumber);

      AmIfMessage_EcnrGetVersionResult(IN const AmIfMessage_EcnrGetVersionResult& other);

      virtual ~AmIfMessage_EcnrGetVersionResult();

      AmIfMessage_EcnrGetVersionResult& operator=(AmIfMessage_EcnrGetVersionResult other);

      bool operator==(const AmIfMessage_EcnrGetVersionResult& rhs) const;

      inline void setVersion(IN const Version& version)
      {
         _version = version;
      }

      inline const Version& getVersion(void) const
      {
         return _version;
      }

      inline void setVersionComment(IN const VersionComment& versionComment)
      {
         _versionComment = versionComment;
      }

      inline const VersionComment& getVersionComment(void) const
      {
         return _versionComment;
      }

      inline void setVersionNumber(IN const VersionNumber& versionNumber)
      {
         _versionNumber = versionNumber;
      }

      inline const VersionNumber& getVersionNumber(void) const
      {
         return _versionNumber;
      }

      virtual void traceMessage(void) const override;

   private:
      Version        _version;        /**< Version */
      VersionComment _versionComment; /**< Verison Comment */
      VersionNumber  _versionNumber;  /**< Version Number */
   };

   class AmIfMessage_RequestAudioRouteResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_RequestAudioRouteResult& first, AmIfMessage_RequestAudioRouteResult& second);

      explicit AmIfMessage_RequestAudioRouteResult();

      explicit AmIfMessage_RequestAudioRouteResult(IN const AmSessionId amSessionId,
            IN const AmResult& amResult, IN const AudioChannel audioChannel,
            IN const AudioDeviceList& audioSink, IN const AudioDeviceList& audioSource);

      AmIfMessage_RequestAudioRouteResult(IN const AmIfMessage_RequestAudioRouteResult& other);

      virtual ~AmIfMessage_RequestAudioRouteResult();

      AmIfMessage_RequestAudioRouteResult& operator=(AmIfMessage_RequestAudioRouteResult other);

      bool operator==(const AmIfMessage_RequestAudioRouteResult& rhs) const;

      inline void setAudioChannel(IN const AudioChannel audioChannel)
      {
         _audioChannel = audioChannel;
      }

      inline AudioChannel getAudioChannel(void) const
      {
         return _audioChannel;
      }

      inline void setAudioSink(IN const AudioDeviceList& audioSink)
      {
         _audioSink = audioSink;
      }

      inline const AudioDeviceList getAudioSink(void) const
      {
         return _audioSink;
      }

      inline void setAudioSource(IN const AudioDeviceList& audioSource)
      {
         _audioSource = audioSource;
      }

      inline const AudioDeviceList getAudioSource(void) const
      {
         return _audioSource;
      }

      virtual void traceMessage(void) const override;

   private:
      AudioChannel    _audioChannel; /**< Audio Channel */
      AudioDeviceList _audioSink;    /**< Audio Sink */
      AudioDeviceList _audioSource;  /**< Audio Source */
   };

   class AmIfMessage_ReleaseAudioRouteResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_ReleaseAudioRouteResult& first, AmIfMessage_ReleaseAudioRouteResult& second);

      explicit AmIfMessage_ReleaseAudioRouteResult();

      explicit AmIfMessage_ReleaseAudioRouteResult(IN const AmSessionId amSessionId, IN const AmResult& amResult,
            IN const AudioChannel audioChannel);

      AmIfMessage_ReleaseAudioRouteResult(IN const AmIfMessage_ReleaseAudioRouteResult& other);

      virtual ~AmIfMessage_ReleaseAudioRouteResult();

      AmIfMessage_ReleaseAudioRouteResult& operator=(AmIfMessage_ReleaseAudioRouteResult other);

      bool operator==(const AmIfMessage_ReleaseAudioRouteResult& rhs) const;

      inline void setAudioChannel(IN const AudioChannel audioChannel)
      {
         _audioChannel = audioChannel;
      }

      inline AudioChannel getAudioChannel(void) const
      {
         return _audioChannel;
      }

      virtual void traceMessage(void) const override;

   private:
      AudioChannel _audioChannel;  /**< Audio Channel */
   };

   class AmIfMessage_SourceActivityResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_SourceActivityResult& first, AmIfMessage_SourceActivityResult& second);

      explicit AmIfMessage_SourceActivityResult();

      explicit AmIfMessage_SourceActivityResult(IN const AmSessionId amSessionId, IN const AudioChannel audioChannel,
            IN const SubSource subSource, IN const SrcActivity srcActivity);

      AmIfMessage_SourceActivityResult(IN const AmIfMessage_SourceActivityResult& other);

      virtual ~AmIfMessage_SourceActivityResult();

      AmIfMessage_SourceActivityResult& operator=(AmIfMessage_SourceActivityResult other);

      bool operator==(const AmIfMessage_SourceActivityResult& rhs) const;

      inline void setAudioChannel(IN const AudioChannel audioChannel)
      {
         _audioChannel = audioChannel;
      }

      inline AudioChannel getAudioChannel(void) const
      {
         return _audioChannel;
      }

      inline void setSubSource(IN const SubSource subSource)
      {
         _subSource = subSource;
      }

      inline SubSource getSubSource(void) const
      {
         return _subSource;
      }

      inline void setSrcActivity(IN const SrcActivity srcActivity)
      {
         _srcActivity = srcActivity;
      }

      inline SrcActivity getSrcActivity(void) const
      {
         return _srcActivity;
      }

      virtual void traceMessage(void) const override;

   private:
      AudioChannel _audioChannel;  /**< Audio Channel */
      SubSource    _subSource;     /**< SubSource */
      SrcActivity  _srcActivity;   /**< Source Activity */
   };

   class AmIfMessage_RequestMuteActionResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_RequestMuteActionResult& first, AmIfMessage_RequestMuteActionResult& second);

      explicit AmIfMessage_RequestMuteActionResult();

      explicit AmIfMessage_RequestMuteActionResult(IN const AmResult& amResult, IN const AudioChannel audioChannel,
            IN const MuteState muteState);

      AmIfMessage_RequestMuteActionResult(IN const AmIfMessage_RequestMuteActionResult& other);

      virtual ~AmIfMessage_RequestMuteActionResult();

      AmIfMessage_RequestMuteActionResult& operator=(AmIfMessage_RequestMuteActionResult other);

      bool operator==(const AmIfMessage_RequestMuteActionResult& rhs) const;

      inline void setAudioChannel(IN const AudioChannel audioChannel)
      {
         _audioChannel = audioChannel;
      }

      inline AudioChannel getAudioChannel(void) const
      {
         return _audioChannel;
      }

      inline void setMuteState(IN const MuteState muteState)
      {
         _muteState = muteState;
      }

      inline MuteState getMuteState(void) const
      {
         return _muteState;
      }

      virtual void traceMessage(void) const override;

   private:
      AudioChannel _audioChannel;  /**< Audio Channel */
      MuteState    _muteState;     /**< Mute State */
   };

   class AmIfMessage_PlaybackStatus final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_PlaybackStatus& first, AmIfMessage_PlaybackStatus& second);

      explicit AmIfMessage_PlaybackStatus();

      explicit AmIfMessage_PlaybackStatus(IN const AmSessionId amSessionId, IN const AmResult& amResult,
            IN const PlayStatus playStatus, IN const ToneType toneType);

      AmIfMessage_PlaybackStatus(IN const AmIfMessage_PlaybackStatus& other);

      virtual ~AmIfMessage_PlaybackStatus();

      AmIfMessage_PlaybackStatus& operator=(AmIfMessage_PlaybackStatus other);

      bool operator==(const AmIfMessage_PlaybackStatus& rhs) const;

      inline void setPlayStatus(IN const PlayStatus playStatus)
      {
         _playStatus = playStatus;
      }

      inline PlayStatus getPlayStatus(void) const
      {
         return _playStatus;
      }

      inline void setToneType(IN const ToneType toneType)
      {
         _toneType = toneType;
      }

      inline ToneType getToneType(void) const
      {
         return _toneType;
      }

      virtual void traceMessage(void) const override;

   private:
      PlayStatus _playStatus; /**< Audio Play Status */
      ToneType _toneType; /**< Specifies Tone type */
   };

   class AmLoopbackMessage_PlaybackStatus final : public com::bosch::pmcommon::LoopbackData
   {
   public:

      friend void swap(AmLoopbackMessage_PlaybackStatus& first, AmLoopbackMessage_PlaybackStatus& second);

      explicit AmLoopbackMessage_PlaybackStatus();

      explicit AmLoopbackMessage_PlaybackStatus(IN const com::bosch::pmcommon::PmSubComponentId subComponentId,
            IN const AmSessionId amSessionId, IN const AmResult& amResult, IN const PlayStatus playStatus,
            IN const ToneType toneType);

      AmLoopbackMessage_PlaybackStatus(IN const AmLoopbackMessage_PlaybackStatus& other);

      virtual ~AmLoopbackMessage_PlaybackStatus();

      AmLoopbackMessage_PlaybackStatus& operator=(AmLoopbackMessage_PlaybackStatus other);

      bool operator==(const AmLoopbackMessage_PlaybackStatus& rhs) const;

      const AmIfMessage_PlaybackStatus& getPlaybackStatusMsg()
      {
         return _playbackStatusMsg;
      }

      virtual void traceMessage(void) const override;

   private:
      AmIfMessage_PlaybackStatus _playbackStatusMsg;
   };

   class AmIfMessage_GetListMainSinkSoundPropertiesResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_GetListMainSinkSoundPropertiesResult& first, AmIfMessage_GetListMainSinkSoundPropertiesResult& second);

      explicit AmIfMessage_GetListMainSinkSoundPropertiesResult();

      explicit AmIfMessage_GetListMainSinkSoundPropertiesResult(IN const AmSessionId amSessionId, IN const AmResult& amResult);

      AmIfMessage_GetListMainSinkSoundPropertiesResult(IN const AmIfMessage_GetListMainSinkSoundPropertiesResult& other);

      virtual ~AmIfMessage_GetListMainSinkSoundPropertiesResult();

      AmIfMessage_GetListMainSinkSoundPropertiesResult& operator=(AmIfMessage_GetListMainSinkSoundPropertiesResult other);

      bool operator==(const AmIfMessage_GetListMainSinkSoundPropertiesResult& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_SetMainSinkSoundPropertyResult final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_SetMainSinkSoundPropertyResult& first, AmIfMessage_SetMainSinkSoundPropertyResult& second);

      explicit AmIfMessage_SetMainSinkSoundPropertyResult();

      explicit AmIfMessage_SetMainSinkSoundPropertyResult(IN const AmSessionId amSessionId, IN const AmResult& amResult);

      AmIfMessage_SetMainSinkSoundPropertyResult(IN const AmIfMessage_SetMainSinkSoundPropertyResult& other);

      virtual ~AmIfMessage_SetMainSinkSoundPropertyResult();

      AmIfMessage_SetMainSinkSoundPropertyResult& operator=(AmIfMessage_SetMainSinkSoundPropertyResult other);

      bool operator==(const AmIfMessage_SetMainSinkSoundPropertyResult& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_UpdateAudioSinkVolumeList final : public AmIfMessageResult
   {
   public:

      friend void swap(AmIfMessage_UpdateAudioSinkVolumeList& first, AmIfMessage_UpdateAudioSinkVolumeList& second);

      explicit AmIfMessage_UpdateAudioSinkVolumeList();

      explicit AmIfMessage_UpdateAudioSinkVolumeList(IN const AmSessionId amSessionId, IN const AmResult& amResult,
            IN const GeniviAMSinkId& sinkId, IN const AmPropertyType2VolumeMap& propertymap);

      AmIfMessage_UpdateAudioSinkVolumeList(IN const AmIfMessage_UpdateAudioSinkVolumeList& other);

      virtual ~AmIfMessage_UpdateAudioSinkVolumeList();

      AmIfMessage_UpdateAudioSinkVolumeList& operator=(AmIfMessage_UpdateAudioSinkVolumeList other);

      bool operator==(const AmIfMessage_UpdateAudioSinkVolumeList& rhs) const;

      inline void setSinkId(IN const GeniviAMSinkId& sinkId)
      {
         _sinkId = sinkId;
      }

      inline const GeniviAMSinkId& getSinkId(void) const
      {
         return _sinkId;
      }

      inline const AmPropertyType2VolumeMap& getPropertyMap(void) const
      {
         return _propertyMap;
      }

      inline void setPropertyMap(IN const AmPropertyType2VolumeMap& propertyMap)
      {
         _propertyMap = propertyMap;
      }

      virtual void traceMessage(void) const override;

   private:
      GeniviAMSinkId             _sinkId;       /**< Sink Id */
      AmPropertyType2VolumeMap   _propertyMap;  /**< Property Type -> Volume */
   };

} // namespace pmaudiomanager

#endif // AmIfMessageResult_h
