/**
 * @file AmIfMessageRequest.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the AmIfMessageRequest
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @detailss
 *
 * @ingroup PmAudioManager
 */

#ifndef AmIfMessageRequest_h
#define AmIfMessageRequest_h

#include "AmIfMessage.h"
#include "GeniviAmTypes.h"

/**
 * Note:
 * Function headers are not added to avoid large file length
 */

namespace pmaudiomanager
{
   class AmIfMessageRequest : public AmIfMessage
   {
   public:

      friend void swap(AmIfMessageRequest& first, AmIfMessageRequest& second);

      explicit AmIfMessageRequest(IN const AmIfMsgId messageId, IN const AmSessionId amSessionId);

      AmIfMessageRequest(IN const AmIfMessageRequest& other);

      virtual ~AmIfMessageRequest();

      AmIfMessageRequest& operator=(AmIfMessageRequest other);

      bool operator==(const AmIfMessageRequest& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_PrepareAudioRouteRequest final : public AmIfMessageRequest
   {
   public:

      friend void swap(AmIfMessage_PrepareAudioRouteRequest& first, AmIfMessage_PrepareAudioRouteRequest& second);

      explicit AmIfMessage_PrepareAudioRouteRequest();

      explicit AmIfMessage_PrepareAudioRouteRequest(IN const AmSessionId amSessionId,
            IN const AudioChannel audioChannelId);

      AmIfMessage_PrepareAudioRouteRequest(IN const AmIfMessage_PrepareAudioRouteRequest& other);

      virtual ~AmIfMessage_PrepareAudioRouteRequest();

      AmIfMessage_PrepareAudioRouteRequest& operator=(AmIfMessage_PrepareAudioRouteRequest other);

      bool operator==(const AmIfMessage_PrepareAudioRouteRequest& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setAudioChannel(IN const AudioChannel audioChannelId)
      {
         _audioChannelId = audioChannelId;
      }

      inline AudioChannel getAudioChannel(void) const
      {
         return _audioChannelId;
      }

   private:
      AudioChannel  _audioChannelId;  /**< Audio Channel Id */
   };

   class AmIfMessage_PlayAudioFileRequest final : public AmIfMessageRequest
   {
   public:

      friend void swap(AmIfMessage_PlayAudioFileRequest& first, AmIfMessage_PlayAudioFileRequest& second);

      explicit AmIfMessage_PlayAudioFileRequest();

      explicit AmIfMessage_PlayAudioFileRequest(IN const AmSessionId amSessionId,
            IN const FilePath& filePath, IN const PlayCount playCount, IN const ToneType toneType);

      AmIfMessage_PlayAudioFileRequest(IN const AmIfMessage_PlayAudioFileRequest& other);

      virtual ~AmIfMessage_PlayAudioFileRequest();

      AmIfMessage_PlayAudioFileRequest& operator=(AmIfMessage_PlayAudioFileRequest other);

      bool operator==(const AmIfMessage_PlayAudioFileRequest& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setFilePath(IN const FilePath& filePath)
      {
         _filePath = filePath;
      }

      inline const FilePath& getFilePath(void) const
      {
         return _filePath;
      }

      inline void setPlayCount(IN const PlayCount playCount)
      {
         _playCount = playCount;
      }

      inline PlayCount getPlayCount(void) const
      {
         return _playCount;
      }

      inline void setToneType(IN const ToneType toneType)
      {
         _toneType = toneType;
      }

      inline ToneType getToneType(void) const
      {
         return _toneType;
      }

   private:
      FilePath   _filePath;  /**< File Path */
      PlayCount  _playCount; /**< Play Count */
      ToneType _toneType; /**< Specifies Tone type */
   };

   class AmIfMessage_PlayHfAudioRequest final : public AmIfMessageRequest
   {
   public:

      friend void swap(AmIfMessage_PlayHfAudioRequest& first, AmIfMessage_PlayHfAudioRequest& second);

      explicit AmIfMessage_PlayHfAudioRequest();

      explicit AmIfMessage_PlayHfAudioRequest(IN const AmSessionId amSessionId, IN const SamplingType samplingType);

      AmIfMessage_PlayHfAudioRequest(IN const AmIfMessage_PlayHfAudioRequest& other);

      virtual ~AmIfMessage_PlayHfAudioRequest();

      AmIfMessage_PlayHfAudioRequest& operator=(AmIfMessage_PlayHfAudioRequest other);

      bool operator==(const AmIfMessage_PlayHfAudioRequest& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setSamplingType(IN const SamplingType samplingType)
      {
         _samplingType = samplingType;
      }

      inline SamplingType getSamplingType(void) const
      {
         return _samplingType;
      }

   private:
      SamplingType   _samplingType;  /**< Sampling Type */
   };

   class AmIfMessage_StopAudioRequest final : public AmIfMessageRequest
   {
   public:

      friend void swap(AmIfMessage_StopAudioRequest& first, AmIfMessage_StopAudioRequest& second);

      explicit AmIfMessage_StopAudioRequest();

      explicit AmIfMessage_StopAudioRequest(IN const AmSessionId amSessionId);

      AmIfMessage_StopAudioRequest(IN const AmIfMessage_StopAudioRequest& other);

      virtual ~AmIfMessage_StopAudioRequest();

      AmIfMessage_StopAudioRequest& operator=(AmIfMessage_StopAudioRequest other);

      bool operator==(const AmIfMessage_StopAudioRequest& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_PauseAudioRequest final : public AmIfMessageRequest
   {
   public:

      friend void swap(AmIfMessage_PauseAudioRequest& first, AmIfMessage_PauseAudioRequest& second);

      explicit AmIfMessage_PauseAudioRequest();

      explicit AmIfMessage_PauseAudioRequest(IN const AmSessionId amSessionId);

      AmIfMessage_PauseAudioRequest(IN const AmIfMessage_PauseAudioRequest& other);

      virtual ~AmIfMessage_PauseAudioRequest();

      AmIfMessage_PauseAudioRequest& operator=(AmIfMessage_PauseAudioRequest other);

      bool operator==(const AmIfMessage_PauseAudioRequest& rhs) const;

      virtual void traceMessage(void) const override;
   };

   class AmIfMessage_SetMicMuteStateRequest final : public AmIfMessageRequest
   {
   public:

      friend void swap(AmIfMessage_SetMicMuteStateRequest& first, AmIfMessage_SetMicMuteStateRequest& second);

      explicit AmIfMessage_SetMicMuteStateRequest();

      explicit AmIfMessage_SetMicMuteStateRequest(IN const MuteState muteState);

      AmIfMessage_SetMicMuteStateRequest(IN const AmIfMessage_SetMicMuteStateRequest& other);

      virtual ~AmIfMessage_SetMicMuteStateRequest();

      AmIfMessage_SetMicMuteStateRequest& operator=(AmIfMessage_SetMicMuteStateRequest other);

      bool operator==(const AmIfMessage_SetMicMuteStateRequest& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setMuteState(IN const MuteState muteState)
      {
         _muteState = muteState;
      }

      inline MuteState getMuteState(void) const
      {
         return _muteState;
      }

   private:
      MuteState   _muteState;  /**< Mute State */
   };

   class AmIfMessage_GetAudioSinkVolumeRequest final : public AmIfMessageRequest
   {
      public:

         friend void swap(AmIfMessage_GetAudioSinkVolumeRequest& first, AmIfMessage_GetAudioSinkVolumeRequest& second);

         explicit AmIfMessage_GetAudioSinkVolumeRequest();

         explicit AmIfMessage_GetAudioSinkVolumeRequest(IN const AmSessionId amSessionId, IN const GeniviAMSinkId sinkId);

         AmIfMessage_GetAudioSinkVolumeRequest(IN const AmIfMessage_GetAudioSinkVolumeRequest& other);

         virtual ~AmIfMessage_GetAudioSinkVolumeRequest();

         AmIfMessage_GetAudioSinkVolumeRequest& operator=(AmIfMessage_GetAudioSinkVolumeRequest other);

         bool operator==(const AmIfMessage_GetAudioSinkVolumeRequest& rhs) const;

         virtual void traceMessage(void) const override;

         inline void setSinkId(IN const GeniviAMSinkId sinkId)
         {
            _sinkId = sinkId;
         }

         inline GeniviAMSinkId getSinkId(void) const
         {
            return _sinkId;
         }

      private:
         GeniviAMSinkId   _sinkId;  /**< Sink Id */
      };

      class AmIfMessage_SetAudioSinkVolumeRequest final : public AmIfMessageRequest
      {
      public:

         friend void swap(AmIfMessage_SetAudioSinkVolumeRequest& first, AmIfMessage_SetAudioSinkVolumeRequest& second);

         explicit AmIfMessage_SetAudioSinkVolumeRequest();

         explicit AmIfMessage_SetAudioSinkVolumeRequest(IN const AmSessionId amSessionId, IN const GeniviAMSinkId sinkId, IN const AmPropertyType2VolumeMap propertyValue);

         AmIfMessage_SetAudioSinkVolumeRequest(IN const AmIfMessage_SetAudioSinkVolumeRequest& other);

         virtual ~AmIfMessage_SetAudioSinkVolumeRequest();

         AmIfMessage_SetAudioSinkVolumeRequest& operator=(AmIfMessage_SetAudioSinkVolumeRequest other);

         bool operator==(const AmIfMessage_SetAudioSinkVolumeRequest& rhs) const;

         virtual void traceMessage(void) const override;

         inline void setSinkId(IN const GeniviAMSinkId sinkId)
         {
            _sinkId = sinkId;
         }

         inline GeniviAMSinkId getSinkId(void) const
         {
            return _sinkId;
         }

         inline void setProperty(IN const AmPropertyType2VolumeMap propertyValue)
         {
            _propertyValue = propertyValue;
         }

         inline AmPropertyType2VolumeMap getProperty(void) const
         {
            return _propertyValue;
         }

      private:
         GeniviAMSinkId             _sinkId;          /**< Sink Id */
         AmPropertyType2VolumeMap   _propertyValue;   /**< Property Value */
      };

} //namespace pmaudiomanager

#endif // AmIfMessageRequest_h
