/*
 * Utils.cpp
 *
 *  Created on: Feb 14, 2013
 *      Author:
 */

#include <time.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <string>

/*lint -save -e1773 */

int usleep (__useconds_t __useconds)
{
    struct timespec req,rem;

    req.tv_sec = __useconds/1000000;
    req.tv_nsec= (__useconds%1000000)*1000;

    while(1)
    {
        if(nanosleep(&req,&rem) != -1)
            break;
        //sleep is terminated
        //resume the sleep for remaining period
        req.tv_sec = rem.tv_sec;
        req.tv_nsec= rem.tv_nsec;
    }

    return 0;
}
unsigned int sleep (unsigned int __seconds)
{
    struct timespec req,rem;

    req.tv_sec = __seconds;
    req.tv_nsec= 0;

    while(1)
    {
        if(nanosleep(&req,&rem) != -1)
            break;
        //sleep is terminated
        //resume the sleep for remaining period
        req.tv_sec = rem.tv_sec;
        req.tv_nsec= rem.tv_nsec;
    }

    return 0;
}

// 20170112: section disabled because disabled in MP too
#if 0
#ifndef TARGET_BUILD_GEN3
void *memcpy(void *dest, const void *src, size_t n) throw()
{
    /*
     * this function replaces memcpy for that case the regions overlapping. Even the stl uses memcpy to
     * copy overlapping regions. Duma reports that. Also DBUS lib and totem pl parser.
     * I wanted to eliminate this risk at all, Thömel.
     */
    return __builtin_memmove(dest, src, n);
}
#endif

void *__builtin_memmove(void *dst, const void *src, size_t len)
{
    /*
     * this function replaces __builtin_memmove. This is because the stl uses __builtin_memmove and the original implementation
     * switches back to memcpy in some cases. But duma complains overlapping memory regions in memcpy.
     * I wanted to eliminate this risk at all, Thömel.
     */
    size_t i;
    int reverse = 1;

    /*
     * if destination pointer is less than source pointer: reverse the copy direction:
     */
    if ( dst < src) {
        reverse = 0;
    }

    /* is it possible to copy whole words? */
    if ( (unsigned long)dst % (unsigned long)sizeof(long) == 0 &&  (unsigned long)src % (unsigned long)sizeof(long) == 0 && len % sizeof(long) == 0) {

        long *d = (long *) dst;
        const long *s = (const long *) src;

        if (reverse) {
            for (i = len / sizeof(long); i > 0; i--) {
                d[i - 1] = s[i - 1];
            }
        } else {
            for (i = 1; i <= len / sizeof(long); i++) {
                d[i - 1] = s[i - 1];
            }
        }

    } else { // copy bytes:

        char *d = (char *) dst;
        const char *s = (const char *) src;

        if (reverse) {
            for (i = len; i > 0; i--) {
                d[i - 1] = s[i - 1];
            }
        } else {
            for (i = 1; i <= len; i++) {
                d[i - 1] = s[i - 1];
            }
        }
    }

    return dst;
}
#endif

char *lltoa(long long value, char *c, int base)
{
	const char *letters = (char *)"0123456789abcdef";
	long long _value = value;

	if (_value == 0) {
		*c++ = '0';
		return c;
	}

	if (value < 0) {
		_value = -value;
		*c++ = '-';
	}

	int i;
	char buf[128];
	char *cb = buf+(sizeof(buf)-1);
	*cb = 0;

	// Translating number to string with base:
	for (i=127; _value && i ; --i) {
		cb--;
		*cb = letters[_value % base];
		_value /= base;
	}

	strcpy(c, cb);
	while(*c) c++;
	return c;
}

char *ulltoa(unsigned long long value, char *c, int base)
{
	const char *letters = (char *)"0123456789abcdef";

	if (value == 0) {
		*c++ = '0';
		return c;
	}

	int i;
	char buf[128];
	char *cb = buf+(sizeof(buf)-1);
	*cb = 0;

	// Translating number to string with base:
	for (i=127; value && i ; --i) {
		cb--;
		*cb = letters[value % (unsigned long long)base];
		value /= base;
	}

	strcpy(c, cb);
	while(*c) c++;
	return c;
}

char *itoa(int value, char *c, int base)
{
	return lltoa((long long)value, c, base);
}

int toUtf8Fake(char *outBuffer, const size_t outBufferLen, const char *inBuffer)
{
    const char *cIn = inBuffer;
    unsigned char *cOut = (unsigned char *)outBuffer;
    size_t cCount = outBufferLen - 2;

    /* loop over input buffer */
    while(*cIn && cCount) {

        /* is character value bigger than 6 bits? */
        if (*cIn & 0x80) {

            /* convert to 2 byte utf8 */
            *cOut++ = (unsigned char)(0xc0 | (*cIn   >> 6));
            *cOut++ = (unsigned char)(0x80 | (*cIn++ &  0x3f));
            cCount-=2;

        /* no conversion: just take the character */
        } else {
            *cOut++ = *cIn++;
            cCount--;
        }
    }

    *cOut = 0;

    return (cCount ? 0 : 1);
}

int fromUtf8Fake(char *outBuffer, const size_t outBufferLen, const char *inBuffer)
{
    const char *cIn = inBuffer;
    unsigned char *cOut = (unsigned char *)outBuffer;
    size_t cCount = outBufferLen - 2;

    /* loop over input buffer */
    while(*cIn && cCount) {

        /* is character value bigger than 6 bits? */
        if (*cIn & 0x80) {

            /* convert to ascii */
            *cOut = (unsigned char)(*cIn++ << 6);
            *cOut = (unsigned char)(*cOut | (*cIn++ & 0x3f));
            (void)*cOut++;

        /* no conversion: just take the character */
        } else {
            *cOut++ = *cIn++;
            cCount--;
        }
    }

    *cOut = 0;

    return (cCount ? 0 : 1);
}


char *strncat_r(char *dest, const char *src, size_t sizeOfDest)
{
   if(0 == dest)
   {
      return dest;
   }

   if(0 == src)
   {
      return dest;
   }

   if(0 == sizeOfDest)
   {
      return dest;
   }

   // dest is now a valid pointer; src is now a valid pointer; sizeOfDest is greater than 0

   // sanity: empty source string
   if(0 == *src)
   {
      return dest;
   }

    int iCopy = 0;
    char *_src = (char *)src;
    char *ret = dest;
    sizeOfDest--; // les one for the trailing zero
    while(*_src && sizeOfDest) {
        if (iCopy == 0 && *dest == 0) iCopy = 1;    // end of dest string found
        if (iCopy == 1) *dest = *_src++;            // copy src to dest
        dest++;
        sizeOfDest--;
    }
    *dest = 0;
    return ret;
}

char *strncpy_r(char *dest, const char *src, size_t sizeOfDest)
{
	if(src == NULL) { //terminate dest on NULL
		dest[0] = 0;
		return dest;
	}
	dest[sizeOfDest-1] = 0; //implicit null-character termination if source is longer than sizeOfDest
	return strncpy(dest, src, sizeOfDest-1);
}

char *strupper(char *s)
{
    for(char *p = s; *p; ++p)
    {
        *p = (char)toupper(*p);
    }
    return s;
}

char *strlower(char *s)
{
    for(char *p = s; *p; ++p)
    {
        *p = (char)tolower(*p);
    }
    return s;
}

char *strtrim(char *str)
{
    size_t len = 0;
    char *frontp = str - 1;
    char *endp = NULL;

    if( str == NULL ) return NULL;

    if( str[0] == '\0' ) return str;

    len = strlen(str);
    endp = str + len;

    /* Move the front and back pointers to address the first non-whitespace characters from each end. */
    while( isspace(*(++frontp)) ) {}
    while( isspace(*(--endp)) && endp != frontp ) {}

    if( str + len - 1 != endp )
    {
        *(endp + 1) = '\0';
    }
    else if( frontp != str &&  endp == frontp )
    {
        *str = '\0';
    }

    /* Shift the string so that it starts at str so that if it's dynamically allocated, we can still free
     * it on the returned pointer. Note the reuse of endp to mean the front of the string buffer now. */
    endp = str;
    if( frontp != str )
    {
        while( *frontp ) *endp++ = *frontp++;
        *endp = '\0';
    }

    return str;
}

/* this function is copied from:
 * http://stackoverflow.com/questions/7775991/how-to-get-hexdump-of-a-structure-data
 */
#include <stdio.h>
void hexDump (FILE *fp, const char *desc, void *addr, int len) {
    int i;
    unsigned char buff[17];
    unsigned char *pc = (unsigned char*)addr;

    // Output description if given.
    if (desc != NULL)
        fprintf (fp, "%s:\n", desc);

    /* print pure string */
    fprintf (fp, "printf: %.*s\n", len, (char *)addr);

    // Process every byte in the data.
    for (i = 0; i < len; i++) {
        // Multiple of 16 means new line (with line offset).

        if ((i % 16) == 0) {
            // Just don't print ASCII for the zeroth line.
            if (i != 0)
                fprintf (fp, "  %s\n", buff);

            // Output the offset.
            fprintf (fp, "  %04x ", i);
        }

        // Now the hex code for the specific character.
        fprintf (fp, " %02x", pc[i]);

        // And store a printable ASCII character for later.
        //if ((pc[i] < 0x20) || (pc[i] > 0x7e))
        if (!isprint(pc[i]))
            buff[i % 16] = '.';
        else
            buff[i % 16] = pc[i];
        buff[(i % 16) + 1] = '\0';
    }

    // Pad out last line if not exactly 16 characters.
    while ((i % 16) != 0) {
        fprintf (fp, "   ");
        i++;
    }

    // And print the final ASCII bit.
    fprintf (fp, "  %s\n", buff);
    fflush(fp);
}

int exists(const char *fileName)
{
    FILE *fp;
    fp=fopen(fileName, "r");
    if (fp) {
        fclose(fp);
        return 1;
    }
    return 0;
}
