/*
 * TimeTrace.cpp
 *
 * implementation
 */
 
#include "TraceDefinitions.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_PERFORMANCE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/TimeTrace.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_PERFORMANCE
#endif
#endif

#include "TimeTrace.h"

TimeTrace::TimeTrace(const char *name)
{
    mName = name;
    begin();
}

TimeTrace::TimeTrace(void)
{
    mName = "time-trace";
    begin();
}

void TimeTrace::restart()
{
    begin();
}

void TimeTrace::begin()
{
	struct tm *nowtm;
	char timestring[64];

	gettimeofday(&mStartTime, NULL);
	nowtm = localtime(&mStartTime.tv_sec);
	strftime(timestring, sizeof timestring, "%Y-%m-%d %H:%M:%S", nowtm);
	ETG_TRACE_USR4 (("%128s ->Start time : %128s , %d msec %d usec", mName, timestring, (int)(mStartTime.tv_usec/1000), (int)(mStartTime.tv_usec%1000)));

}

void TimeTrace::now()
{
	struct timeval nowval;
	struct tm *nowtm;
	char timestring[64];

	gettimeofday(&nowval, NULL);
	nowtm = localtime(&nowval.tv_sec);
	strftime(timestring, sizeof timestring, "%Y-%m-%d %H:%M:%S", nowtm);
	ETG_TRACE_USR4 (("Current time : %128s , %d msec %d usec",timestring, (int)(nowval.tv_usec/1000), (int)(nowval.tv_usec%1000)));
}

void TimeTrace::time_difference(timeval* start , timeval* end ,timeval* difference)
{
	if (end->tv_usec < start->tv_usec)
    {
    	long int nsec = (start->tv_usec - end->tv_usec) / 1000000 + 1;
    	start->tv_usec -= 1000000 * nsec;
    	start->tv_sec += nsec;
	}
	if (end->tv_usec - start->tv_usec > 1000000)
	{
	    long int nsec = (end->tv_usec - start->tv_usec) / 1000000;
	    start->tv_usec += 1000000 * nsec;
	    start->tv_sec -= nsec;
	}

	difference->tv_sec = end->tv_sec - start->tv_sec;
	difference->tv_usec = end->tv_usec - start->tv_usec;
}

void TimeTrace::elapsed()
{
	struct timeval beginTime,nowTime,elapsedTime;

	beginTime = mStartTime;
	gettimeofday(&nowTime, NULL);
	time_difference	(&beginTime,&nowTime,&elapsedTime);

	char timestring[64];
	struct tm *elapsedtm;
	elapsedtm = localtime(&elapsedTime.tv_sec);
	strftime(timestring, sizeof timestring, "%Y-%m-%d %H:%M:%S", elapsedtm);
	ETG_TRACE_USR4 (("%128s-> Elpased time %d seconds , %d msec %d usec", mName, (int)elapsedTime.tv_sec, (int)(elapsedTime.tv_usec/1000), (int)(elapsedTime.tv_usec%1000)));
}
