/**
 * @file FwBoschRegistryWrapper.cpp
 *
 * @par SW-Component
 * Framework
 *
 * @brief Bosch registry handling.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Bosch registry handling. Wrapper to avoid Bosch OSAL specific includes. Wrapper shall be used in application code.
 */

#include "FwBoschRegistryWrapper.h"
#include "BoschRegistry.h"
#include "FwAssert.h"

namespace fw {

BoschRegistryWrapper::BoschRegistryWrapper()
{
   _registry = NULL;
}

BoschRegistryWrapper::~BoschRegistryWrapper()
{
   if(NULL != _registry)
   {
      delete _registry;
   }
   _registry = NULL;
}

BoschRegistryWrapper::BoschRegistryWrapper(const BoschRegistryWrapper& ref)
{
   (void)(ref);

   // DO NOT USE!!!
   FW_NORMAL_ASSERT_ALWAYS();

   _registry = NULL;
}

BoschRegistryWrapper& BoschRegistryWrapper::operator=(const BoschRegistryWrapper& ref)
{
   // DO NOT USE!!!
   FW_NORMAL_ASSERT_ALWAYS();

   if(this == &ref)
   {
      return *this;
   }

   // _registry = ref._registry;

   return *this;
}

void BoschRegistryWrapper::open(const ::std::string& registryPath)
{
   if(NULL != _registry)
   {
      // already created
      FW_NORMAL_ASSERT_ALWAYS();
      return;
   }

   _registry = new BoschRegistry();

   if(NULL == _registry)
   {
      // create failed
      FW_NORMAL_ASSERT_ALWAYS();
      return;
   }

   _registry->open(registryPath);
}

void BoschRegistryWrapper::close(void)
{
   if(NULL == _registry)
   {
      // already closed
      FW_NORMAL_ASSERT_ALWAYS();
      return;
   }

   _registry->close();

   delete _registry;
   _registry = NULL;
}

void BoschRegistryWrapper::write(const ::std::string& key, const ::std::string& value) const
{
   if(NULL == _registry)
   {
      // not opened
      FW_NORMAL_ASSERT_ALWAYS();
      return;
   }

   _registry->write(key, value);
}

bool BoschRegistryWrapper::read(::std::string& value, const ::std::string& key) const
{
   if(NULL == _registry)
   {
      // not opened
      FW_NORMAL_ASSERT_ALWAYS();
      return false;
   }

   return _registry->read(value, key);
}

} //fw
