

#include "TraceDefinitions.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_FUNCTION_TRACE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FunctionTracer.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_FUNCTION_TRACE
#endif
#endif

#include <iostream>
#include "FunctionTracer.h"

#define PREFIX "$FT$"

FunctionTracer::FunctionTracer(tClassTypeFunc cls, const char *name )
{
   mName = name;
   mTraceLevel = USER_3;
   mCls = cls;

   if (true == etg_bIsTraceActive(TR_CLASS_CONN_FRAMEWORK_FUNCTION_TRACE_ALL, (unsigned short int)TR_LEVEL_USER_3))
   {
      ETG_TRACE_USR3(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
   }
   else
   {
      ETG_TRACE_USR3_DCL ((mCls, "" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
   }
};

FunctionTracer::FunctionTracer(tClassTypeFunc cls, const char *name , int traceLevel)
{
   mName = name;
   mTraceLevel = traceLevel;
   mCls = cls;

   if (true == etg_bIsTraceActive(TR_CLASS_CONN_FRAMEWORK_FUNCTION_TRACE_ALL, (unsigned short int)traceLevel))
   {
      switch(mTraceLevel)
      {
         case USER_1:
            ETG_TRACE_USR1(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_2:
            ETG_TRACE_USR2(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_3:
            ETG_TRACE_USR3(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_4:
            ETG_TRACE_USR4(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case COMPONENT:
            ETG_TRACE_COMP(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case SYSTEM:
            ETG_TRACE_SYS(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         default:
            break;
      }
   }
   else
   {
      switch(mTraceLevel)
      {
         case USER_1:
            ETG_TRACE_USR1_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_2:
            ETG_TRACE_USR2_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_3:
            ETG_TRACE_USR3_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_4:
            ETG_TRACE_USR4_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case COMPONENT:
            ETG_TRACE_COMP_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         case SYSTEM:
            ETG_TRACE_SYS_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
            break;
         default:
            break;
      }
   }
};

FunctionTracer::~FunctionTracer()
{
   if (true == etg_bIsTraceActive(TR_CLASS_CONN_FRAMEWORK_FUNCTION_TRACE_ALL, (unsigned short int)mTraceLevel))
   {
      switch(mTraceLevel)
      {
         case USER_1:
            ETG_TRACE_USR1(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_2:
            ETG_TRACE_USR2(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_3:
            ETG_TRACE_USR3(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_4:
            ETG_TRACE_USR4(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case COMPONENT:
            ETG_TRACE_COMP(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case SYSTEM:
            ETG_TRACE_SYS(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         default:
            break;
      }
   }
   else
   {
      switch(mTraceLevel)
      {
         case USER_1:
            ETG_TRACE_USR1_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_2:
            ETG_TRACE_USR2_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_3:
            ETG_TRACE_USR3_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case USER_4:
            ETG_TRACE_USR4_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case COMPONENT:
            ETG_TRACE_COMP_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         case SYSTEM:
            ETG_TRACE_SYS_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
            break;
         default:
            break;
      }
   }
};
