/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_GENERAL
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/Dispatcher.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONN_FRAMEWORK_GENERAL
#endif
#endif

#include "FunctionTracer.h"
#include "TraceDefinitions.h"
#include "Framework_Errorcodes.h"
#include "Utils.h"

#include <string>
#include <Dispatcher.h>
#include <errno.h>

/*lint -save -e801 -e1773 */

using namespace std;

#ifdef VARIANT_S_FTR_ENABLE_FW_REMOTE_SM_MANAGER
Dispatcher::Dispatcher() : mRemoteStateMachineManager()
#else
Dispatcher::Dispatcher()
#endif
{
    mDestructionFlag = 0;
    mActiveStateMachinesLock.setNotReantrant();

#ifdef VARIANT_S_FTR_ENABLE_FW_REMOTE_SM_MANAGER
    int res;
    res = mRemoteStateMachineManager.Init();
    if (res != FW_NO_ERROR) {
        ETG_TRACE_ERR(("Dispatcher(): mRemoteStateMachineManager.Init()=%d", res));
    }
#endif
};

Dispatcher::~Dispatcher()
{
#ifdef VARIANT_S_FTR_ENABLE_FW_REMOTE_SM_MANAGER
   mActiveStateMachinesLock.lock();

    int res;
    res = mRemoteStateMachineManager.DeInit();
    if (res != FW_NO_ERROR) {
        ETG_TRACE_ERR(("~Dispatcher(): mRemoteStateMachineManager.DeInit()=%d", res));
    }

    mActiveStateMachinesLock.unlock();
#endif
}

Dispatcher& Dispatcher::GetInstance(void)
{
    static Dispatcher dispatcher;
    return dispatcher;
}

int Dispatcher::Register( const SMF* stateMachine )
{
	ENTRY_INTERNAL
	mActiveStateMachinesLock.lock();

    mActiveStateMachines.push_back((SMF*)stateMachine);

    ETG_TRACE_USR1(("stateMachine->GetSMNameFull()=%35s, position=%d", ((SMF*)stateMachine)->GetSMNameFull(), (int)mActiveStateMachines.size()-1));

    mActiveStateMachinesLock.unlock();

    return 0;
}

void Dispatcher::ForceNoDestruction()
{
	ENTRY_INTERNAL
	mDestructionFlag = 1;
}

int Dispatcher::DeRegister( const SMF* stateMachine )
{
	ENTRY_INTERNAL
    unsigned int iter;
    int ret = FW_ERR_DISP_SM_NOT_REGISTERED;

    /* TODO: work around for undefined destruction sequence between static and dynamic objects, must be solved by a clean solution */
    if (mDestructionFlag) return 0;

    mActiveStateMachinesLock.lock();

    for (iter=0; iter< mActiveStateMachines.size(); iter++)
    {
    	if(mActiveStateMachines.at(iter) == stateMachine)
        {
            ETG_TRACE_USR1(("stateMachine->GetSMNameFull()=%35s, position=%d", ((SMF*)stateMachine)->GetSMNameFull(), iter));

            mActiveStateMachines.erase(mActiveStateMachines.begin() + iter);

            ret = FW_NO_ERROR;
            break;
        }
    }

    mActiveStateMachinesLock.unlock();

    return ret;
}

int Dispatcher::DeRegisterAll( void )
{
    ENTRY

    mActiveStateMachinesLock.lock();
    mActiveStateMachines.clear();
    mActiveStateMachinesLock.unlock();

    return FW_NO_ERROR;
}

SMF* Dispatcher::GetSMHandle(const char* name)
{
	ENTRY_INTERNAL
    SMF* sm = NULL;
    unsigned int iter;

    for(iter=0; iter < mActiveStateMachines.size(); iter++)
    {
    	// debug printf("mActiveStateMachines[iter]->GetSMNameFull()=%s\n", mActiveStateMachines[iter]->GetSMNameFull());
        if(!strncmp(mActiveStateMachines[iter]->GetSMNameFull(),name, strlen(name)))
        {
            sm = mActiveStateMachines[iter];
            break;
        }
    }

    return sm;
}

int Dispatcher::SendMessageAnswerInternal(const char *message ,const char *answer, const int localOnly)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_REMOTE_SM_MANAGER
#else
    (void)(localOnly);
#endif

    FW_IF_NULL_PTR_RETURN_ERROR(message, FW_ERR_DISP_GEN_ERROR);

	ENTRY_INTERNAL
	SMF* smObject;
    char *smMessage = NULL;
    char *msgParams = NULL;
    int ret = FW_ERR_DISP_GEN_ERROR;

    mActiveStateMachinesLock.lock();

    /* split the message into SM object name and message name and parameters*/
    string str (message);
    size_t messagePos = str.find("::");	 /* message position    */
    size_t paramsPos  = str.find(" ");	 /* parameters position */

    if(messagePos != string::npos)
    {
        smObject = GetSMHandle(str.substr ( 0,messagePos).c_str());

        if(smObject != NULL)
        {
           size_t smMessageNameLen = 1 + strlen(str.substr ( messagePos+2,paramsPos-(messagePos+2)).c_str());

        	smMessage = new char[smMessageNameLen];
            if (!smMessage) {
            	ret = FW_ERR_DISP_NO_MEM;
            	goto end;
            }

            strcpy(smMessage,str.substr ( messagePos+2,paramsPos-(messagePos+2)).c_str());
            smMessage[smMessageNameLen-1] = 0; // end the string
            if(paramsPos != string::npos)
            {
                msgParams =	new char[1 + strlen(str.substr ( paramsPos+1).c_str())];
                if (!msgParams) {
                	ret = FW_ERR_DISP_NO_MEM;
                	goto end;
                }

                strcpy(msgParams,str.substr ( paramsPos+1).c_str());
            }

            if(answer != NULL )
            {
                /* Split the answer into SM object name and answer message name*/
                string strAnswer(answer);
                size_t answerPos = strAnswer.find("::");  /* message position    */

                if(answerPos != string::npos)
                {
                    SMF* answerSMObject = GetSMHandle(strAnswer.substr( 0, answerPos ).c_str());

                    /* Register release event*/
                    if(answerSMObject != NULL)
                    {
                        answerSMObject->RegisterReleaseEvent(strAnswer.substr( answerPos+2 ).c_str());
                    }
                }

                ret = smObject->SendEventAnswerByName(smMessage, (char*)answer, msgParams);
                // error in sending?
                if (ret != 0) {
                	ETG_TRACE_ERR(("Error %d on dispatching message/answer %48s/%s", ret, message, answer));
                }
            }
            else
            {
                ret = smObject->SendEventByName(smMessage,msgParams);
                // error in sending?
                if (ret != 0) {
                	ETG_TRACE_ERR(("Error %d on dispatching message %s ", ret, message));
                }
            }

            delete[] smMessage;

            if (msgParams) {
                delete[] msgParams ;
            }

            if (ret == 0) {
            	ETG_TRACE_USR4(("Dispatched State machine message %64s to SMObj=0x%x",message, smObject));
            }

        }
        else
        {
#ifdef VARIANT_S_FTR_ENABLE_FW_REMOTE_SM_MANAGER
            /* if the message should be routed to another process */
            if (!localOnly) {

                /* No local state machine registered as expected in the input message name*/
                ETG_TRACE_USR1(("dbus-broadcast: %s",message));

                /* if an answer is defined, register it as release event in case the remote state machine does not answer */
                if(answer != NULL )
                {
                    /* Split the answer into SM object name and answer message name*/
                    string strAnswer(answer);
                    size_t answerPos = strAnswer.find("::");  /* message position    */

                    if(answerPos != string::npos)
                    {
                        SMF* answerSMObject = GetSMHandle(strAnswer.substr( 0, answerPos ).c_str());

                        /* Register release event*/
                        if(answerSMObject != NULL)
                        {
                            answerSMObject->RegisterReleaseEvent(strAnswer.substr( answerPos+2 ).c_str());
                        }
                    }
                }

                /* send this message to other process(es) */
                ret = mRemoteStateMachineManager.SendMessage(message, answer);
                if (ret != FW_NO_ERROR) {
                    ETG_TRACE_ERR(("Dispatcher::SendMessage: error %d in sending via RemoteStateMachineManager", ret));
                }
            /* message should be send only to local state machines */
            }
            else
#endif
            {
                ETG_TRACE_ERR(("Dispatcher::SendMessage: Statemachine not registered: %s", message));
                ret = FW_ERR_DISP_SM_NOT_REGISTERED;
            }
        }
    }
    else
    {
        ETG_TRACE_ERR(("Dispatcher::SendMessage->message(%s) is not in the expected format. It should be SMName::eventName ",message));
        ret = FW_ERR_DISP_WRONG_ADRESS_FORMAT;
    }

end:
    mActiveStateMachinesLock.unlock();
    return ret;
}

int Dispatcher::SendMessageAnswer(const char *message ,const char *answer)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_REMOTE_SM_MANAGER
    return SendMessageAnswerInternal(message, answer, 0);
#else
    return SendMessageAnswerInternal(message, answer, 1);
#endif
}


int Dispatcher::SendMessageAnswerLocal(const char *message, const char *answer)
{
    return SendMessageAnswerInternal(message, answer, 1);
}

int Dispatcher::SendMessageAnswer(const char *message, const char *parameter, const char *answer)
{
    FW_IF_NULL_PTR_RETURN_ERROR(message, FW_ERR_DISP_GEN_ERROR);

	ENTRY_INTERNAL
    char *_message;
    int res = FW_ERR_DISP_GEN_ERROR;

    /* parameter empty? send pure message */
    if (!parameter) return SendMessageAnswer(message, answer);

    /* create the message buffer */
    _message = (char *)malloc(strlen(message) + 1 + strlen(parameter) + 1);
    if (!_message) return FW_ERR_DISP_NO_MEM;

    /* fill it */
    strcpy(_message, message);
    strcat(_message, " ");
    strcat(_message, parameter);

    /* send it */
    res = SendMessageAnswer(_message, answer);

    /* free it */
    free(_message);

    return res;
}

int Dispatcher::SendMessage(const char *message )
{
	ENTRY_INTERNAL
    return SendMessageAnswer(message,NULL);
}

int Dispatcher::SendMessage(const char *message, const char *parameter )
{
    FW_IF_NULL_PTR_RETURN_ERROR(message, FW_ERR_DISP_GEN_ERROR);

	ENTRY_INTERNAL
    char *_message;
    int res;

    /* parameter empty? send pure message */
    if (!parameter) return SendMessage(message);

    /* create the message buffer */
    _message = (char *)malloc(strlen(message) + 1 + strlen(parameter) + 1);
    if (!_message) return FW_ERR_DISP_NO_MEM;

    /* fill it */
    strcpy(_message, message);
    strcat(_message, " ");
    strcat(_message, parameter);

    /* send it */
    res = SendMessageAnswer(_message,NULL);

    /* free it */
    free(_message);

    return res;
}
