/**
 * @file FwTestCommandData.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Test command data.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of test command data.
 */

#ifndef _FW_TEST_COMMAND_DATA_H_
#define _FW_TEST_COMMAND_DATA_H_

namespace fw {

/**
 *
 */
class TestCommandData
{
public:
   /**
    * Default constructor.
    */
   TestCommandData();

   /**
    * Destructor.
    */
   virtual ~TestCommandData();

   /**
    * Get U8 data.
    *
    * @param[in] data: test data stream
    *
    * @return = U8 data
    */
   unsigned char getU8Value(const unsigned char* data) const;

   /**
    * Get U16 data.
    *
    * @param[in] data: test data stream
    *
    * @return = U16 data
    */
   unsigned short int getU16Value(const unsigned char* data) const;

   /**
    * Get U32 data.
    *
    * @param[in] data: test data stream
    *
    * @return = U32 data
    */
   unsigned int getU32Value(const unsigned char* data) const;

   /**
    * Get string data.
    *
    * @param[in] data: test data stream
    * @param[in] length: length of data to be extracted
    *
    * @return = string data
    */
   const char* getStringValue(const unsigned char* data, const unsigned int length);

private:
   char _string[256]; /**< buffer for string data */
};

} //fw

#endif //_FW_TEST_COMMAND_DATA_H_
