/**
 * @file FwITestCommandClient.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Test command interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Interface to handle test commands is defined here.
 */

#ifndef _FW_I_TEST_COMMAND_CLIENT_H_
#define _FW_I_TEST_COMMAND_CLIENT_H_

namespace fw {

/**
 *
 */
class ITestCommandClient
{
public:
   /**
    * Destructor.
    */
   virtual ~ITestCommandClient() {}

   /**
    * Handle received test command.
    *
    * @param[in] data: test command
    */
   virtual void handleTestCommand(const unsigned char* data) = 0;
};

} //fw

#endif //_FW_I_TEST_COMMAND_CLIENT_H_
