/**
 * @file FwISingleThreadFunction.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Single thread interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Single thread interface.
 */

#ifndef _FW_I_SINGLE_THREAD_FUNCTION_H_
#define _FW_I_SINGLE_THREAD_FUNCTION_H_

namespace fw {

/**
 *
 */
class ISingleThreadFunction
{
public:
   /**
    * Destructor.
    */
   virtual ~ISingleThreadFunction() {}

   /**
    * Thread function to be implemented.
    *
    * @param[in] arguments: arguments
    */
   virtual void threadFunction(void* arguments) = 0;

   /**
    * Set terminate function to be implemented. Client shall ensure that the thread execution is stopped.
    *
    * @param[in] arguments: arguments
    */
   virtual void setTerminate(void* arguments) = 0;
};

} //fw

#endif //_FW_I_SINGLE_THREAD_FUNCTION_H_
