/**
 * @file FwIEventMaster.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Event master interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Event master interface.
 */

#ifndef _FW_I_EVENT_MASTER_H_
#define _FW_I_EVENT_MASTER_H_

#include <string>

namespace fw {

// class forward declarations
class IEventHandler;

/**
 *
 */
class IEventMaster
{
public:
   /**
    * Destructor.
    */
   virtual ~IEventMaster() {}

   /**
    * Create.
    * <BR><B>ATTENTION: This method shall be called before event master is used for push() calls.</B>
    *
    * @param[in] threadName: name of event master thread
    * @param[in] numberPriorities: number of priorities (example: numberPriorities=2: event queues with priority 0 (highest) and 1 (lowest) will be created)
    */
   virtual void create(const ::std::string& threadName, const unsigned int numberPriorities = 1) = 0;

   /**
    * Destroy.
    */
   virtual void destroy(void) = 0;

   /**
    * Push an event handler to internal list to be processed.
    *
    * @param[in] eventHandler: event handler
    * @param[in] priority: priority (must be less than number of priorities, see create() method)
    */
   virtual void push(IEventHandler* eventHandler, const unsigned int priority) = 0;
};

} //fw

#endif //_FW_I_EVENT_MASTER_H_
