/**
 * @file FwIEventHandler.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Event handler interface.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Event handler interface.
 */

#ifndef _FW_I_EVENT_HANDLER_H_
#define _FW_I_EVENT_HANDLER_H_

namespace fw {

// class forward declarations
class IEventMaster;

/**
 *
 */
class IEventHandler
{
public:
   /**
    * Destructor.
    */
   virtual ~IEventHandler() {}

   /**
    * Register event master.
    *
    * @param[in] master: event master
    * @param[in] priority: event priority to be used (must be less than number of priorities)
    */
   virtual void registerMaster(IEventMaster* master, const unsigned int priority) = 0;

   /**
    * Process event function.
    */
   virtual void processEvent(void) = 0;
};

} //fw

#endif //_FW_I_EVENT_HANDLER_H_
