/**
 * @file FwErrmemPrint.h
 *
 * @par SW-Component
 * Framework
 *
 * @brief Error memory print.
 *
 * @copyright (C) 2017 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Error memory print declaration.
 */

#ifndef _FW_ERRMEM_PRINT_H_
#define _FW_ERRMEM_PRINT_H_

#define FW_ERRMEM_ASSERT(__ERR_EXP__) if(!(__ERR_EXP__)) { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", #__ERR_EXP__, __LINE__, __FILE__); }
#define FW_ERRMEM_ASSERT_ALWAYS() { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", "ALWAYS", __LINE__, __FILE__); }
#define FW_ERRMEM_IF_FALSE_RETURN(__ERR_EXP__) if(!(__ERR_EXP__)) { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", #__ERR_EXP__, __LINE__, __FILE__); return; }
#define FW_ERRMEM_IF_FALSE_RETURN_ERROR(__ERR_EXP__, __ERR_CODE__) if(!(__ERR_EXP__)) { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", #__ERR_EXP__, __LINE__, __FILE__); return __ERR_CODE__; }
#define FW_ERRMEM_IF_NULL_PTR_RETURN(__ERR_EXP__) if(0 == __ERR_EXP__) { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", #__ERR_EXP__, __LINE__, __FILE__); return; }
#define FW_ERRMEM_IF_NULL_PTR_RETURN_FALSE(__ERR_EXP__) if(0 == __ERR_EXP__) { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", #__ERR_EXP__, __LINE__, __FILE__); return false; }
#define FW_ERRMEM_IF_NULL_PTR_RETURN_TRUE(__ERR_EXP__) if(0 == __ERR_EXP__) { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", #__ERR_EXP__, __LINE__, __FILE__); return true; }
#define FW_ERRMEM_IF_NULL_PTR_RETURN_NULL(__ERR_EXP__) if(0 == __ERR_EXP__) { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", #__ERR_EXP__, __LINE__, __FILE__); return 0; }
#define FW_ERRMEM_IF_NULL_PTR_RETURN_ERROR(__ERR_EXP__, __ERR_CODE__) if(0 == __ERR_EXP__) { ::fw::ErrmemPrint errmemPrint("#CONN: ASSERT", #__ERR_EXP__, __LINE__, __FILE__); return __ERR_CODE__; }

namespace fw {

/**
 *
 */
class ErrmemPrint
{
public:
   /**
    * Default constructor.
    */
   ErrmemPrint();

   /**
    * Constructor.
    *
    * @param[in] leadingPart: leading part for error memory entry
    * @param[in] expression: expression causing error memory entry
    * @param[in] lineNumber: line number of location printing error memory entry
    * @param[in] fileName: file name of location printing error memory entry
    */
   ErrmemPrint(const char* leadingPart, const char* expression, const unsigned int lineNumber, const char* fileName);

   /**
    * Destructor.
    */
   virtual ~ErrmemPrint();
};

} //fw

#endif //_FW_ERRMEM_PRINT_H_
